/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FunctionalInterfaceSuggester;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceParameter.InplaceIntroduceParameterPopup;
import com.intellij.refactoring.introduceParameter.IntroduceParameterDialog;
import com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor;
import com.intellij.refactoring.introduceParameter.Util;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.ui.MethodCellRenderer;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.JavaNameSuggestionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairConsumer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class IntroduceParameterHandler
extends IntroduceHandlerBase {
    private static final Logger LOG = Logger.getInstance(IntroduceParameterHandler.class);
    private JBPopup myEnclosingMethodsPopup;
    private InplaceIntroduceParameterPopup myInplaceIntroduceParameterPopup;

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        if (project == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(0);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        ElementToWorkOn.processElementToWorkOn((Editor)editor, (PsiFile)file, (String)IntroduceParameterHandler.getRefactoringName(), (String)"refactoring.introduceParameter", (Project)project, (ElementToWorkOn.ElementsProcessor)new ElementToWorkOn.ElementsProcessor<ElementToWorkOn>(){

            public boolean accept(ElementToWorkOn el) {
                return true;
            }

            public void pass(ElementToWorkOn elementToWorkOn) {
                if (elementToWorkOn == null) {
                    return;
                }
                if (elementToWorkOn.getLocalVariable() == null && elementToWorkOn.getExpression() == null) {
                    if (!IntroduceParameterHandler.this.introduceStrategy(project, editor, file)) {
                        ElementToWorkOn.showNothingSelectedErrorMessage((Editor)editor, (String)IntroduceParameterHandler.getRefactoringName(), (String)"refactoring.introduceParameter", (Project)project);
                    }
                    return;
                }
                PsiExpression expr = elementToWorkOn.getExpression();
                PsiLocalVariable localVar = elementToWorkOn.getLocalVariable();
                boolean isInvokedOnDeclaration = elementToWorkOn.isInvokedOnDeclaration();
                IntroduceParameterHandler.this.invoke(editor, project, expr, localVar, isInvokedOnDeclaration);
            }
        });
    }

    @Override
    protected boolean invokeImpl(Project project, PsiExpression tempExpr, Editor editor) {
        return this.invoke(editor, project, tempExpr, null, false);
    }

    @Override
    protected boolean invokeImpl(Project project, PsiLocalVariable localVariable, Editor editor) {
        return this.invoke(editor, project, null, localVariable, true);
    }

    private boolean invoke(Editor editor, Project project, PsiExpression expr, PsiLocalVariable localVar, boolean invokedOnDeclaration) {
        PsiType typeByExpression;
        PsiElement parent;
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).hasUncommitedDocuments());
        PsiMethod method = expr != null ? Util.getContainingMethod((PsiElement)expr) : Util.getContainingMethod((PsiElement)localVar);
        if (LOG.isDebugEnabled()) {
            LOG.debug("expression:" + String.valueOf(expr));
        }
        if (expr == null && localVar == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"selected.block.should.represent.an.expression", (Object[])new Object[0]));
            IntroduceParameterHandler.showErrorMessage(project, message, editor);
            return false;
        }
        if (localVar != null && !((parent = localVar.getParent()) instanceof PsiDeclarationStatement)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"error.wrong.caret.position.local.or.expression.name", (Object[])new Object[0]));
            IntroduceParameterHandler.showErrorMessage(project, message, editor);
            return false;
        }
        if (method == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{IntroduceParameterHandler.getRefactoringName()}));
            IntroduceParameterHandler.showErrorMessage(project, message, editor);
            return false;
        }
        PsiType psiType = typeByExpression = invokedOnDeclaration ? null : CommonJavaRefactoringUtil.getTypeByExpressionWithExpectedType((PsiExpression)expr);
        if (!invokedOnDeclaration && (typeByExpression == null || LambdaUtil.notInferredType((PsiType)typeByExpression))) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"type.of.the.selected.expression.cannot.be.determined", (Object[])new Object[0]));
            IntroduceParameterHandler.showErrorMessage(project, message, editor);
            return false;
        }
        if (!invokedOnDeclaration && PsiTypes.voidType().equals((Object)typeByExpression)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"selected.expression.has.void.type", (Object[])new Object[0]));
            IntroduceParameterHandler.showErrorMessage(project, message, editor);
            return false;
        }
        List validEnclosingMethods = CommonJavaRefactoringUtil.getEnclosingMethods((PsiMethod)method);
        if (validEnclosingMethods.isEmpty()) {
            return false;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return false;
        }
        Introducer introducer = new Introducer(project, expr, localVar, editor);
        AbstractInplaceIntroducer inplaceIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)editor);
        if (inplaceIntroducer instanceof InplaceIntroduceParameterPopup) {
            InplaceIntroduceParameterPopup introduceParameterPopup = (InplaceIntroduceParameterPopup)inplaceIntroducer;
            introducer.introduceParameter(introduceParameterPopup.getMethodToIntroduceParameter(), introduceParameterPopup.getMethodToSearchFor());
            return true;
        }
        this.chooseMethodToIntroduceParameter(editor, validEnclosingMethods, (PairConsumer<? super PsiMethod, ? super PsiMethod>)((PairConsumer)(methodToSearchIn, methodToSearchFor) -> introducer.introduceParameter((PsiMethod)methodToSearchIn, (PsiMethod)methodToSearchFor)));
        return true;
    }

    private void chooseMethodToIntroduceParameter(Editor editor, @NotNull List<? extends PsiMethod> validEnclosingMethods, @NotNull PairConsumer<? super PsiMethod, ? super PsiMethod> consumer) {
        PsiMethod methodToIntroduceParameterTo;
        if (validEnclosingMethods == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(2);
        }
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if ((validEnclosingMethods.size() == 1 || unitTestMode) && ((methodToIntroduceParameterTo = validEnclosingMethods.get(0)).findDeepestSuperMethod() == null || unitTestMode)) {
            consumer.consume((Object)methodToIntroduceParameterTo, (Object)methodToIntroduceParameterTo);
            return;
        }
        JPanel panel = new JPanel(new BorderLayout());
        JCheckBox superMethod = new JCheckBox(JavaRefactoringBundle.message((String)"introduce.parameter.super.method.checkbox", (Object[])new Object[0]), true);
        panel.add((Component)superMethod, "South");
        JBList list = new JBList((Object[])validEnclosingMethods.toArray(PsiMethod.EMPTY_ARRAY));
        list.setVisibleRowCount(5);
        list.setCellRenderer((ListCellRenderer)new MethodCellRenderer());
        list.getSelectionModel().setSelectionMode(0);
        list.setSelectedIndex(0);
        final ArrayList highlighters = new ArrayList();
        list.addListSelectionListener(__ -> {
            PsiMethod selectedMethod = (PsiMethod)list.getSelectedValue();
            if (selectedMethod == null) {
                return;
            }
            IntroduceParameterHandler.dropHighlighters(highlighters);
            IntroduceParameterHandler.updateView(selectedMethod, editor, highlighters, superMethod);
        });
        IntroduceParameterHandler.updateView(validEnclosingMethods.get(0), editor, highlighters, superMethod);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)list);
        scrollPane.setBorder(null);
        panel.add((Component)scrollPane, "Center");
        List<Pair> keyboardActions = Collections.singletonList(Pair.create(__ -> {
            PsiMethod methodToSearchIn = (PsiMethod)list.getSelectedValue();
            if (this.myEnclosingMethodsPopup != null && this.myEnclosingMethodsPopup.isVisible()) {
                this.myEnclosingMethodsPopup.cancel();
            }
            PsiMethod methodToSearchFor = superMethod.isEnabled() && superMethod.isSelected() ? methodToSearchIn.findDeepestSuperMethod() : methodToSearchIn;
            WriteIntentReadAction.run(() -> consumer.consume((Object)methodToSearchIn, (Object)methodToSearchFor));
        }, (Object)KeyStroke.getKeyStroke(10, 0)));
        this.myEnclosingMethodsPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)list).setTitle(RefactoringBundle.message((String)"refactoring.introduce.parameter.popup.title")).setMovable(false).setResizable(false).setRequestFocus(true).setKeyboardActions(keyboardActions).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                IntroduceParameterHandler.dropHighlighters(highlighters);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler$2", "onClosed"));
            }
        }).createPopup();
        this.myEnclosingMethodsPopup.showInBestPositionFor(editor);
    }

    private static void updateView(PsiMethod selectedMethod, Editor editor, List<? super RangeHighlighter> highlighters, JCheckBox superMethod) {
        MarkupModel markupModel = editor.getMarkupModel();
        PsiIdentifier nameIdentifier = selectedMethod.getNameIdentifier();
        if (nameIdentifier != null) {
            TextRange textRange = nameIdentifier.getTextRange();
            RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, textRange.getStartOffset(), textRange.getEndOffset(), 5999, HighlighterTargetArea.EXACT_RANGE);
            highlighters.add((RangeHighlighter)rangeHighlighter);
        }
        superMethod.setEnabled(selectedMethod.findDeepestSuperMethod() != null);
    }

    private static void dropHighlighters(List<? extends RangeHighlighter> highlighters) {
        for (RangeHighlighter rangeHighlighter : highlighters) {
            rangeHighlighter.dispose();
        }
        highlighters.clear();
    }

    @NotNull
    static NameSuggestionsGenerator createNameSuggestionGenerator(PsiExpression expr, String propName, Project project, String enteredName) {
        NameSuggestionsGenerator nameSuggestionsGenerator = type -> {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, propName, expr != null && expr.isValid() ? expr : null, type);
            if (expr != null && expr.isValid()) {
                info = codeStyleManager.suggestUniqueVariableName(info, (PsiElement)expr, true);
            }
            String[] strings = JavaNameSuggestionUtil.appendUnresolvedExprName((String[])JavaCompletionUtil.completeVariableNameForRefactoring((JavaCodeStyleManager)codeStyleManager, (PsiType)type, (VariableKind)VariableKind.LOCAL_VARIABLE, (SuggestedNameInfo)info), (PsiExpression)expr);
            return new SuggestedNameInfo.Delegate(enteredName != null ? ArrayUtil.mergeArrays((String[])new String[]{enteredName}, (String[])strings) : strings, info);
        };
        if (nameSuggestionsGenerator == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(3);
        }
        return nameSuggestionsGenerator;
    }

    private static void showErrorMessage(Project project, @NlsContexts.DialogMessage String message, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)IntroduceParameterHandler.getRefactoringName(), (String)"refactoring.introduceParameter");
    }

    @Override
    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(5);
        }
    }

    public AbstractInplaceIntroducer getInplaceIntroducer() {
        return this.myInplaceIntroduceParameterPopup;
    }

    @VisibleForTesting
    private boolean introduceStrategy(Project project, Editor editor, PsiFile file) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            PsiElement[] elements = CodeInsightUtil.findStatementsInRange((PsiFile)file, (int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd());
            return this.introduceStrategy(project, editor, file, elements);
        }
        return false;
    }

    @VisibleForTesting
    public boolean introduceStrategy(final @NotNull Project project, final Editor editor, @NotNull PsiFile file, final PsiElement @NotNull [] elements) {
        if (project == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(6);
        }
        if (file == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(7);
        }
        if (elements == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(8);
        }
        if (elements.length > 0) {
            AbstractInplaceIntroducer inplaceIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)editor);
            if (inplaceIntroducer instanceof InplaceIntroduceParameterPopup) {
                return false;
            }
            PsiMethod containingMethod = Util.getContainingMethod(elements[0]);
            if (containingMethod == null) {
                return false;
            }
            final List enclosingMethods = CommonJavaRefactoringUtil.getEnclosingMethods((PsiMethod)containingMethod);
            if (enclosingMethods.isEmpty()) {
                return false;
            }
            PsiElement[] elementsCopy = IntroduceParameterHandler.getElementsInCopy(project, file, elements);
            PsiMethod containingMethodCopy = Util.getContainingMethod(elementsCopy[0]);
            LOG.assertTrue(containingMethodCopy != null);
            List enclosingMethodsInCopy = CommonJavaRefactoringUtil.getEnclosingMethods((PsiMethod)containingMethodCopy);
            final MyExtractMethodProcessor processor = new MyExtractMethodProcessor(project, editor, elementsCopy, (PsiMethod)enclosingMethodsInCopy.getLast());
            try {
                if (!processor.prepare()) {
                    return false;
                }
                processor.showDialog();
                PsiMethod emptyMethod = processor.generateEmptyMethod("name", elements[0]);
                Collection types = FunctionalInterfaceSuggester.suggestFunctionalInterfaces((PsiMethod)emptyMethod);
                if (types.isEmpty()) {
                    return false;
                }
                if (types.size() != 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                    final LinkedHashMap<PsiClass, PsiType> classes = new LinkedHashMap<PsiClass, PsiType>();
                    for (PsiType type : types) {
                        classes.put(PsiUtil.resolveClassInType((PsiType)type), type);
                    }
                    PsiClass[] psiClasses = classes.keySet().toArray(PsiClass.EMPTY_ARRAY);
                    String methodSignature = PsiFormatUtil.formatMethod((PsiMethod)emptyMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)256, (int)2);
                    PsiType returnType = emptyMethod.getReturnType();
                    LOG.assertTrue(returnType != null);
                    String title = RefactoringBundle.message((String)"refactoring.introduce.parameter.interface.chooser.popup.title", (Object[])new Object[]{methodSignature, returnType.getPresentableText()});
                    new PsiTargetNavigator((PsiElement[])psiClasses).createPopup(project, title, (PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                        public boolean execute(@NotNull PsiClass psiClass) {
                            if (psiClass == null) {
                                3.$$$reportNull$$$0(0);
                            }
                            IntroduceParameterHandler.this.functionalInterfaceSelected((PsiType)classes.get(psiClass), enclosingMethods, project, editor, processor, elements);
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler$3", "execute"));
                        }
                    }).showInBestPositionFor(editor);
                    return true;
                }
                PsiType next = (PsiType)types.iterator().next();
                this.functionalInterfaceSelected(next, enclosingMethods, project, editor, processor, elements);
                return true;
            }
            catch (PrepareFailedException | IncorrectOperationException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static PsiElement @NotNull [] getElementsInCopy(@NotNull Project project, @NotNull PsiFile file, PsiElement @NotNull [] elements) {
        if (project == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(9);
        }
        if (file == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(10);
        }
        if (elements == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(11);
        }
        return IntroduceParameterHandler.getElementsInCopy(project, file, elements, true);
    }

    public static PsiElement @NotNull [] getElementsInCopy(@NotNull Project project, @NotNull PsiFile file, PsiElement @NotNull [] elements, boolean reuseNonPhysical) {
        PsiElement[] elementsCopy;
        if (project == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(12);
        }
        if (file == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(13);
        }
        if (elements == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(14);
        }
        if (reuseNonPhysical && !elements[0].isPhysical()) {
            elementsCopy = elements;
        } else {
            PsiFile copy = PsiFileFactory.getInstance((Project)project).createFileFromText(file.getName(), file.getFileType(), (CharSequence)file.getText(), file.getModificationStamp(), false);
            ((PsiFileImpl)copy).setOriginalFile(file);
            TextRange range = new TextRange(elements[0].getTextRange().getStartOffset(), elements[elements.length - 1].getTextRange().getEndOffset());
            PsiExpression exprInRange = CodeInsightUtil.findExpressionInRange((PsiFile)copy, (int)range.getStartOffset(), (int)range.getEndOffset());
            if (exprInRange != null) {
                PsiElement[] psiElementArray = new PsiElement[1];
                v1 = psiElementArray;
                psiElementArray[0] = exprInRange;
            } else {
                v1 = elementsCopy = CodeInsightUtil.findStatementsInRange((PsiFile)copy, (int)range.getStartOffset(), (int)range.getEndOffset());
            }
        }
        if (elementsCopy.length == 1 && elementsCopy[0].getUserData(ElementToWorkOn.PARENT) == null) {
            elementsCopy[0].putUserData(ElementToWorkOn.REPLACE_NON_PHYSICAL, (Object)true);
        }
        if (elementsCopy == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(15);
        }
        return elementsCopy;
    }

    private void functionalInterfaceSelected(PsiType selectedType, List<? extends PsiMethod> enclosingMethods, Project project, Editor editor, MyExtractMethodProcessor processor, PsiElement[] elements) {
        PairConsumer consumer = (methodToIntroduceParameter, methodToSearchFor) -> this.introduceWrappedCodeBlockParameter((PsiMethod)methodToIntroduceParameter, (PsiMethod)methodToSearchFor, editor, project, selectedType, processor, elements);
        this.chooseMethodToIntroduceParameter(editor, enclosingMethods, (PairConsumer<? super PsiMethod, ? super PsiMethod>)consumer);
    }

    private void introduceWrappedCodeBlockParameter(PsiMethod methodToIntroduceParameter, PsiMethod methodToSearchFor, Editor editor, Project project, PsiType selectedType, ExtractMethodProcessor processor, PsiElement[] elements) {
        if (!elements[0].isValid()) {
            return;
        }
        PsiElement commonParent = IntroduceParameterHandler.findCommonParent(elements);
        if (commonParent == null) {
            LOG.error("Should have common parent:" + Arrays.toString(elements));
            return;
        }
        RangeMarker marker = editor.getDocument().createRangeMarker(commonParent.getTextRange());
        Object[] copyElements = processor.getElements();
        PsiElement containerCopy = IntroduceParameterHandler.findCommonParent((PsiElement[])copyElements);
        if (containerCopy == null) {
            LOG.error("Should have common parent:" + Arrays.toString(copyElements));
            return;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)selectedType);
        PsiClass wrapperClass = resolveResult.getElement();
        LOG.assertTrue(wrapperClass != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        Ref suffixText = new Ref();
        Ref prefixText = new Ref();
        Ref methodText = new Ref();
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)wrapperClass);
            LOG.assertTrue(method != null);
            String interfaceMethodName = method.getName();
            processor.setMethodName(interfaceMethodName);
            processor.doExtract();
            PsiMethod extractedMethod = processor.getExtractedMethod();
            PsiParameter[] parameters = extractedMethod.getParameterList().getParameters();
            PsiParameter[] interfaceParameters = method.getParameterList().getParameters();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            for (int i = 0; i < interfaceParameters.length; ++i) {
                PsiTypeElement typeAfterInterface = factory.createTypeElement(substitutor.substitute(interfaceParameters[i].getType()));
                PsiTypeElement typeElement = parameters[i].getTypeElement();
                if (typeElement == null) continue;
                typeElement.replace((PsiElement)typeAfterInterface);
            }
            methodText.set((Object)extractedMethod.getText());
            PsiMethodCallExpression methodCall = processor.getMethodCall();
            prefixText.set((Object)containerCopy.getText().substring(0, methodCall.getTextRange().getStartOffset() - containerCopy.getTextRange().getStartOffset()));
            suffixText.set((Object)("." + methodCall.getText() + containerCopy.getText().substring(methodCall.getTextRange().getEndOffset() - containerCopy.getTextRange().getStartOffset())));
        });
        PsiExpression expression = factory.createExpressionFromText("new " + selectedType.getCanonicalText() + "() {" + (String)methodText.get() + "}", elements[0]);
        expression = (PsiExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)expression);
        expression.putUserData(ElementToWorkOn.PARENT, (Object)commonParent);
        expression.putUserData(ElementToWorkOn.PREFIX, (Object)((String)prefixText.get()));
        expression.putUserData(ElementToWorkOn.SUFFIX, (Object)((String)suffixText.get()));
        expression.putUserData(ElementToWorkOn.TEXT_RANGE, (Object)marker);
        expression.putUserData(ElementToWorkOn.EXPR_RANGE, elements.length == 1 ? elements[0].getTextRange() : null);
        new Introducer(project, expression, null, editor).introduceParameter(methodToIntroduceParameter, methodToSearchFor);
    }

    @Nullable
    private static PsiElement findCommonParent(PsiElement[] copyElements) {
        if (copyElements.length > 1) {
            return PsiTreeUtil.findCommonParent((PsiElement[])copyElements);
        }
        PsiElement parent = (PsiElement)copyElements[0].getUserData(ElementToWorkOn.PARENT);
        if (parent == null) {
            parent = copyElements[0].getParent();
        }
        return PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCodeBlock.class, (boolean)false);
    }

    @NlsContexts.DialogTitle
    static String getRefactoringName() {
        return RefactoringBundle.message((String)"introduce.parameter.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validEnclosingMethods";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNameSuggestionGenerator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsInCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "chooseMethodToIntroduceParameter";
                break;
            }
            case 3: 
            case 15: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "introduceStrategy";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getElementsInCopy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 15 -> new IllegalStateException(string);
        };
    }

    private class Introducer {
        private final Project myProject;
        private PsiExpression myExpr;
        private PsiLocalVariable myLocalVar;
        private final Editor myEditor;

        Introducer(Project project, PsiExpression expr, PsiLocalVariable localVar, Editor editor) {
            this.myProject = project;
            this.myExpr = expr;
            this.myLocalVar = localVar;
            this.myEditor = editor;
        }

        public void introduceParameter(PsiMethod method, PsiMethod methodToSearchFor) {
            ExpressionOccurrenceManager occurrenceManager = this.myExpr != null ? new ExpressionOccurrenceManager(this.myExpr, (PsiElement)method, null) : null;
            PsiExpression[] occurrences = this.myExpr != null ? occurrenceManager.findExpressionOccurrences() : CodeInsightUtil.findReferenceExpressions((PsiElement)method, (PsiElement)this.myLocalVar);
            if (this.myExpr != null && AbstractInplaceIntroducer.getActiveIntroducer((Editor)this.myEditor) == null) {
                IntroduceVariableBase.OccurrencesInfo occurrencesInfo = new IntroduceVariableBase.OccurrencesInfo(occurrences, false);
                LinkedHashMap<IntroduceVariableBase.JavaReplaceChoice, List<PsiExpression>> occurrencesMap = occurrencesInfo.buildOccurrencesMap(this.myExpr);
                IntroduceVariableBase.createOccurrencesChooser(this.myEditor).showChooser(occurrencesMap, RefactoringBundle.message((String)"replace.multiple.occurrences.found"), choice -> {
                    PsiExpression[] selectedOccurrences = choice.filter(occurrenceManager);
                    this.introduceParameter(method, methodToSearchFor, selectedOccurrences, (IntroduceVariableBase.JavaReplaceChoice)choice);
                });
            } else {
                this.introduceParameter(method, methodToSearchFor, occurrences, IntroduceVariableBase.JavaReplaceChoice.ALL);
            }
        }

        private void introduceParameter(PsiMethod method, PsiMethod methodToSearchFor, PsiExpression[] occurrences, @NotNull IntroduceVariableBase.JavaReplaceChoice replaceChoice) {
            boolean isInplaceAvailableOnDataContext;
            if (replaceChoice == null) {
                Introducer.$$$reportNull$$$0(0);
            }
            String enteredName = null;
            boolean delegate = false;
            PsiType initializerType = IntroduceParameterProcessor.getInitializerType(null, this.myExpr, this.myLocalVar);
            InplaceIntroduceParameterPopup activeIntroducer = (InplaceIntroduceParameterPopup)AbstractInplaceIntroducer.getActiveIntroducer((Editor)this.myEditor);
            if (activeIntroducer != null) {
                activeIntroducer.stopIntroduce(this.myEditor);
                this.myExpr = (PsiExpression)activeIntroducer.getExpr();
                this.myLocalVar = (PsiLocalVariable)activeIntroducer.getLocalVariable();
                occurrences = (PsiExpression[])activeIntroducer.getOccurrences();
                enteredName = activeIntroducer.getInputName();
                replaceChoice = activeIntroducer.getReplaceChoice();
                delegate = activeIntroducer.isGenerateDelegate();
                initializerType = activeIntroducer.getType();
            }
            boolean mustBeFinal = false;
            if (this.myExpr != null) {
                PsiExpression[] parent = (PsiExpression[])this.myExpr.getUserData(ElementToWorkOn.PARENT);
                mustBeFinal = parent != null && PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiClass.class, PsiMethod.class}) != method;
            }
            for (PsiExpression occurrence : occurrences) {
                if (!occurrence.isPhysical() || PsiTreeUtil.getParentOfType((PsiElement)occurrence, (Class[])new Class[]{PsiClass.class, PsiMethod.class}) == method) continue;
                mustBeFinal = true;
                break;
            }
            String propName = this.myLocalVar != null ? JavaCodeStyleManager.getInstance((Project)this.myProject).variableNameToPropertyName(this.myLocalVar.getName(), VariableKind.LOCAL_VARIABLE) : null;
            boolean bl = isInplaceAvailableOnDataContext = this.myEditor != null && this.myEditor.getSettings().isVariableInplaceRenameEnabled();
            if (this.myExpr != null) {
                isInplaceAvailableOnDataContext &= this.myExpr.isPhysical();
            }
            if (isInplaceAvailableOnDataContext && activeIntroducer == null) {
                IntroduceParameterHandler.this.myInplaceIntroduceParameterPopup = new InplaceIntroduceParameterPopup(this.myProject, this.myEditor, this.createTypeSelectorManager(occurrences, initializerType), this.myExpr, this.myLocalVar, method, methodToSearchFor, occurrences, this.getParamsToRemove(method, occurrences), mustBeFinal, replaceChoice);
                if (IntroduceParameterHandler.this.myInplaceIntroduceParameterPopup.startInplaceIntroduceTemplate()) {
                    return;
                }
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                @NonNls String parameterName = "anObject";
                PsiExpression initializer = this.myLocalVar != null && this.myExpr == null ? this.myLocalVar.getInitializer() : this.myExpr;
                new IntroduceParameterProcessor(this.myProject, method, methodToSearchFor, initializer, this.myExpr, this.myLocalVar, true, parameterName, replaceChoice, 0, mustBeFinal, false, false, null, this.getParamsToRemove(method, occurrences)).run();
            } else {
                if (this.myEditor != null) {
                    RefactoringUtil.highlightAllOccurrences(this.myProject, (PsiElement[])occurrences, this.myEditor);
                }
                ArrayList classMemberRefs = new ArrayList();
                if (this.myExpr != null) {
                    Util.analyzeExpression(this.myExpr, new ArrayList(), classMemberRefs, new ArrayList());
                }
                this.showDialog(method, methodToSearchFor, occurrences, replaceChoice, delegate, initializerType, mustBeFinal, classMemberRefs, IntroduceParameterHandler.createNameSuggestionGenerator(this.myExpr, propName, this.myProject, enteredName));
            }
        }

        private void showDialog(PsiMethod method, PsiMethod methodToSearchFor, PsiExpression[] occurrences, IntroduceVariableBase.JavaReplaceChoice replaceChoice, boolean delegate, PsiType initializerType, boolean mustBeFinal, List<? extends UsageInfo> classMemberRefs, NameSuggestionsGenerator nameSuggestionGenerator) {
            IntroduceParameterDialog dialog = new IntroduceParameterDialog(this.myProject, classMemberRefs, occurrences, this.myLocalVar, this.myExpr, nameSuggestionGenerator, (TypeSelectorManager)this.createTypeSelectorManager(occurrences, initializerType), methodToSearchFor, method, this.getParamsToRemove(method, occurrences), mustBeFinal);
            dialog.setReplaceAllOccurrences(replaceChoice);
            dialog.setGenerateDelegate(delegate);
            if (dialog.showAndGet()) {
                Runnable cleanSelectionRunnable = () -> {
                    if (this.myEditor != null && !this.myEditor.isDisposed()) {
                        this.myEditor.getSelectionModel().removeSelection();
                    }
                };
                ApplicationManager.getApplication().invokeLater(cleanSelectionRunnable, ModalityState.any());
            }
        }

        private TypeSelectorManagerImpl createTypeSelectorManager(PsiExpression[] occurrences, PsiType initializerType) {
            return this.myExpr != null ? new TypeSelectorManagerImpl(this.myProject, initializerType, this.myExpr, occurrences) : new TypeSelectorManagerImpl(this.myProject, initializerType, occurrences);
        }

        private IntList getParamsToRemove(PsiMethod method, PsiExpression[] occurrences) {
            PsiExpression expressionToRemoveParamFrom = this.myExpr;
            if (this.myExpr == null) {
                expressionToRemoveParamFrom = this.myLocalVar.getInitializer();
            }
            return expressionToRemoveParamFrom == null ? new IntArrayList() : Util.findParametersToRemove(method, expressionToRemoveParamFrom, occurrences);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replaceChoice", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler$Introducer", "introduceParameter"));
        }
    }

    private static class MyExtractMethodProcessor
    extends ExtractMethodProcessor {
        private final PsiMethod myTopEnclosingMethod;

        MyExtractMethodProcessor(Project project, Editor editor, PsiElement[] elements, @NotNull PsiMethod topEnclosing) {
            if (topEnclosing == null) {
                MyExtractMethodProcessor.$$$reportNull$$$0(0);
            }
            super(project, editor, elements, null, IntroduceParameterHandler.getRefactoringName(), null, null);
            this.myTopEnclosingMethod = topEnclosing;
        }

        @Override
        protected AbstractExtractDialog createExtractMethodDialog(boolean direct) {
            return new MyAbstractExtractDialog();
        }

        @Override
        protected boolean isNeedToChangeCallContext() {
            return false;
        }

        @Override
        public Boolean hasDuplicates() {
            return false;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        protected boolean isFoldingApplicable() {
            return false;
        }

        @Override
        protected PsiMethod addExtractedMethod(PsiMethod newMethod) {
            return newMethod;
        }

        @Override
        public boolean prepare(@Nullable Consumer<? super ExtractMethodProcessor> pass) throws PrepareFailedException {
            boolean prepare = super.prepare(pass);
            if (prepare && (this.myNotNullConditionalCheck || this.myNullConditionalCheck)) {
                return false;
            }
            return prepare;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topEnclosing", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler$MyExtractMethodProcessor", "<init>"));
        }

        private class MyAbstractExtractDialog
        implements AbstractExtractDialog {
            private MyAbstractExtractDialog() {
            }

            @Override
            @NotNull
            public String getChosenMethodName() {
                return "name";
            }

            @Override
            public VariableData[] getChosenParameters() {
                InputVariables inputVariables = MyExtractMethodProcessor.this.getInputVariables();
                ArrayList<VariableData> datas = new ArrayList<VariableData>();
                for (VariableData data : inputVariables.getInputVariables()) {
                    PsiVariable variable = data.variable;
                    if (variable instanceof PsiParameter && MyExtractMethodProcessor.this.myTopEnclosingMethod.equals((Object)((PsiParameter)variable).getDeclarationScope())) continue;
                    datas.add(data);
                }
                return datas.toArray(new VariableData[0]);
            }

            @Override
            @NotNull
            public String getVisibility() {
                return "public";
            }

            @Override
            public boolean isMakeStatic() {
                return false;
            }

            @Override
            public boolean isChainedConstructor() {
                return false;
            }

            @Override
            public PsiType getReturnType() {
                return null;
            }

            @Override
            public void show() {
            }

            @Override
            public boolean isOK() {
                return true;
            }
        }
    }
}

