/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.chainCall.ChainCallExtractor;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.introduceVariable.JavaVariableInplaceIntroducer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class ChainCallInplaceIntroducer
extends JavaVariableInplaceIntroducer {
    private PsiParameter myParameter;
    private PsiElement myBlock;

    public ChainCallInplaceIntroducer(Project project, IntroduceVariableSettings settings, PsiElement chosenAnchor, Editor editor, PsiExpression expr, PsiExpression[] occurrences, TypeSelectorManagerImpl selectorManager, @NlsContexts.Command String title) {
        super(project, settings, chosenAnchor, editor, expr, true, occurrences, selectorManager, title);
    }

    @Override
    @Nullable
    protected PsiVariable getVariable() {
        if (this.myParameter != null && this.myParameter.isValid()) {
            return this.myParameter;
        }
        return super.getVariable();
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        return this.myBlock;
    }

    @Override
    protected PsiVariable createFieldToStartTemplateOn(String[] names, PsiType psiType) {
        PsiVariable variable = this.introduceVariable();
        if (variable instanceof PsiLocalVariable) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)WriteAction.compute(() -> ChainCallExtractor.extractMappingStep((Project)this.myProject, (PsiLocalVariable)((PsiLocalVariable)variable)));
            if (lambda != null) {
                PsiParameter parameter;
                this.myParameter = parameter = Objects.requireNonNull((PsiParameter)ArrayUtil.getFirstElement((Object[])lambda.getParameterList().getParameters()));
                this.myBlock = PsiTreeUtil.getParentOfType((PsiElement)lambda, (Class[])new Class[]{PsiCodeBlock.class, PsiLambdaExpression.class, PsiMember.class});
                this.myExprMarker = null;
                this.myExpr = null;
                this.myOccurrences = (PsiElement[])StreamEx.of((Collection)ReferencesSearch.search((PsiElement)parameter).findAll()).map(PsiReference::getElement).select(PsiExpression.class).toArray(PsiExpression[]::new);
                this.myOccurrenceMarkers = null;
                PsiIdentifier identifier = variable.getNameIdentifier();
                if (identifier != null) {
                    this.myEditor.getCaretModel().moveToOffset(identifier.getTextOffset());
                }
                this.setAdvertisementText(null);
                PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
                this.initOccurrencesMarkers();
                return parameter;
            }
            if (!variable.isValid()) {
                return null;
            }
        }
        return variable;
    }
}

