/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.IntroduceVariableUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.refactoring.introduceVariable.IntroduceVariablePopupComponent;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.introduceVariable.ReassignVariableUtil;
import com.intellij.refactoring.introduceVariable.VariableExtractor;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.inplace.SelectableInlayPresentation;
import com.intellij.refactoring.rename.inplace.TemplateInlayUtil;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVariableInplaceIntroducer
extends AbstractJavaInplaceIntroducer {
    private SmartPsiElementPointer<? extends PsiElement> myPointer;
    private final IntroduceVariableSettings mySettings;
    private final SmartPsiElementPointer<PsiElement> myChosenAnchor;
    private final boolean myCantChangeFinalModifier;
    private final boolean myHasTypeSuggestion;
    private ResolveSnapshotProvider.ResolveSnapshot myConflictResolver;
    private final TypeExpression myExpression;
    private final boolean myReplaceSelf;
    private boolean myDeleteSelf = true;
    private final boolean mySkipTypeExpressionOnStart;
    private final boolean myCanBeVarType;

    public JavaVariableInplaceIntroducer(Project project, IntroduceVariableSettings settings, PsiElement chosenAnchor, Editor editor, PsiExpression expr, boolean cantChangeFinalModifier, PsiExpression[] occurrences, TypeSelectorManagerImpl selectorManager, @NlsContexts.Command String title) {
        super(project, editor, CommonJavaRefactoringUtil.outermostParenthesizedExpression((PsiExpression)expr), null, occurrences, selectorManager, title);
        this.mySettings = settings;
        this.myChosenAnchor = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(chosenAnchor);
        this.myCantChangeFinalModifier = cantChangeFinalModifier;
        this.myHasTypeSuggestion = selectorManager.getTypesForAll().length > 1;
        this.myTitle = title;
        this.myExpression = new TypeExpression(this.myProject, this.isReplaceAllOccurrences() ? this.myTypeSelectorManager.getTypesForAll() : this.myTypeSelectorManager.getTypesForOne());
        List rangeMarkers = this.getOccurrenceMarkers();
        editor.putUserData(ReassignVariableUtil.OCCURRENCES_KEY, (Object)rangeMarkers.toArray(new RangeMarker[0]));
        PsiElement parent = ((PsiExpression)this.myExpr).getParent();
        this.myReplaceSelf = parent instanceof PsiExpressionStatement && !(parent.getParent() instanceof PsiSwitchLabeledRuleStatement);
        this.mySkipTypeExpressionOnStart = !(this.myExpr instanceof PsiFunctionalExpression) || !this.myReplaceSelf;
        this.myCanBeVarType = IntroduceVariableBase.canBeExtractedWithoutExplicitType((PsiExpression)this.myExpr);
    }

    protected void beforeTemplateStart() {
        ResolveSnapshotProvider resolveSnapshotProvider;
        if (!this.mySkipTypeExpressionOnStart) {
            PsiTypeElement typeElement;
            PsiVariable variable = this.getVariable();
            PsiTypeElement psiTypeElement = typeElement = variable != null ? variable.getTypeElement() : null;
            if (typeElement != null) {
                this.myEditor.getCaretModel().moveToOffset(typeElement.getTextOffset());
            }
        }
        this.myConflictResolver = (resolveSnapshotProvider = (ResolveSnapshotProvider)VariableInplaceRenamer.INSTANCE.forLanguage(this.myScope.getLanguage())) != null ? resolveSnapshotProvider.createSnapshot(this.myScope) : null;
        super.beforeTemplateStart();
    }

    @Nullable
    protected PsiVariable getVariable() {
        PsiPrimaryPattern pattern;
        PsiElement declarationStatement;
        PsiElement psiElement = declarationStatement = this.myPointer != null ? this.myPointer.getElement() : null;
        if (declarationStatement instanceof PsiDeclarationStatement) {
            PsiElement[] declaredElements = ((PsiDeclarationStatement)declarationStatement).getDeclaredElements();
            return declaredElements.length == 0 ? null : (PsiVariable)declaredElements[0];
        }
        if (declarationStatement instanceof PsiInstanceOfExpression && (pattern = ((PsiInstanceOfExpression)declarationStatement).getPattern()) instanceof PsiTypeTestPattern) {
            return ((PsiTypeTestPattern)pattern).getPatternVariable();
        }
        return declarationStatement instanceof PsiVariable ? (PsiVariable)declarationStatement : null;
    }

    protected String getActionName() {
        return "IntroduceVariable";
    }

    protected String getRefactoringId() {
        return "refactoring.extractVariable";
    }

    @Override
    protected void restoreState(@NotNull PsiVariable psiField) {
        if (psiField == null) {
            JavaVariableInplaceIntroducer.$$$reportNull$$$0(0);
        }
        if (this.myDeleteSelf) {
            return;
        }
        super.restoreState(psiField);
    }

    protected RangeMarker createMarker(PsiElement element) {
        RangeMarker marker;
        int length = this.myEditor.getDocument().getTextLength();
        if (element.getTextRange().getEndOffset() > length && (marker = (RangeMarker)ElementToWorkOn.TEXT_RANGE.get((UserDataHolder)element)) != null) {
            return marker;
        }
        return super.createMarker(element);
    }

    protected boolean ensureValid() {
        PsiVariable variable = this.getVariable();
        return variable != null && this.isIdentifier(this.getInputName(), variable.getLanguage());
    }

    protected void performCleanup() {
        super.performCleanup();
        PsiVariable variable = this.getVariable();
        if (variable != null) {
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> super.restoreState(variable), null, null);
        }
    }

    protected void deleteTemplateField(PsiVariable variable) {
        if (!this.myDeleteSelf) {
            return;
        }
        if (this.myReplaceSelf) {
            PsiExpression initializer = variable.getInitializer();
            assert (initializer != null);
            variable.replace((PsiElement)initializer);
        } else {
            super.deleteTemplateField((PsiNameIdentifierOwner)variable);
        }
    }

    protected PsiExpression getBeforeExpr() {
        PsiVariable variable = this.getVariable();
        if (variable != null) {
            return variable.getInitializer();
        }
        return (PsiExpression)super.getBeforeExpr();
    }

    protected void performIntroduce() {
        PsiVariable psiVariable = this.getVariable();
        if (psiVariable == null) {
            return;
        }
        TypeSelectorManagerImpl.typeSelected((PsiType)psiVariable.getType(), (PsiType)this.myTypeSelectorManager.getDefaultType());
        Document document = this.myEditor.getDocument();
        LOG.assertTrue(psiVariable.isValid());
        JavaVariableInplaceIntroducer.adjustLine(psiVariable, document);
        int startOffset = this.getExprMarker() != null && this.getExprMarker().isValid() ? this.getExprMarker().getStartOffset() : psiVariable.getTextOffset();
        PsiFile file = psiVariable.getContainingFile();
        PsiReference referenceAt = file.findReferenceAt(startOffset);
        if (referenceAt != null && referenceAt.resolve() instanceof PsiVariable) {
            startOffset = referenceAt.getElement().getTextRange().getEndOffset();
        } else {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)psiVariable, PsiDeclarationStatement.class);
            if (declarationStatement != null) {
                startOffset = declarationStatement.getTextRange().getEndOffset();
            }
        }
        this.myEditor.getCaretModel().moveToOffset(startOffset);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (this.myConflictResolver != null && this.myInsertedName != null && this.isIdentifier(this.myInsertedName, psiVariable.getLanguage())) {
                this.myConflictResolver.apply(psiVariable.getName());
            }
            if (psiVariable.getInitializer() != null) {
                JavaVariableInplaceIntroducer.appendTypeCasts(this.getOccurrenceMarkers(), file, this.myProject, psiVariable);
            }
        });
    }

    public boolean isReplaceAllOccurrences() {
        return this.mySettings.isReplaceAllOccurrences();
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    protected boolean startsOnTheSameElement(RefactoringActionHandler handler, PsiElement element) {
        return handler instanceof IntroduceVariableHandler && super.startsOnTheSameElement(handler, element);
    }

    @Nullable
    protected JComponent getComponent() {
        return null;
    }

    protected void afterTemplateStart() {
        boolean canBeVarType;
        super.afterTemplateStart();
        TemplateState templateState2 = TemplateManagerImpl.getTemplateState((Editor)this.myEditor);
        if (templateState2 == null) {
            return;
        }
        TextRange currentVariableRange = templateState2.getCurrentVariableRange();
        if (currentVariableRange == null) {
            return;
        }
        PsiVariable variable = this.getVariable();
        boolean bl = canBeVarType = this.myCanBeVarType && variable instanceof PsiLocalVariable;
        if (this.myCantChangeFinalModifier && !canBeVarType) {
            return;
        }
        final IntroduceVariablePopupComponent popupComponent = new IntroduceVariablePopupComponent(this.myEditor, this.myProject, this.myCantChangeFinalModifier, canBeVarType, this.getCommandName(), () -> this.getVariable());
        SelectableInlayPresentation presentation = TemplateInlayUtil.createSettingsPresentation((EditorImpl)((EditorImpl)templateState2.getEditor()), popupComponent.logStatisticsOnShowCallback());
        TemplateInlayUtil.SelectableTemplateElement templateElement2 = new TemplateInlayUtil.SelectableTemplateElement(this, presentation){

            public void onSelect(@NotNull TemplateState templateState2) {
                if (templateState2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.onSelect(templateState2);
                popupComponent.logStatisticsOnShow(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateState", "com/intellij/refactoring/introduceVariable/JavaVariableInplaceIntroducer$1", "onSelect"));
            }
        };
        TemplateInlayUtil.createNavigatableButtonWithPopup((TemplateState)templateState2, (int)currentVariableRange.getEndOffset(), (SelectableInlayPresentation)presentation, (DialogPanel)popupComponent.createPopupPanel(), (TemplateInlayUtil.SelectableTemplateElement)templateElement2, popupComponent.logStatisticsOnHideCallback());
    }

    protected void showDialogAdvertisement(@NonNls String actionId) {
        this.initPopupOptionsAdvertisement();
    }

    protected void addAdditionalVariables(TemplateBuilderImpl builder) {
        PsiTypeElement typeElement;
        PsiVariable variable = this.getVariable();
        if (variable != null && (typeElement = variable.getTypeElement()) != null) {
            builder.replaceElement((PsiElement)typeElement, "Variable_Type", IntroduceVariableUtil.createExpression((TypeExpression)this.myExpression, (String)typeElement.getText()), true, this.mySkipTypeExpressionOnStart);
        }
    }

    protected void collectAdditionalElementsToRename(@NotNull List<? super Pair<PsiElement, TextRange>> stringUsages) {
        if (stringUsages == null) {
            JavaVariableInplaceIntroducer.$$$reportNull$$$0(1);
        }
        if (this.isReplaceAllOccurrences()) {
            for (PsiExpression expression : (PsiExpression[])this.getOccurrences()) {
                LOG.assertTrue(expression.isValid(), (Object)expression.getText());
                stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)expression, (Object)new TextRange(0, expression.getTextLength())));
            }
        } else if (this.getExpr() != null && !this.myReplaceSelf && ((PsiExpression)this.getExpr()).getParent() != this.getVariable()) {
            PsiExpression expr = (PsiExpression)this.getExpr();
            LOG.assertTrue(expr.isValid(), (Object)expr.getText());
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)expr, (Object)new TextRange(0, expr.getTextLength())));
        }
    }

    protected void addReferenceAtCaret(Collection<? super PsiReference> refs) {
        PsiExpression expr;
        if (!this.isReplaceAllOccurrences() && ((expr = (PsiExpression)this.getExpr()) == null && !this.myReplaceSelf || expr != null && expr.getParent() == this.getVariable())) {
            return;
        }
        super.addReferenceAtCaret(refs);
    }

    private static void appendTypeCasts(List<RangeMarker> occurrenceMarkers, PsiFile file, Project project, @Nullable PsiVariable psiVariable) {
        if (occurrenceMarkers != null) {
            for (RangeMarker occurrenceMarker : occurrenceMarkers) {
                PsiElement refVariableElement = file.findElementAt(occurrenceMarker.getStartOffset());
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)refVariableElement, PsiReferenceExpression.class);
                if (referenceExpression == null) continue;
                PsiElement parent = referenceExpression.getParent();
                if (parent instanceof PsiVariable) {
                    JavaVariableInplaceIntroducer.createCastInVariableDeclaration(project, (PsiVariable)parent);
                    continue;
                }
                if (!(parent instanceof PsiReferenceExpression) || psiVariable == null) continue;
                PsiExpression initializer = psiVariable.getInitializer();
                LOG.assertTrue(initializer != null);
                PsiType type = initializer.getType();
                if (((PsiReferenceExpression)parent).resolve() != null || type == null || type.equals(psiVariable.getType()) || LambdaUtil.notInferredType((PsiType)type) || PsiTypes.nullType().equals(type)) continue;
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression castedExpr = elementFactory.createExpressionFromText("((" + type.getCanonicalText() + ")" + referenceExpression.getText() + ")", parent);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(referenceExpression.replace((PsiElement)castedExpr));
            }
        }
        if (psiVariable != null && psiVariable.isValid() && !PsiTypes.nullType().equals(psiVariable.getType())) {
            DumbService.getInstance((Project)project).runWithAlternativeResolveEnabled(() -> JavaVariableInplaceIntroducer.createCastInVariableDeclaration(project, psiVariable));
        }
    }

    private static void createCastInVariableDeclaration(Project project, PsiVariable psiVariable) {
        PsiExpression initializer = psiVariable.getInitializer();
        LOG.assertTrue(initializer != null);
        PsiType type = psiVariable.getType();
        PsiType initializerType = initializer.getType();
        if (initializerType != null && !TypeConversionUtil.isAssignable((PsiType)type, (PsiType)initializerType) && !PsiTypesUtil.hasUnresolvedComponents((PsiType)type)) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression castExpr = elementFactory.createExpressionFromText("(" + type.getCanonicalText() + ")" + initializer.getText(), (PsiElement)psiVariable);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(initializer.replace((PsiElement)castExpr));
        }
    }

    @NlsContexts.PopupAdvertisement
    @Nullable
    private static String getAdvertisementText(PsiDeclarationStatement declaration, PsiType type, boolean hasTypeSuggestion) {
        Shortcut shortcut;
        VariablesProcessor processor = ReassignVariableUtil.findVariablesOfType(declaration, type);
        if (processor.size() > 0 && (shortcut = KeymapUtil.getPrimaryShortcut((String)"IntroduceVariable")) != null) {
            return JavaBundle.message((String)"introduce.variable.reassign.adv", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)shortcut)});
        }
        if (hasTypeSuggestion && (shortcut = KeymapUtil.getPrimaryShortcut((String)"PreviousTemplateVariable")) != null) {
            return JavaBundle.message((String)"introduce.variable.change.type.adv", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)shortcut)});
        }
        return null;
    }

    static boolean createFinals(PsiFile file) {
        return IntroduceVariableBase.createFinals(file);
    }

    public static void adjustLine(PsiVariable psiVariable, Document document) {
        int modifierListOffset = psiVariable.getTextRange().getStartOffset();
        int varLineNumber = document.getLineNumber(modifierListOffset);
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDocumentManager.getInstance((Project)psiVariable.getProject()).doPostponedOperationsAndUnblockDocument(document);
            CodeStyleManager.getInstance((Project)psiVariable.getProject()).adjustLineIndent(document, document.getLineStartOffset(varLineNumber));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PsiVariable createFieldToStartTemplateOn(String[] names, PsiType psiType) {
        PsiIdentifier identifier;
        PsiVariable variable = this.introduceVariable();
        PsiVariable restoredVar = this.getVariable();
        if (restoredVar != null) {
            variable = restoredVar;
        }
        if (variable == null) {
            return null;
        }
        if (this.isReplaceAllOccurrences()) {
            ArrayList occurrences = new ArrayList();
            ReferencesSearch.search((PsiElement)variable).asIterable().forEach(reference -> occurrences.add(this.createMarker(reference.getElement())));
            this.setOccurrenceMarkers(occurrences);
            this.myOccurrences = new PsiExpression[occurrences.size()];
        }
        if ((identifier = variable.getNameIdentifier()) != null) {
            this.myEditor.getCaretModel().moveToOffset(identifier.getTextOffset());
        }
        try {
            this.myDeleteSelf = false;
            this.restoreState(variable);
        }
        finally {
            this.myDeleteSelf = true;
        }
        this.initOccurrencesMarkers();
        return variable;
    }

    @Nullable
    protected PsiVariable introduceVariable() {
        PsiElement anchor = this.myChosenAnchor.getElement();
        if (anchor == null) {
            return null;
        }
        PsiVariable variable = VariableExtractor.introduce(this.myProject, (PsiExpression)this.myExpr, this.myEditor, anchor, (PsiExpression[])this.getOccurrences(), this.mySettings);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        if (variable instanceof PsiField || variable instanceof PsiResourceVariable) {
            this.myPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)variable);
        } else if (variable instanceof PsiPatternVariable) {
            PsiElement parent = ((PsiPatternVariable)variable).getPattern().getParent();
            LOG.assertTrue(parent instanceof PsiInstanceOfExpression);
            this.myPointer = smartPointerManager.createSmartPsiElementPointer(parent);
        } else {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiDeclarationStatement.class);
            if (declarationStatement != null) {
                SmartPsiElementPointer pointer;
                this.myPointer = pointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)declarationStatement);
                this.myEditor.putUserData(ReassignVariableUtil.DECLARATION_KEY, (Object)pointer);
                PsiType variableType = variable.getType();
                ReadAction.nonBlocking(() -> {
                    PsiDeclarationStatement element = (PsiDeclarationStatement)pointer.getElement();
                    return element != null && variableType.isValid() ? JavaVariableInplaceIntroducer.getAdvertisementText(element, variableType, this.myHasTypeSuggestion) : null;
                }).finishOnUiThread(ModalityState.nonModal(), text -> this.setAdvertisementText((String)text)).submit((Executor)NonUrgentExecutor.getInstance());
            }
        }
        SmartPsiElementPointer pointer = variable == null ? null : smartPointerManager.createSmartPsiElementPointer((PsiElement)variable);
        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
        return pointer == null ? null : (PsiVariable)pointer.getElement();
    }

    protected int getCaretOffset() {
        PsiIdentifier identifier;
        PsiVariable variable = this.getVariable();
        if (variable != null && (identifier = variable.getNameIdentifier()) != null) {
            return identifier.getTextOffset();
        }
        return super.getCaretOffset();
    }

    public void finish(boolean success) {
        super.finish(success);
        this.myEditor.putUserData(ReassignVariableUtil.DECLARATION_KEY, null);
    }

    @Override
    protected SuggestedNameInfo suggestNames(PsiType defaultType, String propName) {
        return CommonJavaRefactoringUtil.getSuggestedName((PsiType)defaultType, (PsiExpression)((PsiExpression)this.myExpr));
    }

    @Override
    protected VariableKind getVariableKind() {
        return VariableKind.LOCAL_VARIABLE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/introduceVariable/JavaVariableInplaceIntroducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "collectAdditionalElementsToRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

