/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceparameterobject.ParameterSpec;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ParameterObjectBuilder {
    private String className;
    private String packageName;
    private final List<ParameterSpec> fields = new ArrayList<ParameterSpec>(5);
    private final List<PsiTypeParameter> typeParams = new ArrayList<PsiTypeParameter>();
    private Project myProject;
    private PsiFile myFile;
    private JavaCodeStyleManager myJavaCodeStyleManager;
    private String myVisibility;

    ParameterObjectBuilder() {
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void addField(PsiParameter variable, String name, PsiType type, boolean setterRequired) {
        String propertyName = this.myJavaCodeStyleManager.variableNameToPropertyName(name, VariableKind.PARAMETER);
        ParameterSpec field = new ParameterSpec(variable, this.myJavaCodeStyleManager.propertyNameToVariableName(propertyName, VariableKind.FIELD), type instanceof PsiEllipsisType ? ((PsiEllipsisType)type).toArrayType() : type, setterRequired);
        this.fields.add(field);
    }

    public void setTypeArguments(Collection<PsiTypeParameter> typeParams) {
        this.typeParams.clear();
        this.typeParams.addAll(typeParams);
    }

    public void setProject(Project project) {
        this.myProject = project;
        this.myJavaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
    }

    public void setFile(@NotNull PsiFile file) {
        if (file == null) {
            ParameterObjectBuilder.$$$reportNull$$$0(0);
        }
        this.myFile = file;
    }

    public String buildBeanClass() {
        boolean recordsAvailable = PsiUtil.isAvailable((JavaFeature)JavaFeature.RECORDS, (PsiElement)this.myFile) && !ContainerUtil.exists(this.fields, ParameterSpec::isSetterRequired);
        @NonNls StringBuilder out = new StringBuilder(1024);
        if (!this.packageName.isEmpty()) {
            out.append("package ").append(this.packageName).append(';');
        }
        out.append('\n');
        out.append(this.myVisibility).append(" ");
        out.append(recordsAvailable ? "record" : "class");
        out.append(" ").append(this.className);
        if (!this.typeParams.isEmpty()) {
            out.append('<');
            boolean first = true;
            for (PsiTypeParameter typeParam : this.typeParams) {
                if (!first) {
                    out.append(',');
                }
                out.append(typeParam.getText());
                first = false;
            }
            out.append('>');
        }
        if (recordsAvailable) {
            out.append("(");
            StringUtil.join(this.fields, param -> {
                PsiType type = param.getType();
                if (param.getParameter().isVarArgs() && type instanceof PsiArrayType) {
                    type = new PsiEllipsisType(((PsiArrayType)type).getComponentType(), type.getAnnotations());
                }
                return type.getCanonicalText(true) + " " + param.getName();
            }, (String)", ", (StringBuilder)out);
            out.append("){}");
        } else {
            out.append('\n');
            out.append('{');
            this.outputFields(out);
            this.outputConstructor(out);
            this.outputGetters(out);
            this.outputSetters(out);
            out.append("}\n");
        }
        return out.toString();
    }

    private void outputSetters(@NonNls StringBuilder out) {
        for (ParameterSpec field : this.fields) {
            this.outputSetter(field, out);
        }
    }

    private void outputGetters(@NonNls StringBuilder out) {
        for (ParameterSpec field : this.fields) {
            this.outputGetter(field, out);
        }
    }

    private void outputFields(StringBuilder out) {
        for (ParameterSpec field : this.fields) {
            ParameterObjectBuilder.outputField(field, out);
        }
    }

    private void outputSetter(ParameterSpec field, @NonNls StringBuilder out) {
        if (!field.isSetterRequired()) {
            return;
        }
        out.append(GenerateMembersUtil.generateSetterPrototype((PsiField)JavaPsiFacade.getElementFactory((Project)this.myProject).createField(field.getName(), field.getType())).getText());
    }

    private static void generateFieldAssignment(@NonNls StringBuilder out, String parameterName, String fieldName) {
        if (fieldName.equals(parameterName)) {
            out.append("\t\tthis.").append(fieldName).append(" = ").append(parameterName).append(";\n");
        } else {
            out.append("\t\t").append(fieldName).append(" = ").append(parameterName).append(";\n");
        }
    }

    private void outputGetter(ParameterSpec field, @NonNls StringBuilder out) {
        out.append(GenerateMembersUtil.generateGetterPrototype((PsiField)JavaPsiFacade.getElementFactory((Project)this.myProject).createField(field.getName(), field.getType())).getText());
    }

    @NotNull
    private CodeStyleSettings getSettings() {
        CodeStyleSettings codeStyleSettings = this.myFile != null ? CodeStyle.getSettings((PsiFile)this.myFile) : CodeStyle.getProjectOrDefaultSettings((Project)this.myProject);
        if (codeStyleSettings == null) {
            ParameterObjectBuilder.$$$reportNull$$$0(1);
        }
        return codeStyleSettings;
    }

    private void outputConstructor(@NonNls StringBuilder out) {
        out.append("\t").append(this.myVisibility).append(" ").append(this.className).append('(');
        Iterator<ParameterSpec> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            ParameterSpec field = iterator.next();
            PsiParameter parameter = field.getParameter();
            ParameterObjectBuilder.outputAnnotationString(parameter, out);
            out.append(((JavaCodeStyleSettings)this.getSettings().getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_PARAMETERS ? " final " : "");
            String parameterName = parameter.getName();
            PsiType type = field.getType();
            PsiType fieldType = parameter.isVarArgs() && type instanceof PsiArrayType ? new PsiEllipsisType(((PsiArrayType)type).getComponentType()) : type;
            out.append(' ').append(fieldType.getCanonicalText()).append(' ').append(parameterName);
            if (!iterator.hasNext()) continue;
            out.append(", ");
        }
        out.append(")\n");
        out.append("\t{\n");
        for (ParameterSpec field : this.fields) {
            ParameterObjectBuilder.generateFieldAssignment(out, field.getParameter().getName(), field.getName());
        }
        out.append("\t}\n");
    }

    private static void outputField(ParameterSpec field, StringBuilder out) {
        PsiParameter parameter = field.getParameter();
        PsiDocComment docComment = ParameterObjectBuilder.getJavadocForVariable((PsiVariable)parameter);
        if (docComment != null) {
            out.append(docComment.getText());
            out.append('\n');
        }
        PsiType type = field.getType();
        String typeText = type.getCanonicalText();
        String name = field.getName();
        @NonNls Object modifierString = "private ";
        if (!field.isSetterRequired()) {
            modifierString = (String)modifierString + "final ";
        }
        ParameterObjectBuilder.outputAnnotationString(parameter, out);
        out.append('\t').append((String)modifierString).append(typeText).append(' ').append(name).append(";\n");
    }

    private static void outputAnnotationString(PsiParameter parameter, StringBuilder out) {
        PsiAnnotation[] annotations;
        PsiModifierList modifierList = parameter.getModifierList();
        for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
            PsiClass annotationClass;
            PsiJavaCodeReferenceElement reference = annotation.getNameReferenceElement();
            if (reference == null || (annotationClass = (PsiClass)reference.resolve()) == null) continue;
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            String annotationText = "@" + annotationClass.getQualifiedName() + parameterList.getText();
            out.append(annotationText);
        }
    }

    private static PsiDocComment getJavadocForVariable(PsiVariable variable) {
        PsiElement[] children;
        for (PsiElement child : children = variable.getChildren()) {
            if (!(child instanceof PsiDocComment)) continue;
            return (PsiDocComment)child;
        }
        return null;
    }

    public void setVisibility(String visibility) {
        this.myVisibility = visibility;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceparameterobject/ParameterObjectBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceparameterobject/ParameterObjectBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setFile";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

