/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPullUp;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractMemberInfoStorage;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.memberPullUp.JavaPullUpHandler;
import com.intellij.refactoring.memberPullUp.PullUpDialogBase;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.refactoring.ui.ClassCellRenderer;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.refactoring.ui.MemberSelectionTable;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.classMembers.InterfaceContainmentVerifier;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import com.intellij.refactoring.util.classMembers.UsesAndInterfacesDependencyMemberInfoModel;
import com.intellij.util.ui.UIUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PullUpDialog
extends PullUpDialogBase<MemberInfoStorage, MemberInfo, PsiMember, PsiClass> {
    private final Callback myCallback;
    private DocCommentPanel myJavaDocPanel;
    private final InterfaceContainmentVerifier myInterfaceContainmentVerifier = new InterfaceContainmentVerifier(){

        @Override
        public boolean checkedInterfacesContain(PsiMethod psiMethod) {
            return PullUpProcessor.checkedInterfacesContain(PullUpDialog.this.getMemberInfos(), psiMethod);
        }
    };
    @NonNls
    private static final String PULL_UP_STATISTICS_KEY = "pull.up##";

    static boolean isEnumSyntheticMethod(@NotNull PsiMethod method) {
        if (method == null) {
            PullUpDialog.$$$reportNull$$$0(0);
        }
        return CallMatcher.enumValues().methodMatches(method) || CallMatcher.enumValueOf().methodMatches(method);
    }

    public PullUpDialog(Project project, PsiClass aClass, List<PsiClass> superClasses, MemberInfoStorage memberInfoStorage, Callback callback) {
        super(project, (PsiElement)aClass, superClasses, (AbstractMemberInfoStorage)memberInfoStorage, JavaPullUpHandler.getRefactoringName());
        this.myCallback = callback;
        this.init();
    }

    private List<MemberInfo> getMemberInfos() {
        return this.myMemberInfos;
    }

    public int getJavaDocPolicy() {
        return this.myJavaDocPanel.getPolicy();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.memberPullUp.PullUpDialog";
    }

    InterfaceContainmentVerifier getContainmentVerifier() {
        return this.myInterfaceContainmentVerifier;
    }

    protected void initClassCombo(JComboBox classCombo) {
        classCombo.setRenderer(new ClassCellRenderer(classCombo.getRenderer()));
        classCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PullUpDialog.this.updateMemberPanels();
                }
            }
        });
    }

    private void updateMemberPanels() {
        if (this.myMemberSelectionPanel != null) {
            ((MyMemberInfoModel)this.myMemberInfoModel).setSuperClass((PsiClass)this.getSuperClass());
            this.myMemberSelectionPanel.getTable().setMemberInfos((Collection)this.myMemberInfos);
            this.myMemberSelectionPanel.getTable().fireExternalDataChange();
        }
    }

    protected PsiClass getPreselection() {
        PsiClass preselection = RefactoringHierarchyUtil.getNearestBaseClass((PsiClass)this.myClass, false);
        String statKey = PULL_UP_STATISTICS_KEY + ((PsiClass)this.myClass).getQualifiedName();
        for (StatisticsInfo info : StatisticsManager.getInstance().getAllValues(statKey)) {
            String superClassName = info.getValue();
            PsiClass superClass = null;
            for (PsiClass aClass : this.mySuperClasses) {
                if (!Comparing.strEqual((String)superClassName, (String)aClass.getQualifiedName())) continue;
                superClass = aClass;
                break;
            }
            if (superClass == null || StatisticsManager.getInstance().getUseCount(info) <= 0) continue;
            preselection = superClass;
            break;
        }
        return preselection;
    }

    protected String getHelpId() {
        return "refactoring.pullMembersUp";
    }

    protected void doAction() {
        if (!this.myCallback.checkConflicts(this)) {
            return;
        }
        JavaRefactoringSettings.getInstance().PULL_UP_MEMBERS_JAVADOC = this.myJavaDocPanel.getPolicy();
        PsiClass superClass = (PsiClass)this.getSuperClass();
        String name = superClass.getQualifiedName();
        if (name != null) {
            StatisticsManager.getInstance().incUseCount(new StatisticsInfo(PULL_UP_STATISTICS_KEY + ((PsiClass)this.myClass).getQualifiedName(), name));
        }
        List infos = this.getSelectedMemberInfos();
        this.invokeRefactoring(new PullUpProcessor((PsiClass)this.myClass, superClass, infos.toArray(new MemberInfo[0]), new DocCommentPolicy(this.getJavaDocPolicy())));
        this.close(0);
    }

    protected void addCustomElementsToCentralPanel(JPanel panel) {
        this.myJavaDocPanel = new DocCommentPanel(JavaRefactoringBundle.message((String)"javadoc.for.abstracts", (Object[])new Object[0]));
        this.myJavaDocPanel.setPolicy(JavaRefactoringSettings.getInstance().PULL_UP_MEMBERS_JAVADOC);
        panel.add((Component)this.myJavaDocPanel, "East");
        this.updateAbstractState();
    }

    private void updateAbstractState() {
        boolean hasJavadoc = false;
        for (MemberInfo info : this.myMemberInfos) {
            PsiMember member = (PsiMember)info.getMember();
            boolean abstractWhenDisabled = this.myMemberInfoModel.isAbstractWhenDisabled((MemberInfoBase)info);
            info.setToAbstract(abstractWhenDisabled);
            if (!this.myMemberInfoModel.isAbstractEnabled((MemberInfoBase)info) && !abstractWhenDisabled || hasJavadoc || !(member instanceof PsiDocCommentOwner) || ((PsiDocCommentOwner)member).getDocComment() == null) continue;
            hasJavadoc = true;
        }
        UIUtil.setEnabled((Component)this.myJavaDocPanel, (boolean)hasJavadoc, (boolean)true);
    }

    protected void updateMemberInfo() {
        super.updateMemberInfo();
        this.updateAbstractState();
    }

    protected AbstractMemberSelectionTable<PsiMember, MemberInfo> createMemberSelectionTable(List<MemberInfo> infos) {
        return new MemberSelectionTable(infos, RefactoringBundle.message((String)"make.abstract"));
    }

    protected MemberInfoModel<PsiMember, MemberInfo> createMemberInfoModel() {
        return new MyMemberInfoModel();
    }

    private PsiClass getPsiClass() {
        return (PsiClass)this.myClass;
    }

    private MemberInfoStorage getMemberInfoStorage() {
        return (MemberInfoStorage)this.myMemberInfoStorage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/memberPullUp/PullUpDialog", "isEnumSyntheticMethod"));
    }

    public static interface Callback {
        public boolean checkConflicts(PullUpDialog var1);
    }

    private class MyMemberInfoModel
    extends UsesAndInterfacesDependencyMemberInfoModel<PsiMember, MemberInfo> {
        MyMemberInfoModel() {
            super(PullUpDialog.this.getPsiClass(), (PsiClass)PullUpDialog.this.getSuperClass(), false, PullUpDialog.this.myInterfaceContainmentVerifier);
        }

        public boolean isMemberEnabled(MemberInfo member) {
            PsiClass currentSuperClass = (PsiClass)PullUpDialog.this.getSuperClass();
            if (currentSuperClass == null) {
                return true;
            }
            if (PullUpDialog.this.getMemberInfoStorage().getDuplicatedMemberInfos((PsiElement)currentSuperClass).contains(member)) {
                return false;
            }
            if (PullUpDialog.this.getMemberInfoStorage().getExtending((PsiElement)currentSuperClass).contains(member.getMember())) {
                return false;
            }
            boolean isInterface = currentSuperClass.isInterface();
            if (!isInterface) {
                return true;
            }
            PsiModifierListOwner element = (PsiModifierListOwner)member.getMember();
            if (element instanceof PsiClass && ((PsiClass)element).isInterface()) {
                return true;
            }
            if (element instanceof PsiEnumConstant) {
                return false;
            }
            if (element instanceof PsiField) {
                return element.hasModifierProperty("static");
            }
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiClass aClass = method.getContainingClass();
                if (aClass != null && aClass.isEnum() && PullUpDialog.isEnumSyntheticMethod(method)) {
                    return false;
                }
                PsiMethod superClassMethod = this.findSuperMethod(currentSuperClass, method);
                if (superClassMethod != null && !PsiUtil.isAvailable((JavaFeature)JavaFeature.EXTENSION_METHODS, (PsiElement)currentSuperClass)) {
                    return false;
                }
                return !element.hasModifierProperty("static") || PsiUtil.isAvailable((JavaFeature)JavaFeature.STATIC_INTERFACE_CALLS, (PsiElement)currentSuperClass);
            }
            return !(element instanceof PsiClassInitializer);
        }

        private PsiMethod findSuperMethod(PsiClass currentSuperClass, PsiMethod element) {
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)currentSuperClass, (PsiClass)PullUpDialog.this.getPsiClass(), (PsiSubstitutor)PsiSubstitutor.EMPTY);
            MethodSignature signature = element.getSignature(superSubstitutor);
            return MethodSignatureUtil.findMethodBySignature((PsiClass)currentSuperClass, (MethodSignature)signature, (boolean)false);
        }

        public boolean isAbstractEnabled(MemberInfo member) {
            PsiMethod method;
            PsiElement psiElement = member.getMember();
            if (psiElement instanceof PsiMethod && JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)(method = (PsiMethod)psiElement)) != null) {
                return false;
            }
            PsiClass currentSuperClass = (PsiClass)PullUpDialog.this.getSuperClass();
            if (currentSuperClass == null || !currentSuperClass.isInterface()) {
                return true;
            }
            return PsiUtil.isAvailable((JavaFeature)JavaFeature.EXTENSION_METHODS, (PsiElement)currentSuperClass);
        }

        public boolean isAbstractWhenDisabled(MemberInfo member) {
            PsiClass currentSuperClass = (PsiClass)PullUpDialog.this.getSuperClass();
            if (currentSuperClass == null) {
                return false;
            }
            if (currentSuperClass.isInterface()) {
                if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.EXTENSION_METHODS, (PsiElement)currentSuperClass)) {
                    return true;
                }
                PsiElement psiElement = member.getMember();
                if (psiElement instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)psiElement;
                    if (JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)method) != null) {
                        return true;
                    }
                    return !method.hasModifierProperty("static") && this.findSuperMethod(currentSuperClass, method) == null;
                }
            }
            return false;
        }

        public int checkForProblems(@NotNull MemberInfo member) {
            if (member == null) {
                MyMemberInfoModel.$$$reportNull$$$0(0);
            }
            if (member.isChecked()) {
                return 0;
            }
            PsiClass currentSuperClass = (PsiClass)PullUpDialog.this.getSuperClass();
            if (currentSuperClass != null && currentSuperClass.isInterface()) {
                PsiMember element = (PsiMember)member.getMember();
                if (element.hasModifierProperty("static")) {
                    return super.checkForProblems((MemberInfoBase)member);
                }
                return 0;
            }
            return super.checkForProblems((MemberInfoBase)member);
        }

        public Boolean isFixedAbstract(MemberInfo member) {
            return Boolean.TRUE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/refactoring/memberPullUp/PullUpDialog$MyMemberInfoModel", "checkForProblems"));
        }
    }
}

