/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.java.JavaBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PushDownConflicts {
    private final PsiClass myClass;
    private final Set<PsiMember> myMovedMembers;
    private final Set<PsiMethod> myAbstractMembers;
    private final MultiMap<PsiElement, @NlsContexts.DialogMessage String> myConflicts;

    public PushDownConflicts(PsiClass aClass, MemberInfo[] memberInfos, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        this.myClass = aClass;
        this.myMovedMembers = new HashSet<PsiMember>();
        this.myAbstractMembers = new HashSet<PsiMethod>();
        for (MemberInfo memberInfo : memberInfos) {
            PsiMember member = (PsiMember)memberInfo.getMember();
            if (!memberInfo.isChecked() || memberInfo.getMember() instanceof PsiClass && memberInfo.getOverrides() != null) continue;
            this.myMovedMembers.add(member);
            if (!memberInfo.isToAbstract()) continue;
            this.myAbstractMembers.add((PsiMethod)member);
        }
        this.myConflicts = conflicts;
    }

    public MultiMap<PsiElement, @NlsContexts.DialogMessage String> getConflicts() {
        return this.myConflicts;
    }

    public Set<PsiMember> getMovedMembers() {
        return this.myMovedMembers;
    }

    public Set<PsiMethod> getAbstractMembers() {
        return this.myAbstractMembers;
    }

    public void checkSourceClassConflicts() {
        PsiElement[] children;
        for (PsiElement child : children = this.myClass.getChildren()) {
            if (!(child instanceof PsiMember) || this.myMovedMembers.contains(child)) continue;
            child.accept((PsiElementVisitor)new UsedMovedMembersConflictsCollector(child));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)this.myClass, (String[])new String[]{"java.lang.FunctionalInterface"});
        if (annotation != null && this.myMovedMembers.contains(LambdaUtil.getFunctionalInterfaceMethod((PsiClass)this.myClass))) {
            this.myConflicts.putValue((Object)annotation, (Object)JavaRefactoringBundle.message((String)"functional.interface.broken", (Object[])new Object[0]));
        }
        boolean isAbstract = this.myClass.hasModifierProperty("abstract");
        block1: for (PsiMember member : this.myMovedMembers) {
            if (!member.hasModifierProperty("static")) {
                member.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                        PsiMethod methodBySignature;
                        PsiClass resolvedClass;
                        PsiMethod resolvedMethod;
                        if (expression == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.visitMethodCallExpression(expression);
                        if (expression.getMethodExpression().getQualifierExpression() instanceof PsiSuperExpression && (resolvedMethod = expression.resolveMethod()) != null && (resolvedClass = resolvedMethod.getContainingClass()) != null && PushDownConflicts.this.myClass.isInheritor(resolvedClass, true) && (methodBySignature = PushDownConflicts.this.myClass.findMethodBySignature(resolvedMethod, false)) != null && !PushDownConflicts.this.myMovedMembers.contains(methodBySignature)) {
                            PushDownConflicts.this.myConflicts.putValue((Object)expression, (Object)JavaBundle.message((String)"push.down.super.method.call.changed.conflict", (Object[])new Object[0]));
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/memberPushDown/PushDownConflicts$1", "visitMethodCallExpression"));
                    }
                });
            }
            if (member.hasModifierProperty("static") || !(member instanceof PsiMethod) || this.myAbstractMembers.contains(member)) continue;
            LinkedHashSet<PsiClass> unrelatedDefaults = new LinkedHashSet<PsiClass>();
            for (PsiMethod superMethod : ((PsiMethod)member).findSuperMethods()) {
                if (!isAbstract && superMethod.hasModifierProperty("abstract")) {
                    this.myConflicts.putValue((Object)member, (Object)JavaBundle.message((String)"push.down.missed.implementation.conflict", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)superMethod, (boolean)false)}));
                    continue block1;
                }
                if (!superMethod.hasModifierProperty("default")) continue;
                unrelatedDefaults.add(superMethod.getContainingClass());
                if (unrelatedDefaults.size() <= 1) continue;
                ArrayList<PsiClass> supers = new ArrayList<PsiClass>(unrelatedDefaults);
                supers.sort(Comparator.comparing(PsiQualifiedNamedElement::getName));
                PsiClass lastClass = (PsiClass)supers.removeLast();
                this.myConflicts.putValue((Object)member, (Object)StringUtil.capitalize((String)JavaRefactoringBundle.message((String)"push.down.unrelated.defaults.conflict", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myClass, (boolean)false), StringUtil.join(supers, aClass -> RefactoringUIUtil.getDescription((PsiElement)aClass, (boolean)false), (String)", "), RefactoringUIUtil.getDescription((PsiElement)lastClass, (boolean)false)})));
                continue block1;
            }
        }
    }

    public void checkTargetClassConflicts(PsiElement targetElement, PsiElement context) {
        PsiClass targetClass;
        if (targetElement instanceof PsiFunctionalExpression) {
            this.myConflicts.putValue((Object)targetElement, (Object)JavaRefactoringBundle.message((String)"functional.interface.broken", (Object[])new Object[0]));
            return;
        }
        PsiClass psiClass = targetClass = targetElement instanceof PsiClass ? (PsiClass)targetElement : null;
        if (targetClass != null) {
            for (PsiMember movedMember : this.myMovedMembers) {
                this.checkMemberPlacementInTargetClassConflict(targetClass, movedMember);
            }
        }
        block1: for (PsiMember member : this.myMovedMembers) {
            if (member.hasModifierProperty("static")) continue;
            for (PsiReference ref2 : ReferencesSearch.search((PsiElement)member, (SearchScope)member.getResolveScope(), (boolean)false).asIterable()) {
                PsiElement resolved;
                PsiExpression qualifier;
                PsiElement element = ref2.getElement();
                if (!(element instanceof PsiReferenceExpression)) continue;
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                if (this.myConflicts.containsKey((Object)element) || (qualifier = referenceExpression.getQualifierExpression()) instanceof PsiSuperExpression && PushDownConflicts.isSuperCallToBeInlined(member, targetClass, this.myClass) || qualifier == null) continue;
                PsiType qualifierType = qualifier.getType();
                PsiClass aClass = null;
                if (qualifierType instanceof PsiClassType) {
                    aClass = ((PsiClassType)qualifierType).resolve();
                } else if (qualifier instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
                    aClass = (PsiClass)resolved;
                }
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)targetClass, (boolean)true)) continue;
                this.myConflicts.putValue((Object)referenceExpression, (Object)RefactoringBundle.message((String)"pushed.members.will.not.be.visible.from.certain.call.sites"));
                break block1;
            }
        }
        RefactoringConflictsUtil.getInstance().analyzeAccessibilityConflictsAfterMemberMove(this.myMovedMembers, targetClass, null, context, this.myAbstractMembers, ref -> !InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)this.myClass, (PsiElement)ref.getElement(), (boolean)true, (boolean)false), this.myConflicts);
    }

    public void checkMemberPlacementInTargetClassConflict(PsiClass targetClass, PsiMember movedMember) {
        if (movedMember instanceof PsiField) {
            String name = ((PsiField)movedMember).getName();
            PsiField field = targetClass.findFieldByName(name, false);
            if (field != null) {
                String message = JavaRefactoringBundle.message((String)"0.already.contains.field.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)false), CommonRefactoringUtil.htmlEmphasize((String)name)});
                this.myConflicts.putValue((Object)field, (Object)StringUtil.capitalize((String)message));
            }
        } else if (movedMember instanceof PsiMethod) {
            PsiMethod method;
            PsiMethod overrider;
            PsiModifierList modifierList = movedMember.getModifierList();
            assert (modifierList != null);
            if (!modifierList.hasModifierProperty("abstract") && (overrider = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)targetClass, (PsiMethod)(method = (PsiMethod)movedMember), (boolean)false)) != null && ReferencesSearch.search((PsiElement)method, (SearchScope)new LocalSearchScope((PsiElement)overrider)).findAll().size() != 1) {
                String message = RefactoringBundle.message((String)"0.is.already.overridden.in.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)method, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)false)});
                this.myConflicts.putValue((Object)overrider, (Object)StringUtil.capitalize((String)message));
            }
        } else if (movedMember instanceof PsiClass) {
            PsiClass[] allInnerClasses;
            PsiClass aClass = (PsiClass)movedMember;
            String name = aClass.getName();
            for (PsiClass innerClass : allInnerClasses = targetClass.getAllInnerClasses()) {
                if (innerClass.equals((Object)movedMember) || !Objects.requireNonNull(name).equals(innerClass.getName())) continue;
                String message = JavaRefactoringBundle.message((String)"0.already.contains.inner.class.named.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)false), CommonRefactoringUtil.htmlEmphasize((String)name)});
                this.myConflicts.putValue((Object)innerClass, (Object)message);
            }
        }
        if (movedMember.hasModifierProperty("static") && !targetClass.hasModifierProperty("static") && !(targetClass.getParent() instanceof PsiFile) && !PsiUtil.isAvailable((JavaFeature)JavaFeature.INNER_STATICS, (PsiElement)targetClass)) {
            this.myConflicts.putValue((Object)movedMember, (Object)JavaBundle.message((String)"push.down.static.nonstatic.conflict", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)movedMember, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)false)}));
        }
    }

    public static boolean isSuperCallToBeInlined(PsiMember member, PsiClass targetClass, PsiClass sourceClass) {
        if (member instanceof PsiMethod) {
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)sourceClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod methodInTarget = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)targetClass, (MethodSignature)((PsiMethod)member).getSignature(substitutor), (boolean)true);
            return methodInTarget != null && targetClass.equals((Object)methodInTarget.getContainingClass());
        }
        return false;
    }

    private class UsedMovedMembersConflictsCollector
    extends ClassMemberReferencesVisitor {
        private final PsiElement mySource;

        UsedMovedMembersConflictsCollector(PsiElement source) {
            super(PushDownConflicts.this.myClass);
            this.mySource = source;
        }

        protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
            if (PushDownConflicts.this.myMovedMembers.contains(classMember) && !PushDownConflicts.this.myAbstractMembers.contains(classMember)) {
                String message = RefactoringBundle.message((String)"0.uses.1.which.is.pushed.down", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.mySource, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)false)});
                message = StringUtil.capitalize((String)message);
                PushDownConflicts.this.myConflicts.putValue((Object)this.mySource, (Object)message);
            }
        }
    }
}

