/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.refactoring.migration.MigrationMapEntry;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MigrationMap {
    @Nls
    private String myName;
    @Nls
    private String myDescription;
    private final ArrayList<MigrationMapEntry> myEntries = new ArrayList();
    private String myFileName;
    private int order = 0;

    public MigrationMap() {
    }

    public MigrationMap(MigrationMapEntry[] entries) {
        for (MigrationMapEntry entry : entries) {
            this.addEntry(entry);
        }
    }

    public MigrationMap cloneMap() {
        MigrationMap newMap = new MigrationMap();
        newMap.myName = this.myName;
        newMap.myDescription = this.myDescription;
        newMap.myFileName = this.myFileName;
        for (int i = 0; i < this.myEntries.size(); ++i) {
            MigrationMapEntry entry = this.getEntryAt(i);
            newMap.addEntry(entry.cloneEntry());
        }
        return newMap;
    }

    @Nls
    public String getName() {
        return this.myName;
    }

    public void setName(@Nls String name) {
        this.myName = name;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Nls
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nls String description) {
        this.myDescription = description;
    }

    public void addEntry(MigrationMapEntry entry) {
        this.myEntries.add(entry);
    }

    public void removeEntryAt(int index) {
        this.myEntries.remove(index);
    }

    public void removeAllEntries() {
        this.myEntries.clear();
    }

    public int getEntryCount() {
        return this.myEntries.size();
    }

    public MigrationMapEntry getEntryAt(int index) {
        return this.myEntries.get(index);
    }

    public void setEntryAt(MigrationMapEntry entry, int index) {
        this.myEntries.set(index, entry);
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    public String getFileName() {
        if (this.myFileName == null) {
            String string = FileUtil.sanitizeFileName((String)this.myName, (boolean)false);
            if (string == null) {
                MigrationMap.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = this.myFileName;
        if (string == null) {
            MigrationMap.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setFileName(String fileName) {
        this.myFileName = fileName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/migration/MigrationMap", "getFileName"));
    }
}

