/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.moveClassesOrPackages.CommonMoveUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryUsageInfo;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesHelper;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class JavaMoveDirectoryWithClassesHelper
extends MoveDirectoryWithClassesHelper {
    public void findUsages(Collection<? extends PsiFile> filesToMove, PsiDirectory[] directoriesToMove, Collection<? super UsageInfo> result, boolean searchInComments, boolean searchInNonJavaFiles, Project project) {
    }

    public void findUsages(Map<VirtualFile, MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper> filesToMove, PsiDirectory[] directoriesToMove, Collection<? super UsageInfo> usages, boolean searchInComments, boolean searchInNonJavaFiles, Project project) {
        HashSet<String> packageNames = new HashSet<String>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile vFile : filesToMove.keySet()) {
            PsiClass[] classes;
            PsiFile psiFile = psiManager.findFile(vFile);
            if (!(psiFile instanceof PsiJavaFile)) continue;
            String packageName = "";
            MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper targetWrapper = filesToMove.get(vFile);
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(targetWrapper.getRootDirectory());
            if (aPackage != null) {
                String relatedPackageName = targetWrapper.getRelativePathFromRoot().replaceAll("/", ".");
                packageName = !relatedPackageName.isEmpty() ? StringUtil.getQualifiedName((String)aPackage.getQualifiedName(), (String)relatedPackageName) : aPackage.getQualifiedName();
            }
            for (PsiClass aClass : classes = ((PsiClassOwner)psiFile).getClasses()) {
                String newQName = StringUtil.getQualifiedName((String)packageName, (String)Objects.requireNonNull(aClass.getName()));
                Collections.addAll(usages, MoveClassesOrPackagesUtil.findUsages((PsiElement)aClass, searchInComments, searchInNonJavaFiles, newQName));
            }
            packageNames.add(((PsiClassOwner)psiFile).getPackageName());
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        for (String packageName : packageNames) {
            PsiPackage aPackage = psiFacade.findPackage(packageName);
            if (aPackage == null) continue;
            boolean remainsNothing = true;
            for (PsiDirectory packageDirectory : aPackage.getDirectories()) {
                if (JavaMoveDirectoryWithClassesHelper.isUnderRefactoring((PsiElement)packageDirectory, directoriesToMove)) continue;
                remainsNothing = false;
                break;
            }
            if (!remainsNothing) continue;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)aPackage, (SearchScope)GlobalSearchScope.projectScope((Project)project)).asIterable()) {
                PsiElement element = reference.getElement();
                PsiImportStatementBase statementBase = (PsiImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatementBase.class);
                if (statementBase == null || !statementBase.isOnDemand() || JavaMoveDirectoryWithClassesHelper.isUnderRefactoring((PsiElement)statementBase, directoriesToMove)) continue;
                usages.add(new RemoveOnDemandImportStatementsUsageInfo(statementBase));
            }
        }
    }

    private static boolean isUnderRefactoring(PsiElement psiElement, PsiDirectory[] directoriesToMove) {
        for (PsiDirectory directory : directoriesToMove) {
            if (!PsiTreeUtil.isAncestor((PsiElement)directory, (PsiElement)psiElement, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean move(PsiFile file, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewElementsMapping, List<? super PsiFile> movedFiles, RefactoringElementListener listener) {
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        PsiClass[] classes = javaFile.getClasses();
        if (classes.length == 0) {
            return false;
        }
        if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
            return false;
        }
        for (PsiClass psiClass : classes) {
            PsiClass newClass = MoveClassesOrPackagesUtil.doMoveClass(psiClass, moveDestination);
            oldToNewElementsMapping.put((PsiElement)psiClass, (PsiElement)newClass);
            listener.elementMoved((PsiElement)newClass);
        }
        return true;
    }

    @NotNull
    public @Unmodifiable List<UsageInfo> retargetUsages(@NotNull @Unmodifiable List<UsageInfo> usages, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        if (usages == null) {
            JavaMoveDirectoryWithClassesHelper.$$$reportNull$$$0(0);
        }
        if (oldToNewMap == null) {
            JavaMoveDirectoryWithClassesHelper.$$$reportNull$$$0(1);
        }
        List usageInfosToProcess = ContainerUtil.filter(usages, usageInfo -> {
            if (usageInfo instanceof MoveRenameUsageInfo) {
                MoveRenameUsageInfo moveRenameUsageInfo = (MoveRenameUsageInfo)usageInfo;
                PsiElement referencedElement = moveRenameUsageInfo.getReferencedElement();
                if (referencedElement == null) {
                    return false;
                }
                return referencedElement.getContainingFile() instanceof PsiJavaFile;
            }
            return false;
        });
        CommonMoveUtil.retargetUsages((UsageInfo[])usageInfosToProcess.toArray(UsageInfo.EMPTY_ARRAY), oldToNewMap);
        List list = ContainerUtil.filter(usages, u -> !usageInfosToProcess.contains(u));
        if (list == null) {
            JavaMoveDirectoryWithClassesHelper.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void postProcessUsages(UsageInfo[] usages, Function<? super PsiDirectory, ? extends PsiDirectory> newDirMapper) {
        for (UsageInfo usage : usages) {
            PsiPackage newPackage;
            PsiDirectory targetDirectory;
            JavaDirectoryService directoryService;
            PsiPackage oldPackage;
            PsiJavaModule moduleDescriptor;
            MoveDirectoryUsageInfo moveDirUsage;
            PsiDirectory sourceDirectory;
            PsiElement element;
            if (usage instanceof RemoveOnDemandImportStatementsUsageInfo && (element = usage.getElement()) != null) {
                element.delete();
            }
            if (!(usage instanceof MoveDirectoryUsageInfo) || (sourceDirectory = (moveDirUsage = (MoveDirectoryUsageInfo)usage).getSourceDirectory()) == null || (moduleDescriptor = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)sourceDirectory)) == null || (oldPackage = (directoryService = JavaDirectoryService.getInstance()).getPackage(sourceDirectory)) == null || (targetDirectory = (PsiDirectory)ObjectUtils.tryCast((Object)moveDirUsage.getTargetFileItem(), PsiDirectory.class)) == null || (newPackage = directoryService.getPackage(targetDirectory)) == null) continue;
            JavaMoveDirectoryWithClassesHelper.renamePackageStatements(moduleDescriptor.getExports(), oldPackage, newPackage);
            JavaMoveDirectoryWithClassesHelper.renamePackageStatements(moduleDescriptor.getOpens(), oldPackage, newPackage);
        }
    }

    private static void renamePackageStatements(@NotNull Iterable<? extends PsiPackageAccessibilityStatement> packageStatements, @NotNull PsiPackage oldPackage, @NotNull PsiPackage newPackage) {
        if (packageStatements == null) {
            JavaMoveDirectoryWithClassesHelper.$$$reportNull$$$0(3);
        }
        if (oldPackage == null) {
            JavaMoveDirectoryWithClassesHelper.$$$reportNull$$$0(4);
        }
        if (newPackage == null) {
            JavaMoveDirectoryWithClassesHelper.$$$reportNull$$$0(5);
        }
        for (PsiPackageAccessibilityStatement psiPackageAccessibilityStatement : packageStatements) {
            PsiJavaCodeReferenceElement packageReference = psiPackageAccessibilityStatement.getPackageReference();
            if (packageReference == null || !oldPackage.equals((Object)packageReference.resolve())) continue;
            packageReference.bindToElement((PsiElement)newPackage);
            break;
        }
    }

    public void preprocessUsages(Project project, Set<PsiFile> files, UsageInfo[] infos, PsiDirectory targetDirectory, MultiMap<PsiElement, String> conflicts) {
        PsiPackage aPackage;
        if (files == null || files.isEmpty()) {
            return;
        }
        List javaFiles = ContainerUtil.filterIsInstance(files, PsiJavaFile.class);
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)targetDirectory);
        if (vFile != null) {
            RefactoringConflictsUtil.getInstance().analyzeModuleConflicts(project, (Collection)javaFiles, infos, vFile, conflicts);
        }
        if (targetDirectory != null && (aPackage = JavaDirectoryService.getInstance().getPackage(targetDirectory)) != null) {
            MoveClassesOrPackagesProcessor.detectPackageLocalsUsed(conflicts, javaFiles.toArray(PsiElement.EMPTY_ARRAY), new PackageWrapper(aPackage));
        }
    }

    public void beforeMove(PsiFile psiFile) {
        if (!(psiFile instanceof PsiJavaFile)) {
            return;
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)psiFile, (boolean)true);
    }

    public void afterMove(PsiElement newElement) {
        if (!(newElement instanceof PsiJavaFile)) {
            return;
        }
        ChangeContextUtil.decodeContextInfo((PsiElement)newElement, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldToNewMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveClassesOrPackages/JavaMoveDirectoryWithClassesHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageStatements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPackage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/JavaMoveDirectoryWithClassesHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "retargetUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "retargetUsages";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renamePackageStatements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class RemoveOnDemandImportStatementsUsageInfo
    extends UsageInfo {
        RemoveOnDemandImportStatementsUsageInfo(PsiImportStatementBase statementBase) {
            super((PsiElement)statementBase);
        }
    }
}

