/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.java.JavaBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveClassesOrPackagesCallback;
import com.intellij.refactoring.move.MoveMultipleElementsViewDescriptor;
import com.intellij.refactoring.move.moveClassesOrPackages.CommonMoveUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.ModifyModuleStatementUsageInfo;
import com.intellij.refactoring.move.moveClassesOrPackages.ModuleInfoUsageDetector;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveAllClassesInFileHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.PackageLocalsUsageCollector;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classRefs.ClassInstanceScanner;
import com.intellij.refactoring.util.classRefs.ClassReferenceScanner;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveClassesOrPackagesProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(MoveClassesOrPackagesProcessor.class);
    private final PsiElement[] myElementsToMove;
    private boolean mySearchInComments;
    private boolean mySearchInNonJavaFiles;
    @NotNull
    private final PackageWrapper myTargetPackage;
    private final MoveCallback myMoveCallback;
    @NotNull
    protected final MoveDestination myMoveDestination;
    private final ModuleInfoUsageDetector myModuleInfoUsageDetector;
    protected NonCodeUsageInfo[] myNonCodeUsages;
    private boolean myOpenInEditor;
    private MultiMap<PsiElement, @Nls String> myConflicts;

    public MoveClassesOrPackagesProcessor(Project project, PsiElement[] elements, @NotNull MoveDestination moveDestination, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback) {
        if (moveDestination == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(0);
        }
        super(project);
        LinkedHashSet<Object> toMove = new LinkedHashSet<Object>();
        for (PsiElement element : elements) {
            PsiUtilCore.ensureValid((PsiElement)element);
            if (element instanceof PsiClassOwner) {
                PsiClass[] classes = ((PsiClassOwner)element).getClasses();
                if (classes.length > 0) {
                    for (PsiClass aClass : classes) {
                        PsiUtilCore.ensureValid((PsiElement)aClass);
                        toMove.add(aClass);
                    }
                    continue;
                }
                toMove.add(element);
                continue;
            }
            toMove.add(element);
        }
        this.myElementsToMove = PsiUtilCore.toPsiElementArray(toMove);
        Arrays.sort(this.myElementsToMove, (o1, o2) -> {
            VirtualFile virtualFile;
            PsiFile containingFile;
            if (o1 instanceof PsiClass && o2 instanceof PsiClass && Comparing.equal((Object)(containingFile = o1.getContainingFile()), (Object)o2.getContainingFile()) && (virtualFile = containingFile.getVirtualFile()) != null) {
                String fileName = virtualFile.getNameWithoutExtension();
                if (Comparing.strEqual((String)fileName, (String)((PsiClass)o1).getName())) {
                    return -1;
                }
                if (Comparing.strEqual((String)fileName, (String)((PsiClass)o2).getName())) {
                    return 1;
                }
            }
            return 0;
        });
        this.myMoveDestination = moveDestination;
        this.myModuleInfoUsageDetector = ModuleInfoUsageDetector.createModifyUsageInstance(this.myProject, this.myElementsToMove, this.myMoveDestination);
        this.myTargetPackage = this.myMoveDestination.getTargetPackage();
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(1);
        }
        PsiElement[] elements = (PsiElement[])this.myElementsToMove.clone();
        return new MoveMultipleElementsViewDescriptor(elements, MoveClassesOrPackagesUtil.getPackageName(this.myTargetPackage));
    }

    public boolean verifyValidPackageName() {
        PsiNameHelper helper;
        String qName = this.myTargetPackage.getQualifiedName();
        if (!StringUtil.isEmpty((String)qName) && !(helper = PsiNameHelper.getInstance((Project)this.myProject)).isQualifiedName(qName)) {
            Messages.showMessageDialog((Project)this.myProject, (String)JavaRefactoringBundle.message((String)"invalid.target.package.name.specified", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"move.classes.invalid.package.name.warning.message", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    public boolean isSearchInComments() {
        return this.mySearchInComments;
    }

    public boolean isSearchInNonJavaFiles() {
        return this.mySearchInNonJavaFiles;
    }

    public void setSearchInComments(boolean searchInComments) {
        this.mySearchInComments = searchInComments;
    }

    public void setSearchInNonJavaFiles(boolean searchInNonJavaFiles) {
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
    }

    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<UsageInfo> allUsages = new ArrayList<UsageInfo>();
        ArrayList<UsageInfo> usagesToSkip = new ArrayList<UsageInfo>();
        for (PsiElement element : this.myElementsToMove) {
            String newName = this.getNewQName(element);
            UsageInfo[] usages = MoveClassesOrPackagesUtil.findUsages(element, this.myRefactoringScope, this.mySearchInComments, this.mySearchInNonJavaFiles, newName);
            ArrayList<UsageInfo> infos = new ArrayList<UsageInfo>(Arrays.asList(usages));
            allUsages.addAll(infos);
            if (Comparing.strEqual((String)newName, (String)MoveClassesOrPackagesProcessor.getOldQName(element))) {
                usagesToSkip.addAll(infos);
            }
            if (!(element instanceof PsiPackage)) continue;
            for (PsiDirectory directory : ((PsiPackage)element).getDirectories()) {
                UsageInfo[] dirUsages = MoveClassesOrPackagesUtil.findUsages((PsiElement)directory, this.myRefactoringScope, this.mySearchInComments, this.mySearchInNonJavaFiles, newName);
                allUsages.addAll(new ArrayList<UsageInfo>(Arrays.asList(dirUsages)));
            }
        }
        UsageInfo[] usageInfos = allUsages.toArray(UsageInfo.EMPTY_ARRAY);
        this.myConflicts = new MultiMap();
        MoveClassesOrPackagesProcessor.detectConflicts(usageInfos, this.myConflicts, this.myElementsToMove, this.myTargetPackage, this.myMoveDestination);
        this.myModuleInfoUsageDetector.detectModuleStatementsUsed(allUsages, this.myConflicts);
        allUsages.removeAll(usagesToSkip);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])allUsages.toArray(UsageInfo.EMPTY_ARRAY));
        if (usageInfoArray == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    public static void detectConflicts(UsageInfo[] usageInfos, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, PsiElement @NotNull [] elementsToMove, @NotNull PackageWrapper targetPackage, @NotNull MoveDestination moveDestination) {
        if (targetPackage == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(3);
        }
        if (moveDestination == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(4);
        }
        if (elementsToMove == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(5);
        }
        moveDestination.analyzeModuleConflicts(Arrays.asList(elementsToMove), conflicts, usageInfos);
        MoveClassesOrPackagesProcessor.detectPackageLocalsMoved(usageInfos, conflicts, targetPackage, elementsToMove);
        MoveClassesOrPackagesProcessor.detectPackageLocalsUsed(conflicts, elementsToMove, targetPackage);
        MoveClassesOrPackagesProcessor.detectMoveToDefaultPackage(usageInfos, conflicts, targetPackage);
    }

    private static void detectMoveToDefaultPackage(UsageInfo[] infos, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, PackageWrapper aPackage) {
        if (!aPackage.getQualifiedName().isEmpty()) {
            return;
        }
        HashSet<PsiFile> filesWithImports = new HashSet<PsiFile>();
        for (UsageInfo info : infos) {
            PsiReference reference;
            PsiElement element = info.getElement();
            if (element == null || (reference = info.getReference()) == null) continue;
            PsiElement target = reference.resolve();
            PsiFile file = element.getContainingFile();
            if (!(file instanceof PsiJavaFile) || target == null || !filesWithImports.add(file) || ((PsiJavaFile)file).getPackageName().isEmpty()) continue;
            conflicts.putValue((Object)element, (Object)JavaBundle.message((String)"move.class.import.from.default.package.conflict", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)target, (boolean)false)}));
        }
    }

    public List<PsiElement> getElements() {
        return List.of(this.myElementsToMove);
    }

    public PackageWrapper getTargetPackage() {
        return this.myMoveDestination.getTargetPackage();
    }

    public void setOpenInEditor(boolean openInEditor) {
        this.myOpenInEditor = openInEditor;
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.move";
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(this.myElementsToMove);
        return data;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(6);
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElements((PsiElement[])this.myTargetPackage.getDirectories());
        data.addElement((PsiElement)JavaPsiFacade.getInstance((Project)this.myProject).findPackage(this.myTargetPackage.getQualifiedName()));
        return data;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(7);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        return this.showConflicts(this.myConflicts, usages);
    }

    private static boolean isInsideMoved(PsiElement place, PsiElement[] elementsToMove) {
        for (PsiElement element : elementsToMove) {
            if (!(element instanceof PsiClass) || !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)place, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    static void detectPackageLocalsUsed(MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, PsiElement[] elementsToMove, PackageWrapper targetPackage) {
        PackageLocalsUsageCollector visitor2 = new PackageLocalsUsageCollector(elementsToMove, targetPackage, conflicts);
        for (PsiElement element : elementsToMove) {
            if (element.getContainingFile() == null) continue;
            element.accept((PsiElementVisitor)visitor2);
        }
    }

    private static void detectPackageLocalsMoved(UsageInfo[] usages, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, @NotNull PackageWrapper targetPackage, PsiElement[] elementsToMove) {
        if (targetPackage == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(8);
        }
        HashSet<PsiClass> movedClasses = new HashSet<PsiClass>();
        HashMap<PsiClass, Set> reportedClassToContainers = new HashMap<PsiClass, Set>();
        for (UsageInfo usage : usages) {
            PsiPackage usagePackage;
            PsiDirectory directory;
            PsiElement psiElement;
            PsiElement element = usage.getElement();
            if (element == null || !(usage instanceof MoveRenameUsageInfo)) continue;
            MoveRenameUsageInfo moveRenameUsageInfo = (MoveRenameUsageInfo)usage;
            if (usage instanceof NonCodeUsageInfo || !((psiElement = moveRenameUsageInfo.getReferencedElement()) instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)psiElement;
            movedClasses.add(aClass);
            if (!aClass.hasModifierProperty("packageLocal") || PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class) != null) continue;
            PsiElement container = ConflictsUtil.getContainer(element);
            Set reported = reportedClassToContainers.computeIfAbsent(aClass, __ -> new HashSet());
            if (reported.contains(container)) continue;
            reported.add(container);
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null || MoveClassesOrPackagesProcessor.isInsideMoved(element, elementsToMove) || (directory = containingFile.getContainingDirectory()) == null || (usagePackage = JavaDirectoryService.getInstance().getPackage(directory)) == null || targetPackage.equalToPackage(usagePackage)) continue;
            String message = JavaRefactoringBundle.message((String)"a.package.local.class.0.will.no.longer.be.accessible.from.1", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)aClass.getName()), RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true)});
            conflicts.putValue((Object)aClass, (Object)message);
        }
        MyClassInstanceReferenceVisitor instanceReferenceVisitor = new MyClassInstanceReferenceVisitor(targetPackage, elementsToMove, conflicts);
        for (PsiClass aClass : movedClasses) {
            String visibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList());
            if ("packageLocal".equals(visibility)) {
                MoveClassesOrPackagesProcessor.findInstancesOfPackageLocal(aClass, usages, instanceReferenceVisitor);
                continue;
            }
            MoveClassesOrPackagesProcessor.findPublicClassConflicts(aClass, instanceReferenceVisitor);
        }
    }

    private static void findPublicClassConflicts(PsiClass aClass, MyClassInstanceReferenceVisitor instanceReferenceVisitor) {
        NonPublicClassMemberWrappersSet members = new NonPublicClassMemberWrappersSet();
        members.addElements((PsiMember[])aClass.getFields());
        members.addElements((PsiMember[])aClass.getMethods());
        members.addElements((PsiMember[])aClass.getInnerClasses());
        RefactoringUtil.IsDescendantOf isDescendantOf = new RefactoringUtil.IsDescendantOf(aClass);
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(aClass.getContainingFile().getContainingDirectory());
        GlobalSearchScope packageScope = aPackage == null ? aClass.getResolveScope() : PackageScope.packageScopeWithoutLibraries((PsiPackage)aPackage, (boolean)false);
        for (ClassMemberWrapper memberWrapper : members) {
            ReferencesSearch.search((PsiElement)memberWrapper.getMember(), (SearchScope)packageScope, (boolean)false).forEach(reference -> {
                PsiElement element = reference.getElement();
                if (element instanceof PsiReferenceExpression) {
                    PsiReferenceExpression expression = (PsiReferenceExpression)element;
                    PsiExpression qualifierExpression = expression.getQualifierExpression();
                    if (qualifierExpression != null) {
                        PsiClass resolvedTypeClass;
                        PsiType type = qualifierExpression.getType();
                        if (type != null && isDescendantOf.value(resolvedTypeClass = PsiUtil.resolveClassInType((PsiType)type))) {
                            instanceReferenceVisitor.visitMemberReference(memberWrapper.getMember(), expression, isDescendantOf);
                        }
                    } else {
                        instanceReferenceVisitor.visitMemberReference(memberWrapper.getMember(), expression, isDescendantOf);
                    }
                }
                return true;
            });
        }
    }

    private static void findInstancesOfPackageLocal(final PsiClass aClass, final UsageInfo[] usages, MyClassInstanceReferenceVisitor instanceReferenceVisitor) {
        ClassReferenceScanner referenceScanner = new ClassReferenceScanner(aClass){

            @Override
            public PsiReference[] findReferences() {
                ArrayList<PsiReference> result = new ArrayList<PsiReference>();
                for (UsageInfo usage : usages) {
                    PsiReference reference;
                    if (!(usage instanceof MoveRenameUsageInfo) || ((MoveRenameUsageInfo)usage).getReferencedElement() != aClass || (reference = usage.getReference()) == null) continue;
                    result.add(reference);
                }
                return result.toArray(PsiReference.EMPTY_ARRAY);
            }
        };
        referenceScanner.processReferences(new ClassInstanceScanner(aClass, instanceReferenceVisitor));
    }

    @NotNull
    private String getNewQName(@NotNull PsiElement element) {
        if (element == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(9);
        }
        String qualifiedName = this.myTargetPackage.getQualifiedName();
        PsiElement psiElement = element;
        Objects.requireNonNull(psiElement);
        PsiElement psiElement2 = psiElement;
        int n = 0;
        String string = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiClass.class, PsiPackage.class, PsiClassOwner.class}, (Object)psiElement2, n)) {
            case 0 -> {
                PsiClass aClass = (PsiClass)psiElement2;
                yield StringUtil.getQualifiedName((String)qualifiedName, (String)StringUtil.notNullize((String)aClass.getName()));
            }
            case 1 -> {
                PsiPackage aPackage = (PsiPackage)psiElement2;
                yield StringUtil.getQualifiedName((String)qualifiedName, (String)StringUtil.notNullize((String)aPackage.getName()));
            }
            case 2 -> {
                PsiClassOwner owner = (PsiClassOwner)psiElement2;
                yield owner.getName();
            }
            default -> throw new IllegalArgumentException("Unexpected element: " + String.valueOf(element));
        };
        if (string == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    private static String getOldQName(@NotNull PsiElement element) {
        if (element == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(11);
        }
        PsiElement psiElement = element;
        Objects.requireNonNull(psiElement);
        PsiElement psiElement2 = psiElement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiClass.class, PsiPackage.class, PsiClassOwner.class}, (Object)psiElement2, n)) {
            case 0 -> {
                PsiClass aClass = (PsiClass)psiElement2;
                yield aClass.getQualifiedName();
            }
            case 1 -> {
                PsiPackage aPackage = (PsiPackage)psiElement2;
                yield aPackage.getQualifiedName();
            }
            case 2 -> {
                PsiClassOwner owner = (PsiClassOwner)psiElement2;
                yield owner.getName();
            }
            default -> throw new IllegalArgumentException("Unexpected element: " + String.valueOf(element));
        };
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(12);
        }
        LOG.assertTrue(elements.length == this.myElementsToMove.length);
        System.arraycopy(elements, 0, this.myElementsToMove, 0, elements.length);
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(13);
        }
        if (UsageViewUtil.reportNonRegularUsages((UsageInfo[])usages, (Project)this.myProject)) {
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(14);
        }
        Object[] elementsToMove = (PsiElement[])this.myElementsToMove.clone();
        List listeners = ContainerUtil.map((Object[])elementsToMove, psiElement -> this.getTransaction().getElementListener(psiElement));
        ArrayList<@Nullable Object> movedElements = new ArrayList<Object>(Collections.nCopies(listeners.size(), null));
        ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
        ArrayList<UsageInfo> codeUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof MoveRenameUsageInfo)) continue;
            if (usage instanceof NonCodeUsageInfo) {
                nonCodeUsages.add((NonCodeUsageInfo)usage);
                continue;
            }
            codeUsages.add(usage);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setIndeterminate(false);
        }
        try {
            HashMap<PsiClass, Boolean> allClasses = new HashMap<PsiClass, Boolean>();
            for (Object element : elementsToMove) {
                PsiClass psiClass;
                if (!(element instanceof PsiClass) || allClasses.containsKey(psiClass = (PsiClass)element)) continue;
                for (MoveAllClassesInFileHandler fileHandler : MoveAllClassesInFileHandler.EP_NAME.getExtensionList()) {
                    fileHandler.processMoveAllClassesInFile(allClasses, psiClass, (PsiElement[])elementsToMove);
                }
            }
            for (Object element : elementsToMove) {
                if (!(element instanceof PsiClass)) continue;
                MoveClassesOrPackagesUtil.prepareMoveClass((PsiClass)element);
            }
            HashMap<Object, Object> oldToNewElementsMapping = new HashMap<Object, Object>();
            for (int idx = 0; idx < elementsToMove.length; ++idx) {
                Object element = elementsToMove[idx];
                if (element instanceof PsiPackage) {
                    GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.myProject);
                    PsiDirectory[] directories = ((PsiPackage)element).getDirectories(scope);
                    PsiPackage newElement = MoveClassesOrPackagesUtil.doMovePackage((PsiPackage)element, scope, this.myMoveDestination);
                    oldToNewElementsMapping.put(element, newElement);
                    int i = 0;
                    PsiDirectory[] newDirectories = newElement.getDirectories(scope);
                    if (newDirectories.length == 1) {
                        for (PsiDirectory directory : directories) {
                            oldToNewElementsMapping.put(directory, newDirectories[0]);
                        }
                    } else {
                        for (PsiDirectory directory : directories) {
                            if (this.myMoveDestination.verify(directory) != null) continue;
                            oldToNewElementsMapping.put(directory, newDirectories[i++]);
                        }
                    }
                    element = newElement;
                } else if (element instanceof PsiClass) {
                    PsiClass psiClass = (PsiClass)element;
                    PsiClass newElement = MoveClassesOrPackagesUtil.doMoveClass(psiClass, this.myMoveDestination.getTargetDirectory(element.getContainingFile()), (Boolean)allClasses.get(psiClass));
                    oldToNewElementsMapping.put(element, newElement);
                    element = newElement;
                } else if (element instanceof PsiClassOwner) {
                    String qualifiedName;
                    PsiDirectory directory = this.myMoveDestination.getTargetDirectory(element.getContainingFile());
                    MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)((PsiClassOwner)element), (PsiDirectory)directory);
                    PsiFile newElement = directory.findFile(((PsiClassOwner)element).getName());
                    LOG.assertTrue(newElement != null);
                    DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
                    PsiPackage newPackage = JavaDirectoryService.getInstance().getPackage(directory);
                    if (newPackage != null && !Comparing.strEqual((String)(qualifiedName = newPackage.getQualifiedName()), (String)((PsiClassOwner)newElement).getPackageName()) && (qualifiedName.isEmpty() || PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(qualifiedName))) {
                        ((PsiClassOwner)newElement).setPackageName(qualifiedName);
                    }
                    oldToNewElementsMapping.put(element, newElement);
                    element = newElement;
                } else {
                    LOG.error("Unexpected element to move: " + String.valueOf(element));
                }
                movedElements.set(idx, SmartPointerManager.createPointer((PsiElement)element));
                elementsToMove[idx] = element;
            }
            DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
            CommonMoveUtil.retargetUsages((UsageInfo[])codeUsages.toArray(UsageInfo.EMPTY_ARRAY), oldToNewElementsMapping);
            this.myNonCodeUsages = nonCodeUsages.toArray(new NonCodeUsageInfo[0]);
            for (Object element : elementsToMove) {
                if (!(element instanceof PsiClass)) continue;
                MoveClassesOrPackagesUtil.finishMoveClass((PsiClass)element);
            }
            this.modifyModuleStatementsInDescriptor(usages);
            this.afterMovement(listeners, movedElements);
        }
        catch (IncorrectOperationException e) {
            this.myNonCodeUsages = new NonCodeUsageInfo[0];
            RefactoringUIUtil.processIncorrectOperation((Project)this.myProject, (IncorrectOperationException)e);
        }
    }

    private void modifyModuleStatementsInDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(15);
        }
        SmartList allUsages = new SmartList((Object[])usages);
        allUsages.addAll(this.myModuleInfoUsageDetector.createUsageInfosForNewlyCreatedDirs());
        Map moduleStatementsByDescriptor = StreamEx.of((Collection)allUsages).select(ModifyModuleStatementUsageInfo.class).groupingBy(usage -> usage.getModuleDescriptor());
        MoveClassesOrPackagesProcessor.modifyModuleStatements(moduleStatementsByDescriptor);
    }

    public static void modifyModuleStatements(@NotNull Map<PsiJavaModule, List<ModifyModuleStatementUsageInfo>> moduleStatementsByDescriptor) {
        if (moduleStatementsByDescriptor == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(16);
        }
        if (moduleStatementsByDescriptor.isEmpty()) {
            return;
        }
        MultiMap lastDeletionUsageInfos = new MultiMap();
        for (Map.Entry<PsiJavaModule, List<ModifyModuleStatementUsageInfo>> entry : moduleStatementsByDescriptor.entrySet()) {
            PsiJavaModule moduleDescriptor = entry.getKey();
            for (ModifyModuleStatementUsageInfo modifyStatementInfo : entry.getValue()) {
                if (modifyStatementInfo.getModuleStatement() == null) continue;
                if (modifyStatementInfo.isAddition()) {
                    PsiUtil.addModuleStatement((PsiJavaModule)moduleDescriptor, (PsiStatement)modifyStatementInfo.getModuleStatement());
                    continue;
                }
                if (modifyStatementInfo.isLastDeletion()) {
                    lastDeletionUsageInfos.putValue((Object)moduleDescriptor, (Object)modifyStatementInfo);
                    continue;
                }
                if (!modifyStatementInfo.isDeletion()) continue;
                MoveClassesOrPackagesProcessor.deleteModuleStatements(moduleDescriptor, Set.of(modifyStatementInfo.getModuleStatement().getText()));
            }
        }
        if (lastDeletionUsageInfos.isEmpty()) {
            return;
        }
        PsiJavaModule firstModule = (PsiJavaModule)lastDeletionUsageInfos.keySet().iterator().next();
        final Project project = firstModule.getProject();
        String projectPath = project.getBasePath();
        if (projectPath == null) {
            return;
        }
        final MultiMap packageStatementsByModulePath = MultiMap.createSet();
        for (Map.Entry entry : lastDeletionUsageInfos.entrySet()) {
            for (ModifyModuleStatementUsageInfo usageInfo : (Collection)entry.getValue()) {
                VirtualFile moduleFile;
                PsiPackageAccessibilityStatement packageStatement = usageInfo.getModuleStatement();
                if (packageStatement == null || (moduleFile = ((PsiJavaModule)entry.getKey()).getContainingFile().getVirtualFile()) == null) continue;
                packageStatementsByModulePath.putValue((Object)moduleFile.getPath(), (Object)packageStatement.getText());
            }
        }
        NotificationGroupManager.getInstance().getNotificationGroup("Remove redundant exports/opens").createNotification(JavaRefactoringBundle.message((String)"move.classes.or.packages.unused.exports.notification.title", (Object[])new Object[]{lastDeletionUsageInfos.size()}), MoveClassesOrPackagesProcessor.createNotificationContent(projectPath, lastDeletionUsageInfos.keySet()), NotificationType.INFORMATION).setListener((notification, event) -> {
            PsiJavaModule moduleDescriptor = MoveClassesOrPackagesProcessor.findModuleByPath(project, event.getDescription());
            if (moduleDescriptor != null) {
                moduleDescriptor.navigate(true);
            }
        }).addAction((AnAction)new NotificationAction(JavaRefactoringBundle.message((String)"move.classes.or.packages.unused.exports.action.name", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                WriteCommandAction.writeCommandAction((Project)project).withName(JavaRefactoringBundle.message((String)"move.classes.or.packages.unused.exports.command.name", (Object[])new Object[0])).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).withGlobalUndo().run(() -> {
                    for (Map.Entry entry : packageStatementsByModulePath.entrySet()) {
                        PsiJavaModule moduleDescriptor = MoveClassesOrPackagesProcessor.findModuleByPath(project, (String)entry.getKey());
                        if (moduleDescriptor == null) continue;
                        MoveClassesOrPackagesProcessor.deleteModuleStatements(moduleDescriptor, (Set)entry.getValue());
                    }
                });
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
    }

    private static void deleteModuleStatements(@NotNull PsiJavaModule moduleDescriptor, @NotNull Set<String> packageStatementsText) {
        if (moduleDescriptor == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(17);
        }
        if (packageStatementsText == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(18);
        }
        SmartList packageStatements = new SmartList();
        for (PsiPackageAccessibilityStatement exportStatement : moduleDescriptor.getExports()) {
            packageStatements.add(exportStatement);
        }
        for (PsiPackageAccessibilityStatement openStatement : moduleDescriptor.getOpens()) {
            packageStatements.add(openStatement);
        }
        for (PsiPackageAccessibilityStatement packageStatement : packageStatements) {
            if (!packageStatementsText.contains(packageStatement.getText())) continue;
            packageStatement.delete();
        }
    }

    @NlsSafe
    @NotNull
    private static String createNotificationContent(@NotNull String projectPath, @NotNull Set<PsiJavaModule> moduleDescriptors) {
        if (projectPath == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(19);
        }
        if (moduleDescriptors == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(20);
        }
        MultiMap modulesPathsByName = new MultiMap();
        for (PsiJavaModule moduleDescriptor : moduleDescriptors) {
            VirtualFile moduleFile = moduleDescriptor.getContainingFile().getVirtualFile();
            if (moduleFile == null) continue;
            modulesPathsByName.putValue((Object)moduleDescriptor.getName(), (Object)moduleFile.getPath());
        }
        HtmlBuilder contentBuilder = new HtmlBuilder();
        for (Map.Entry entry : modulesPathsByName.entrySet()) {
            @NlsSafe String moduleName = (String)entry.getKey();
            Collection modulePaths = (Collection)entry.getValue();
            if (modulePaths.size() == 1) {
                contentBuilder.appendLink((String)modulePaths.iterator().next(), "module-info.java (" + moduleName + ")").br();
                continue;
            }
            for (String modulePath : modulePaths) {
                String relativeModulePath = FileUtil.getRelativePath((String)projectPath, (String)modulePath, (char)'/');
                contentBuilder.appendLink(modulePath, relativeModulePath + " (" + moduleName + ")").br();
            }
        }
        String string = contentBuilder.toString();
        if (string == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    private static PsiJavaModule findModuleByPath(@NotNull Project project, @NotNull String modulePath) {
        VirtualFile moduleFile;
        if (project == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(22);
        }
        if (modulePath == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(23);
        }
        if ((moduleFile = LocalFileSystem.getInstance().findFileByPath(modulePath)) == null) {
            return null;
        }
        return JavaModuleGraphUtil.findDescriptorByFile((VirtualFile)moduleFile, (Project)project);
    }

    private void afterMovement(List<RefactoringElementListener> listeners, List<@Nullable SmartPsiElementPointer<?>> movedElements) {
        for (int i = 0; i < listeners.size(); ++i) {
            PsiElement element = MoveClassesOrPackagesProcessor.getOriginalPsi(movedElements.get(i));
            if (element == null) continue;
            if (this.myElementsToMove[i] instanceof PsiPackage) {
                ((PsiPackage)this.myElementsToMove[i]).handleQualifiedNameChange(((PsiPackage)element).getQualifiedName());
            }
            listeners.get(i).elementMoved(element);
        }
        if (this.myOpenInEditor) {
            ApplicationManager.getApplication().invokeLater(() -> EditorHelper.openFilesInEditor((PsiElement[])ContainerUtil.mapNotNull((Collection)movedElements, p -> MoveClassesOrPackagesProcessor.getOriginalPsi(p)).toArray(PsiElement.EMPTY_ARRAY)));
        }
    }

    @Nullable
    private static PsiElement getOriginalPsi(SmartPsiElementPointer<?> pointer) {
        return pointer == null ? null : pointer.getElement();
    }

    protected void performPsiSpoilingRefactoring() {
        RenameUtil.renameNonCodeUsages((Project)this.myProject, (NonCodeUsageInfo[])this.myNonCodeUsages);
        this.invokeMoveCallback();
    }

    private void invokeMoveCallback() {
        if (this.myMoveCallback != null) {
            if (this.myMoveCallback instanceof MoveClassesOrPackagesCallback) {
                ((MoveClassesOrPackagesCallback)this.myMoveCallback).classesOrPackagesMoved(this.myMoveDestination);
            }
            this.myMoveCallback.refactoringCompleted();
        }
    }

    @NotNull
    protected String getCommandName() {
        String elements = RefactoringUIUtil.calculatePsiElementDescriptionList((PsiElement[])this.myElementsToMove);
        String target = this.myTargetPackage.getQualifiedName();
        String string = JavaRefactoringBundle.message((String)"move.classes.command", (Object[])new Object[]{elements, target});
        if (string == null) {
            MoveClassesOrPackagesProcessor.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10, 21, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveDestination";
                break;
            }
            case 1: 
            case 6: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 10: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPackage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleStatementsByDescriptor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageStatementsText";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptors";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewQName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificationContent";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 2: 
            case 10: 
            case 21: 
            case 24: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detectConflicts";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "detectPackageLocalsMoved";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNewQName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOldQName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "modifyModuleStatementsInDescriptor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "modifyModuleStatements";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deleteModuleStatements";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationContent";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 10, 21, 24 -> new IllegalStateException(string);
        };
    }

    private static class MyClassInstanceReferenceVisitor
    implements ClassInstanceScanner.ClassInstanceReferenceVisitor {
        private final MultiMap<PsiElement, @NlsContexts.DialogMessage String> myConflicts;
        private final Map<PsiModifierListOwner, HashSet<PsiElement>> myReportedElementToContainer;
        private final Map<PsiClass, RefactoringUtil.IsDescendantOf> myIsDescendantOfCache;
        @NotNull
        private final PackageWrapper myTargetPackage;
        private final PsiElement[] myElementsToMove;

        MyClassInstanceReferenceVisitor(@NotNull PackageWrapper targetPackage, PsiElement[] elementsToMove, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
            if (targetPackage == null) {
                MyClassInstanceReferenceVisitor.$$$reportNull$$$0(0);
            }
            this.myReportedElementToContainer = new HashMap<PsiModifierListOwner, HashSet<PsiElement>>();
            this.myIsDescendantOfCache = new HashMap<PsiClass, RefactoringUtil.IsDescendantOf>();
            this.myConflicts = conflicts;
            this.myTargetPackage = targetPackage;
            this.myElementsToMove = elementsToMove;
        }

        @Override
        public void visitQualifier(PsiReferenceExpression qualified, PsiExpression instanceRef, PsiElement referencedInstance) {
            PsiElement resolved = qualified.resolve();
            if (resolved instanceof PsiMember) {
                PsiMember member = (PsiMember)resolved;
                PsiClass containingClass = member.getContainingClass();
                RefactoringUtil.IsDescendantOf isDescendantOf = this.myIsDescendantOfCache.get(containingClass);
                if (isDescendantOf == null) {
                    isDescendantOf = new RefactoringUtil.IsDescendantOf(containingClass);
                    this.myIsDescendantOfCache.put(containingClass, isDescendantOf);
                }
                this.visitMemberReference((PsiModifierListOwner)member, qualified, isDescendantOf);
            }
        }

        private synchronized void visitMemberReference(PsiModifierListOwner member, PsiReferenceExpression qualified, RefactoringUtil.IsDescendantOf descendantOf) {
            if (member.hasModifierProperty("packageLocal")) {
                this.visitPackageLocalMemberReference((PsiJavaCodeReferenceElement)qualified, member, this.myElementsToMove);
            } else if (member.hasModifierProperty("protected")) {
                PsiExpression qualifier = qualified.getQualifierExpression();
                if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                    this.visitPackageLocalMemberReference((PsiJavaCodeReferenceElement)qualified, member, this.myElementsToMove);
                } else if (!MyClassInstanceReferenceVisitor.isInInheritor(qualified, descendantOf)) {
                    this.visitPackageLocalMemberReference((PsiJavaCodeReferenceElement)qualified, member, this.myElementsToMove);
                }
            }
        }

        private static boolean isInInheritor(PsiReferenceExpression qualified, RefactoringUtil.IsDescendantOf descendantOf) {
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)qualified, PsiClass.class);
            while (aClass != null) {
                if (descendantOf.value(aClass)) {
                    return true;
                }
                aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
            }
            return false;
        }

        private void visitPackageLocalMemberReference(PsiJavaCodeReferenceElement qualified, PsiModifierListOwner member, PsiElement[] elementsToMove) {
            PsiElement container = ConflictsUtil.getContainer((PsiElement)qualified);
            Set reportedContainers = this.myReportedElementToContainer.computeIfAbsent(member, __ -> new HashSet());
            if (!reportedContainers.contains(container)) {
                PsiPackage aPackage;
                PsiDirectory directory;
                PsiFile containingFile;
                reportedContainers.add(container);
                if (!MoveClassesOrPackagesProcessor.isInsideMoved(container, elementsToMove) && (containingFile = container.getContainingFile()) != null && (directory = containingFile.getContainingDirectory()) != null && !this.myTargetPackage.equalToPackage(aPackage = JavaDirectoryService.getInstance().getPackage(directory))) {
                    String message = JavaRefactoringBundle.message((String)"0.will.be.inaccessible.from.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true)});
                    this.myConflicts.putValue((Object)member, (Object)StringUtil.capitalize((String)message));
                }
            }
        }

        @Override
        public void visitTypeCast(PsiTypeCastExpression typeCastExpression, PsiExpression instanceRef, PsiElement referencedInstance) {
        }

        @Override
        public void visitReadUsage(PsiExpression instanceRef, PsiType expectedType, PsiElement referencedInstance) {
        }

        @Override
        public void visitWriteUsage(PsiExpression instanceRef, PsiType assignedType, PsiElement referencedInstance) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPackage", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesProcessor$MyClassInstanceReferenceVisitor", "<init>"));
        }
    }

    private static class NonPublicClassMemberWrappersSet
    extends HashSet<ClassMemberWrapper> {
        private NonPublicClassMemberWrappersSet() {
        }

        public void addElement(PsiMember member) {
            PsiNamedElement namedElement = (PsiNamedElement)member;
            if (member.hasModifierProperty("public")) {
                return;
            }
            if (member.hasModifierProperty("private")) {
                return;
            }
            this.add(new ClassMemberWrapper(namedElement));
        }

        public void addElements(PsiMember[] members) {
            for (PsiMember member : members) {
                this.addElement(member);
            }
        }
    }

    static class ClassMemberWrapper {
        final PsiNamedElement myElement;
        final PsiModifierListOwner myMember;

        ClassMemberWrapper(PsiNamedElement element) {
            this.myElement = element;
            this.myMember = (PsiModifierListOwner)element;
        }

        PsiModifierListOwner getMember() {
            return this.myMember;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassMemberWrapper)) {
                return false;
            }
            ClassMemberWrapper wrapper = (ClassMemberWrapper)o;
            PsiNamedElement psiNamedElement = this.myElement;
            if (psiNamedElement instanceof PsiMethod) {
                PsiMethod wrapperMethod;
                PsiMethod method = (PsiMethod)psiNamedElement;
                PsiNamedElement psiNamedElement2 = wrapper.myElement;
                return psiNamedElement2 instanceof PsiMethod && MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)(wrapperMethod = (PsiMethod)psiNamedElement2));
            }
            return Objects.equals(this.myElement.getName(), wrapper.myElement.getName());
        }

        public int hashCode() {
            String name = this.myElement.getName();
            if (name != null) {
                return name.hashCode();
            }
            return 0;
        }
    }
}

