/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.lang.java.JavaFindUsagesProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonMoveClassesOrPackagesUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MoveClassesOrPackagesUtil {
    private static final Logger LOG = Logger.getInstance(MoveClassesOrPackagesUtil.class);

    private MoveClassesOrPackagesUtil() {
    }

    @Deprecated
    public static UsageInfo[] findUsages(PsiElement element, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, String newQName) {
        return MoveClassesOrPackagesUtil.findUsages(element, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject()), searchInStringsAndComments, searchInNonJavaFiles, newQName);
    }

    public static UsageInfo @NotNull [] findUsages(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, String newQName) {
        if (element == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(1);
        }
        List<UsageInfo> results = Collections.synchronizedList(new ArrayList());
        HashSet<PsiReference> foundReferences = new HashSet<PsiReference>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)element, (SearchScope)searchScope, (boolean)false).asIterable()) {
            TextRange range = reference.getRangeInElement();
            if (foundReferences.contains(reference)) continue;
            results.add((UsageInfo)new MoveRenameUsageInfo(reference.getElement(), reference, range.getStartOffset(), range.getEndOffset(), element, false));
            foundReferences.add(reference);
        }
        MoveClassesOrPackagesUtil.findNonCodeUsages(element, searchScope, searchInStringsAndComments, searchInNonJavaFiles, newQName, results);
        MoveClassesOrPackagesUtil.preprocessUsages(results);
        UsageInfo[] usageInfoArray = results.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    private static void preprocessUsages(@NotNull List<UsageInfo> results) {
        if (results == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(3);
        }
        for (MoveClassHandler handler : (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions()) {
            handler.preprocessUsages(results);
        }
    }

    public static void findNonCodeUsages(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, String newQName, @NotNull Collection<? super UsageInfo> results) {
        String stringToSearch;
        if (element == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(5);
        }
        if (results == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(6);
        }
        if ((stringToSearch = MoveClassesOrPackagesUtil.getStringToSearch(element)) == null) {
            return;
        }
        TextOccurrencesUtil.findNonCodeUsages((PsiElement)element, (SearchScope)searchScope, (String)stringToSearch, (boolean)searchInStringsAndComments, (boolean)searchInNonJavaFiles, (String)newQName, results);
    }

    private static String getStringToSearch(@Nullable PsiElement element) {
        PsiElement psiElement = element;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiPackage.class, PsiClass.class, PsiDirectory.class, PsiClassOwner.class}, (Object)psiElement, n)) {
            case 0 -> {
                PsiPackage aPackage = (PsiPackage)psiElement;
                yield aPackage.getQualifiedName();
            }
            case 1 -> {
                PsiClass aClass = (PsiClass)psiElement;
                yield aClass.getQualifiedName();
            }
            case 2 -> {
                PsiDirectory directory = (PsiDirectory)psiElement;
                yield MoveClassesOrPackagesUtil.getStringToSearch((PsiElement)JavaDirectoryService.getInstance().getPackage(directory));
            }
            case 3 -> {
                PsiClassOwner owner = (PsiClassOwner)psiElement;
                yield owner.getName();
            }
            default -> throw new IllegalArgumentException("Unknown element: " + (element == null ? null : element.getClass().getName()));
        };
    }

    @NotNull
    static PsiPackage doMovePackage(@NotNull PsiPackage aPackage, @NotNull GlobalSearchScope scope, @NotNull MoveDestination moveDestination) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        PackageWrapper targetPackage;
        if (aPackage == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(8);
        }
        if (moveDestination == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(9);
        }
        Object newPrefix = (targetPackage = moveDestination.getTargetPackage()).getQualifiedName().isEmpty() ? "" : targetPackage.getQualifiedName() + ".";
        String newPackageQualifiedName = (String)newPrefix + aPackage.getName();
        for (PsiDirectory dir : dirs = aPackage.getDirectories(scope)) {
            PsiDirectory targetDirectory = moveDestination.getTargetDirectory(dir);
            if (targetDirectory == null) continue;
            MoveClassesOrPackagesUtil.moveDirectoryRecursively(dir, targetDirectory);
        }
        return new PsiPackageImpl(aPackage.getManager(), newPackageQualifiedName);
    }

    public static void moveDirectoryRecursively(PsiDirectory dir, PsiDirectory destination) throws IncorrectOperationException {
        if (dir.getParentDirectory() == destination) {
            return;
        }
        MoveClassesOrPackagesUtil.moveDirectoryRecursively(dir, destination, new HashSet());
    }

    private static void moveDirectoryRecursively(PsiDirectory dir, PsiDirectory destination, HashSet<? super VirtualFile> movedPaths) throws IncorrectOperationException {
        PsiDirectory subdirectoryInDest;
        String sourcePackageName;
        VirtualFile destVFile = destination.getVirtualFile();
        VirtualFile sourceVFile = dir.getVirtualFile();
        if (movedPaths.contains(sourceVFile)) {
            return;
        }
        String targetName = dir.getName();
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(dir);
        if (aPackage != null && (sourcePackageName = aPackage.getName()) != null && !sourcePackageName.equals(targetName)) {
            targetName = sourcePackageName;
        }
        boolean isSourceRoot = RefactoringUtil.isSourceRoot(dir);
        if (VfsUtilCore.isAncestor((VirtualFile)sourceVFile, (VirtualFile)destVFile, (boolean)false) || isSourceRoot) {
            PsiDirectory existingSubdir = destination.findSubdirectory(targetName);
            if (existingSubdir == null) {
                subdirectoryInDest = destination.createSubdirectory(targetName);
                movedPaths.add((VirtualFile)subdirectoryInDest.getVirtualFile());
            } else {
                subdirectoryInDest = existingSubdir;
            }
        } else {
            subdirectoryInDest = destination.findSubdirectory(targetName);
        }
        if (subdirectoryInDest == null) {
            VirtualFile virtualFile = dir.getVirtualFile();
            MoveFilesOrDirectoriesUtil.doMoveDirectory((PsiDirectory)dir, (PsiDirectory)destination);
            movedPaths.add((VirtualFile)virtualFile);
        } else {
            PsiDirectory[] subdirectories;
            PsiFile[] files;
            for (PsiFile file : files = dir.getFiles()) {
                try {
                    subdirectoryInDest.checkAdd((PsiElement)file);
                }
                catch (IncorrectOperationException e) {
                    continue;
                }
                MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)file, (PsiDirectory)subdirectoryInDest);
            }
            for (PsiDirectory subdirectory : subdirectories = dir.getSubdirectories()) {
                if (subdirectory.equals((Object)subdirectoryInDest)) continue;
                MoveClassesOrPackagesUtil.moveDirectoryRecursively(subdirectory, subdirectoryInDest, movedPaths);
            }
            if (!isSourceRoot && dir.getFiles().length == 0 && dir.getSubdirectories().length == 0) {
                dir.delete();
            }
        }
    }

    public static void prepareMoveClass(PsiClass aClass) {
        for (MoveClassHandler handler : (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions()) {
            handler.prepareMove(aClass);
        }
    }

    public static void finishMoveClass(PsiClass aClass) {
        for (MoveClassHandler handler : (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions()) {
            handler.finishMoveClass(aClass);
        }
    }

    public static PsiClass doMoveClass(PsiClass aClass, PsiDirectory moveDestination) throws IncorrectOperationException {
        return MoveClassesOrPackagesUtil.doMoveClass(aClass, moveDestination, true);
    }

    public static PsiClass doMoveClass(PsiClass aClass, PsiDirectory moveDestination, boolean moveAllClassesInFile) throws IncorrectOperationException {
        String qualifiedName;
        PsiClass newClass;
        if (!moveAllClassesInFile) {
            for (MoveClassHandler handler : (MoveClassHandler[])MoveClassHandler.EP_NAME.getExtensions()) {
                newClass = handler.doMoveClass(aClass, moveDestination);
                if (newClass == null) continue;
                return newClass;
            }
        }
        PsiFile file = aClass.getContainingFile();
        Project project = moveDestination.getProject();
        VirtualFile dstDir = moveDestination.getVirtualFile();
        String pkgName = PackageIndex.getInstance((Project)project).getPackageNameByDirectory(dstDir);
        PsiPackageImpl newPackage = pkgName == null ? null : new PsiPackageImpl(moveDestination.getManager(), pkgName);
        newClass = aClass;
        PsiDirectory containingDirectory = file.getContainingDirectory();
        if (!Comparing.equal((Object)dstDir, (Object)(containingDirectory != null ? containingDirectory.getVirtualFile() : null))) {
            MoveFilesOrDirectoriesUtil.doMoveFile((PsiFile)file, (PsiDirectory)moveDestination);
            DumbService.getInstance((Project)project).completeJustSubmittedTasks();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = documentManager.getCachedDocument(file);
            if (document != null) {
                documentManager.commitDocument(document);
            }
            file = moveDestination.findFile(file.getName());
        }
        if (newPackage != null && file instanceof PsiClassOwner && !FileTypeUtils.isInServerPageFile((PsiElement)file) && !PsiUtil.isModuleFile((PsiFile)file) && !Comparing.strEqual((String)(qualifiedName = newPackage.getQualifiedName()), (String)((PsiClassOwner)file).getPackageName()) && (qualifiedName.isEmpty() || PsiNameHelper.getInstance((Project)file.getProject()).isQualifiedName(qualifiedName))) {
            String aClassName = aClass.getName();
            if (!(aClass instanceof PsiImplicitClass)) {
                ((PsiClassOwner)file).setPackageName(qualifiedName);
                newClass = MoveClassesOrPackagesUtil.findClassByName((PsiClassOwner)file, aClassName);
            }
            LOG.assertTrue(newClass != null, (Object)("name:" + aClassName + " file:" + String.valueOf(file) + " classes:" + Arrays.toString(((PsiClassOwner)file).getClasses())));
        }
        return newClass;
    }

    @Nullable
    private static PsiClass findClassByName(PsiClassOwner file, String name) {
        PsiClass[] classes;
        for (PsiClass aClass : classes = file.getClasses()) {
            if (!name.equals(aClass.getName())) continue;
            return aClass;
        }
        return null;
    }

    @NotNull
    public static String getPackageName(@NotNull PackageWrapper aPackage) {
        String name;
        if (aPackage == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(10);
        }
        if (!(name = aPackage.getQualifiedName()).isEmpty()) {
            String string = name;
            if (string == null) {
                MoveClassesOrPackagesUtil.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = JavaFindUsagesProvider.getDefaultPackageName();
        if (string == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Deprecated
    @Nullable
    public static VirtualFile chooseSourceRoot(@NotNull PackageWrapper targetPackage, @NotNull List<? extends VirtualFile> contentSourceRoots, @Nullable PsiDirectory initialDirectory) {
        if (targetPackage == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(13);
        }
        if (contentSourceRoots == null) {
            MoveClassesOrPackagesUtil.$$$reportNull$$$0(14);
        }
        return CommonMoveClassesOrPackagesUtil.chooseSourceRoot((PackageWrapper)targetPackage, contentSourceRoots, (PsiDirectory)initialDirectory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesUtil";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveDestination";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPackage";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findNonCodeUsages";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doMovePackage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "chooseSourceRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 11, 12 -> new IllegalStateException(string);
        };
    }
}

