/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.java.JavaBundle;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiPackageRenameValidator
implements RenameInputValidatorEx {
    private final ElementPattern<? extends PsiElement> myPattern = PlatformPatterns.psiElement(PsiPackage.class);

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        ElementPattern<? extends PsiElement> elementPattern = this.myPattern;
        if (elementPattern == null) {
            PsiPackageRenameValidator.$$$reportNull$$$0(0);
        }
        return elementPattern;
    }

    @Nullable
    public String getErrorMessage(@NotNull String newName, @NotNull Project project) {
        if (newName == null) {
            PsiPackageRenameValidator.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PsiPackageRenameValidator.$$$reportNull$$$0(2);
        }
        if (FileTypeManager.getInstance().isFileIgnored(newName)) {
            return JavaBundle.message((String)"rename.package.ignored.name.warning", (Object[])new Object[0]);
        }
        if (!newName.isEmpty() && !PsiDirectoryFactory.getInstance((Project)project).isValidPackageName(newName)) {
            return JavaBundle.message((String)"rename.package.invalid.name.error", (Object[])new Object[0]);
        }
        return null;
    }

    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (newName == null) {
            PsiPackageRenameValidator.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PsiPackageRenameValidator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PsiPackageRenameValidator.$$$reportNull$$$0(5);
        }
        return !newName.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/PsiPackageRenameValidator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/PsiPackageRenameValidator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInputValid";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

