/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/refactoring/rename/naming/AutomaticTestMethodRenamerFactory;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamerFactory;", "<init>", "()V", "isApplicable", "", "element", "Lcom/intellij/psi/PsiElement;", "getOptionName", "", "AutomaticTestMethodRenamer", "intellij.java.impl.refactorings"})
public abstract class AutomaticTestMethodRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile file = element.getContainingFile();
        return !ProjectRootsUtil.isInTestSource((PsiFile)file);
    }

    @NotNull
    public String getOptionName() {
        String string = JavaRefactoringBundle.message((String)"rename.test.method", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0004\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\n\u001a\u00020\u000b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/refactoring/rename/naming/AutomaticTestMethodRenamerFactory$AutomaticTestMethodRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "oldMethodName", "", "className", "module", "Lcom/intellij/openapi/module/Module;", "newMethodName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "findMethodsToReplace", "", "getDialogTitle", "getDialogDescription", "entityName", "intellij.java.impl.refactorings"})
    @SourceDebugExtension(value={"SMAP\nAutomaticTestMethodRenamerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutomaticTestMethodRenamerFactory.kt\ncom/intellij/refactoring/rename/naming/AutomaticTestMethodRenamerFactory$AutomaticTestMethodRenamer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,63:1\n14060#2,2:64\n*S KotlinDebug\n*F\n+ 1 AutomaticTestMethodRenamerFactory.kt\ncom/intellij/refactoring/rename/naming/AutomaticTestMethodRenamerFactory$AutomaticTestMethodRenamer\n*L\n46#1:64,2\n*E\n"})
    protected static final class AutomaticTestMethodRenamer
    extends AutomaticRenamer {
        public AutomaticTestMethodRenamer(@Nullable String oldMethodName, @Nullable String className, @Nullable Module module, @NotNull String newMethodName) {
            Intrinsics.checkNotNullParameter((Object)newMethodName, (String)"newMethodName");
            this.findMethodsToReplace(oldMethodName, className, module);
            this.suggestAllNames(oldMethodName, newMethodName);
        }

        private final void findMethodsToReplace(String oldMethodName, String className, Module module) {
            if (oldMethodName == null || className == null || module == null) {
                return;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithDependentsScope(...)");
            GlobalSearchScope moduleScope = globalSearchScope;
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)module.getProject());
            Pattern classPattern = Pattern.compile(".*" + className + ".*");
            Pattern methodPattern = Pattern.compile(".*" + oldMethodName + ".*", 2);
            int count = 0;
            String[] stringArray = cache.getAllClassNames();
            Iterator iterator = ContainerUtil.newHashSet((Object[])Arrays.copyOf(stringArray, stringArray.length)).iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                String eachName = (String)iterator2.next();
                if (!classPattern.matcher(eachName).matches()) continue;
                if (count++ > 1000) break;
                Intrinsics.checkNotNullExpressionValue((Object)cache.getClassesByName(eachName, moduleScope), (String)"getClassesByName(...)");
                for (String string : stringArray) {
                    Intrinsics.checkNotNull((Object)string);
                    String eachClass = string;
                    if (TestFrameworks.detectFramework((PsiClass)eachClass) == null) continue;
                    PsiMethod[] psiMethodArray = eachClass.getMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
                    Object[] $this$forEach$iv = psiMethodArray;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PsiMethod it = (PsiMethod)element$iv;
                        boolean bl = false;
                        if (!methodPattern.matcher(it.getName()).matches()) continue;
                        this.myElements.add(it);
                    }
                }
            }
        }

        @NotNull
        public String getDialogTitle() {
            String string = JavaRefactoringBundle.message((String)"rename.test.method.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getDialogDescription() {
            String string = JavaRefactoringBundle.message((String)"rename.test.method.description", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String entityName() {
            String string = JavaRefactoringBundle.message((String)"rename.test.method.entity.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }
}

