/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.naming.AutomaticUsageRenamer;
import com.intellij.refactoring.rename.naming.NameSuggester;
import java.util.List;

public abstract class PsiNamedElementAutomaticRenamer<T extends PsiNamedElement>
extends AutomaticUsageRenamer<T> {
    private static final Logger LOG = Logger.getInstance(PsiNamedElementAutomaticRenamer.class);

    protected PsiNamedElementAutomaticRenamer(List<? extends T> elements, String oldName, String newName) {
        super(elements, oldName, newName);
    }

    @Override
    protected String getName(T element) {
        return element.getName();
    }

    @Override
    protected String suggestName(T element) {
        String elementName = this.getName(element);
        NameSuggester suggester = new NameSuggester(this.getOldName(), this.getNewName());
        String newCanonicalName = suggester.suggestName(elementName);
        if (newCanonicalName.isEmpty()) {
            LOG.error("oldName = " + this.getOldName() + ", newName = " + this.getNewName() + ", name = " + elementName + ", canonicalName = " + elementName + ", newCanonicalName = " + newCanonicalName);
        }
        return newCanonicalName;
    }
}

