/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteDelegate;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteExtendsClassUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteOverrideAnnotation;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeletePermitsClassUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeletePrivatizeMethod;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class JavaSafeDeleteDelegateImpl
implements JavaSafeDeleteDelegate {
    public void createUsageInfoForParameter(@NotNull PsiReference reference, @NotNull List<? super UsageInfo> usages, @NotNull PsiNamedElement parameter, final int paramIdx, boolean isVararg) {
        if (reference == null) {
            JavaSafeDeleteDelegateImpl.$$$reportNull$$$0(0);
        }
        if (usages == null) {
            JavaSafeDeleteDelegateImpl.$$$reportNull$$$0(1);
        }
        if (parameter == null) {
            JavaSafeDeleteDelegateImpl.$$$reportNull$$$0(2);
        }
        final PsiElement element = reference.getElement();
        PsiCall call = null;
        if (element instanceof PsiCall) {
            call = (PsiCall)element;
        } else {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiCall) {
                call = (PsiCall)parent;
            } else if (parent instanceof PsiAnonymousClass) {
                call = (PsiNewExpression)parent.getParent();
            }
        }
        if (call != null) {
            PsiExpression[] args;
            PsiExpressionList argList = call.getArgumentList();
            if (argList != null && paramIdx < (args = argList.getExpressions()).length) {
                if (!isVararg) {
                    usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(args[paramIdx], (PsiElement)parameter));
                } else {
                    for (int i = paramIdx; i < args.length; ++i) {
                        usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(args[i], (PsiElement)parameter));
                    }
                }
            }
        } else if (element instanceof PsiDocMethodOrFieldRef) {
            PsiDocMethodOrFieldRef ref = (PsiDocMethodOrFieldRef)element;
            String[] signature = ref.getSignature();
            PsiElement nameElement = ref.getNameElement();
            if (signature != null && nameElement != null) {
                final @NonNls StringBuffer newText = new StringBuffer();
                newText.append("/** @see #").append(nameElement.getText()).append('(');
                boolean hasParams = false;
                for (int i = 0; i < signature.length; ++i) {
                    if (i == paramIdx) continue;
                    if (hasParams) {
                        newText.append(",");
                    } else {
                        hasParams = true;
                    }
                    newText.append(signature[i]);
                }
                newText.append(")*/");
                usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(this, element, (PsiElement)parameter, true){

                    @Override
                    public void deleteElement() throws IncorrectOperationException {
                        PsiDocMethodOrFieldRef.MyReference javadocMethodReference = (PsiDocMethodOrFieldRef.MyReference)element.getReference();
                        if (javadocMethodReference != null) {
                            javadocMethodReference.bindToText(newText);
                        }
                    }
                });
            }
        } else if (element instanceof PsiMethodReferenceExpression) {
            usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(this, element, (PsiElement)parameter, true){

                @Override
                public void deleteElement() throws IncorrectOperationException {
                    PsiExpression[] args;
                    PsiExpressionList expressionList;
                    PsiExpression callExpression = LambdaRefactoringUtil.convertToMethodCallInLambdaBody((PsiMethodReferenceExpression)((PsiMethodReferenceExpression)element));
                    if (callExpression instanceof PsiCallExpression && (expressionList = ((PsiCallExpression)callExpression).getArgumentList()) != null && paramIdx < (args = expressionList.getExpressions()).length) {
                        args[paramIdx].delete();
                    }
                }
            });
        }
    }

    public void createJavaTypeParameterUsageInfo(@NotNull PsiReference reference, @NotNull List<? super UsageInfo> usages, @NotNull PsiElement typeParameter, int paramsCount, int index) {
        PsiTypeElement[] typeArgs;
        PsiReferenceParameterList parameterList;
        if (reference == null) {
            JavaSafeDeleteDelegateImpl.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            JavaSafeDeleteDelegateImpl.$$$reportNull$$$0(4);
        }
        if (typeParameter == null) {
            JavaSafeDeleteDelegateImpl.$$$reportNull$$$0(5);
        }
        if (reference instanceof PsiJavaCodeReferenceElement && (parameterList = ((PsiJavaCodeReferenceElement)reference).getParameterList()) != null && (typeArgs = parameterList.getTypeParameterElements()).length > index) {
            if (typeArgs.length == 1 && paramsCount > 1 && typeArgs[0].getType() instanceof PsiDiamondType) {
                return;
            }
            usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)typeArgs[index], typeParameter, true));
        }
    }

    public void createCleanupOverriding(@NotNull PsiElement overriddenFunction, PsiElement @NotNull [] elements2Delete, @NotNull List<? super UsageInfo> result) {
        if (overriddenFunction == null) {
            JavaSafeDeleteDelegateImpl.$$$reportNull$$$0(6);
        }
        if (result == null) {
            JavaSafeDeleteDelegateImpl.$$$reportNull$$$0(7);
        }
        if (elements2Delete == null) {
            JavaSafeDeleteDelegateImpl.$$$reportNull$$$0(8);
        }
        if (overriddenFunction instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)overriddenFunction;
            if (JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)method) != null || method.findSuperMethods().length > 1) {
                return;
            }
            if (JavaSafeDeleteProcessor.canBePrivate(method, elements2Delete)) {
                result.add((UsageInfo)new SafeDeletePrivatizeMethod(method, method));
                return;
            }
        }
        result.add((UsageInfo)new SafeDeleteOverrideAnnotation(overriddenFunction, overriddenFunction));
    }

    public UsageInfo createExtendsListUsageInfo(PsiElement refElement, PsiReference reference) {
        PsiElement element = reference.getElement();
        PsiElement parent = element.getParent();
        if (parent instanceof PsiReferenceList && refElement instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)refElement;
            PsiElement pparent = parent.getParent();
            if (pparent instanceof PsiClass) {
                PsiClass inheritor = (PsiClass)pparent;
                if (element instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement classRef = (PsiJavaCodeReferenceElement)element;
                    if (parent.equals((Object)inheritor.getPermitsList())) {
                        return new SafeDeletePermitsClassUsageInfo(classRef, psiClass, inheritor, true);
                    }
                    CachedValueProvider provider = () -> new CachedValueProvider.Result((Object)JavaSafeDeleteDelegateImpl.containsOnlyPrivates(psiClass), new Object[]{PsiModificationTracker.getInstance((Project)psiClass.getProject())});
                    if (((Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, (CachedValueProvider)provider)).booleanValue() && (parent.equals((Object)inheritor.getExtendsList()) || parent.equals((Object)inheritor.getImplementsList()))) {
                        return new SafeDeleteExtendsClassUsageInfo(classRef, psiClass, inheritor);
                    }
                }
            }
        }
        return null;
    }

    private static boolean containsOnlyPrivates(PsiClass aClass) {
        for (PsiField psiField : aClass.getFields()) {
            if (psiField.hasModifierProperty("private")) continue;
            return false;
        }
        for (PsiField psiField : aClass.getMethods()) {
            PsiExpression expression;
            PsiStatement[] statements;
            PsiCodeBlock body;
            if (psiField.hasModifierProperty("private") || psiField.isConstructor() && (body = psiField.getBody()) != null && ((statements = body.getStatements()).length == 0 || statements.length == 1 && statements[0] instanceof PsiExpressionStatement && JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)(expression = ((PsiExpressionStatement)statements[0]).getExpression())))) continue;
            return false;
        }
        for (PsiField psiField : aClass.getInnerClasses()) {
            if (psiField.hasModifierProperty("private")) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overriddenFunction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements2Delete";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/safeDelete/JavaSafeDeleteDelegateImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createUsageInfoForParameter";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createJavaTypeParameterUsageInfo";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createCleanupOverriding";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

