/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationReplacementUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.TypeMigrationViewDescriptor;
import com.intellij.refactoring.typeMigration.ui.FailedConversionsDialog;
import com.intellij.refactoring.typeMigration.ui.MigrationPanel;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TypeMigrationProcessor
extends BaseRefactoringProcessor {
    public static volatile boolean ourSkipFailedConversionInTestMode;
    private static final int MAX_ROOT_IN_PREVIEW_PRESENTATION = 3;
    private PsiElement[] myRoots;
    private final Function<? super PsiElement, ? extends PsiType> myRootTypes;
    private final boolean myAllowDependentRoots;
    private final TypeMigrationRules myRules;
    private TypeMigrationLabeler myLabeler;

    public TypeMigrationProcessor(Project project, PsiElement[] roots, Function<? super PsiElement, ? extends PsiType> rootTypes, TypeMigrationRules rules, boolean allowDependentRoots) {
        super(project);
        this.myRoots = roots;
        this.myRules = rules;
        this.myRootTypes = rootTypes;
        this.myAllowDependentRoots = allowDependentRoots;
    }

    public static void runHighlightingTypeMigration(Project project, Editor editor, TypeMigrationRules rules, PsiElement root, PsiType migrationType) {
        TypeMigrationProcessor.runHighlightingTypeMigration(project, editor, rules, root, migrationType, false, true);
    }

    public static void runHighlightingTypeMigration(Project project, Editor editor, TypeMigrationRules rules, PsiElement root, PsiType migrationType, boolean optimizeImports, boolean allowDependentRoots) {
        TypeMigrationProcessor.runHighlightingTypeMigration(project, editor, rules, new PsiElement[]{root}, (Function<? super PsiElement, ? extends PsiType>)Functions.constant((Object)migrationType), optimizeImports, allowDependentRoots);
    }

    public static void runHighlightingTypeMigration(final Project project, final Editor editor, TypeMigrationRules rules, PsiElement[] roots, Function<? super PsiElement, ? extends PsiType> migrationTypeFunction, final boolean optimizeImports, boolean allowDependentRoots) {
        final Set containingFiles = ContainerUtil.map2Set((Object[])roots, PsiElement::getContainingFile);
        TypeMigrationProcessor processor = new TypeMigrationProcessor(project, roots, migrationTypeFunction, rules, allowDependentRoots){

            @Override
            public void performRefactoring(UsageInfo @NotNull [] usages) {
                if (usages == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.performRefactoring(usages);
                if (editor != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ArrayList<Object> result = new ArrayList<Object>();
                        for (UsageInfo usage : usages) {
                            PsiElement element = usage.getElement();
                            if (element == null || !containingFiles.contains(element.getContainingFile())) continue;
                            if (element instanceof PsiMethod) {
                                result.add(((PsiMethod)element).getReturnTypeElement());
                                continue;
                            }
                            if (element instanceof PsiVariable) {
                                result.add(((PsiVariable)element).getTypeElement());
                                continue;
                            }
                            result.add(element);
                        }
                        RefactoringUtil.highlightAllOccurrences(project, PsiUtilCore.toPsiElementArray(result), editor);
                    });
                }
                if (optimizeImports) {
                    JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
                    HashSet<PsiFile> affectedFiles = new HashSet<PsiFile>();
                    for (UsageInfo usage : usages) {
                        PsiFile usageFile = usage.getFile();
                        if (usageFile == null) continue;
                        affectedFiles.add(usageFile);
                    }
                    for (PsiFile file : affectedFiles) {
                        javaCodeStyleManager.optimizeImports(file);
                        javaCodeStyleManager.shortenClassReferences((PsiElement)file);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/typeMigration/TypeMigrationProcessor$1", "performRefactoring"));
            }
        };
        processor.run();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            TypeMigrationProcessor.$$$reportNull$$$0(0);
        }
        return new TypeMigrationViewDescriptor(this.myRoots[0]);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            TypeMigrationProcessor.$$$reportNull$$$0(1);
        }
        if (this.hasFailedConversions()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                if (ourSkipFailedConversionInTestMode) {
                    this.prepareSuccessful();
                    return true;
                }
                throw new BaseRefactoringProcessor.ConflictsInTestsException(Arrays.asList(this.myLabeler.getFailedConversionsReport()));
            }
            FailedConversionsDialog dialog = new FailedConversionsDialog(this.myLabeler.getFailedConversionsReport(), this.myProject);
            if (!dialog.showAndGet()) {
                int exitCode = dialog.getExitCode();
                if (exitCode == 2) {
                    this.prepareSuccessful();
                    this.previewRefactoring((UsageInfo[])refUsages.get());
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    public boolean hasFailedConversions() {
        return this.myLabeler.hasFailedConversions();
    }

    protected void previewRefactoring(UsageInfo @NotNull [] usages) {
        Object name;
        if (usages == null) {
            TypeMigrationProcessor.$$$reportNull$$$0(2);
        }
        MigrationPanel panel = new MigrationPanel(this.myRoots, this.myLabeler, this.myProject, this.isPreviewUsages());
        if (this.myRoots.length == 1) {
            String fromType = Objects.requireNonNull(TypeMigrationLabeler.getElementType(this.myRoots[0])).getPresentableText();
            String toType = ((PsiType)this.myRootTypes.fun((Object)this.myRoots[0])).getPresentableText();
            String text = TypeMigrationProcessor.getPresentation(this.myRoots[0]);
            name = JavaBundle.message((String)"type.migration.single.root.toolwindow.title", (Object[])new Object[]{text, fromType, toType});
        } else {
            int rootsInPresentationCount = Math.min(this.myRoots.length, 3);
            String[] rootsPresentation = new String[rootsInPresentationCount];
            for (int i = 0; i < rootsInPresentationCount; ++i) {
                PsiElement root = this.myRoots[i];
                rootsPresentation[i] = root instanceof PsiNamedElement ? ((PsiNamedElement)root).getName() : root.getText();
            }
            rootsPresentation = StringUtil.surround((String[])rootsPresentation, (String)"'", (String)"'");
            name = JavaBundle.message((String)"type.migration.multi.root.toolwindow.title", (Object[])new Object[]{StringUtil.join((String[])rootsPresentation, (String)", ")});
            if (this.myRoots.length > 3) {
                name = (String)name + "...";
            }
        }
        Content content = UsageViewContentManager.getInstance((Project)this.myProject).addContent(XmlStringUtil.wrapInHtml((CharSequence)name), false, (JComponent)panel, true, true);
        panel.setContent(content);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Find").activate(null);
    }

    public static String getPresentation(PsiElement element) {
        return RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false);
    }

    public UsageInfo @NotNull [] findUsages() {
        this.myLabeler = new TypeMigrationLabeler(this.myRules, this.myRootTypes, this.myAllowDependentRoots ? null : this.myRoots, this.myProject);
        UsageInfo[] usageInfoArray = this.myLabeler.getMigratedUsages(!this.isPreviewUsages(), this.myRoots);
        if (usageInfoArray == null) {
            TypeMigrationProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            TypeMigrationProcessor.$$$reportNull$$$0(4);
        }
        this.myRoots = elements;
    }

    public void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            TypeMigrationProcessor.$$$reportNull$$$0(5);
        }
        TypeMigrationProcessor.change(usages, this.myLabeler, this.myProject);
    }

    public static void change(UsageInfo[] usages, TypeMigrationLabeler labeler, Project project) {
        SmartList newExpressionsToCheckDiamonds = new SmartList();
        TypeMigrationLabeler.MigrationProducer producer = labeler.createMigratorFor(usages);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        ArrayList<UsageInfo> nonCodeUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (((TypeMigrationUsageInfo)usage).isExcluded()) continue;
            PsiElement element = usage.getElement();
            if (element instanceof PsiVariable || element instanceof PsiMember || element instanceof PsiExpression || element instanceof PsiReferenceParameterList) {
                producer.change((TypeMigrationUsageInfo)usage, (Consumer<? super PsiNewExpression>)((Consumer)arg_0 -> TypeMigrationProcessor.lambda$change$0((List)newExpressionsToCheckDiamonds, smartPointerManager, arg_0)));
                continue;
            }
            nonCodeUsages.add(usage);
        }
        for (SmartPsiElementPointer newExpressionPointer : newExpressionsToCheckDiamonds) {
            PsiNewExpression newExpression = (PsiNewExpression)newExpressionPointer.getElement();
            if (newExpression == null) continue;
            TypeMigrationReplacementUtil.tryToReplaceWithDiamond(newExpression, null);
        }
        for (UsageInfo usageInfo : nonCodeUsages) {
            Object target;
            PsiReference reference;
            PsiElement element = usageInfo.getElement();
            if (element == null || (reference = element.getReference()) == null || !((target = producer.getConversion(usageInfo)) instanceof PsiMember)) continue;
            try {
                reference.bindToElement((PsiElement)target);
            }
            catch (IncorrectOperationException incorrectOperationException) {}
        }
        producer.flush();
    }

    public TypeMigrationLabeler getLabeler() {
        return this.myLabeler;
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaBundle.message((String)"type.migration.command.name", (Object[])new Object[0]);
        if (string == null) {
            TypeMigrationProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void lambda$change$0(List newExpressionsToCheckDiamonds, SmartPointerManager smartPointerManager, PsiNewExpression expression) {
        newExpressionsToCheckDiamonds.add(smartPointerManager.createSmartPsiElementPointer((PsiElement)expression));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/TypeMigrationProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/TypeMigrationProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "previewRefactoring";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }
}

