/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.ui;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FailedConversionsDialog
extends DialogWrapper {
    @Nls
    private final String[] myConflictDescriptions;
    public static final int VIEW_USAGES_EXIT_CODE = 2;

    public FailedConversionsDialog(@Nls String[] conflictDescriptions, Project project) {
        super(project, true);
        this.myConflictDescriptions = conflictDescriptions;
        this.setTitle(RefactoringBundle.message((String)"problems.detected.title"));
        this.setOKButtonText(JavaRefactoringBundle.message((String)"ignore.button", (Object[])new Object[0]));
        this.getOKAction().putValue("MnemonicKey", 73);
        this.init();
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), new ViewUsagesAction(), new CancelAction()};
        if (actionArray == null) {
            FailedConversionsDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        JEditorPane messagePane = new JEditorPane("text/html", "");
        messagePane.setEditorKit(HTMLEditorKitBuilder.simple());
        messagePane.setEditable(false);
        messagePane.setMargin((Insets)JBUI.insets((int)5));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)messagePane);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)500, (int)400));
        JPanel panel = UI.PanelFactory.panel((JComponent)scrollPane).withLabel(RefactoringBundle.message((String)"the.following.problems.were.found")).moveLabelOnTop().resizeY(true).createPanel();
        HtmlBuilder builder = new HtmlBuilder();
        for (String conflictDescription : this.myConflictDescriptions) {
            builder.appendRaw(conflictDescription).br().br();
        }
        String text = builder.wrapWithHtmlBody().toString();
        messagePane.setText(text);
        return panel;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.typeMigration.ui.FailedConversionsDialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/ui/FailedConversionsDialog", "createActions"));
    }

    private class ViewUsagesAction
    extends AbstractAction {
        ViewUsagesAction() {
            super(RefactoringBundle.message((String)"view.usages"));
            this.putValue("MnemonicKey", 86);
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FailedConversionsDialog.this.close(2);
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            super(RefactoringBundle.message((String)"cancel.button"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FailedConversionsDialog.this.doCancelAction();
        }
    }
}

