/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.ui;

import com.intellij.CommonBundle;
import com.intellij.find.FindUsagesSettings;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.java.JavaBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.ui.EditorComboBox;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeMigrationDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance(TypeMigrationDialog.class);
    protected final PsiElement[] myRoots;
    private TypeMigrationRules myRules;
    private final ScopeChooserCombo myScopeChooserCombo;

    public TypeMigrationDialog(@NotNull Project project, PsiElement @NotNull [] roots, @Nullable TypeMigrationRules rules) {
        if (project == null) {
            TypeMigrationDialog.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            TypeMigrationDialog.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.myRoots = roots;
        this.myRules = rules;
        this.myScopeChooserCombo = new ScopeChooserCombo(project, false, true, FindUsagesSettings.getInstance().getDefaultScopeName());
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeChooserCombo);
        ((JComboBox)this.myScopeChooserCombo.getChildComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeMigrationDialog.this.validateButtons();
            }
        });
        this.setTitle(JavaRefactoringBundle.message((String)"type.migration.action.name", (Object[])new Object[0]));
    }

    protected void doAction() {
        if (this.myScopeChooserCombo.getSelectedScope() == null) {
            Messages.showErrorDialog((String)JavaRefactoringBundle.message((String)"type.migration.no.scope.warning.message", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        FindUsagesSettings.getInstance().setDefaultScopeName(this.myScopeChooserCombo.getSelectedScopeName());
        if (this.myRules == null) {
            this.myRules = new TypeMigrationRules(this.getProject());
            this.myRules.setBoundScope(this.myScopeChooserCombo.getSelectedScope());
        }
        this.invokeRefactoring(new TypeMigrationProcessor(this.myProject, this.myRoots, this.getMigrationTypeFunction(), this.myRules, true));
    }

    @NotNull
    protected abstract Function<? super PsiElement, ? extends PsiType> getMigrationTypeFunction();

    protected void appendMigrationTypeEditor(JPanel panel, GridBagConstraints cs) {
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0);
        this.appendMigrationTypeEditor(panel, gc);
        LabeledComponent scopeChooserComponent = new LabeledComponent();
        scopeChooserComponent.setComponent((JComponent)this.myScopeChooserCombo);
        scopeChooserComponent.setText(JavaRefactoringBundle.message((String)"type.migration.choose.scope.title", (Object[])new Object[0]));
        panel.add((Component)scopeChooserComponent, gc);
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myScopeChooserCombo;
    }

    protected String getHelpId() {
        return "reference.typeMigrationDialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "roots";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/typeMigration/ui/TypeMigrationDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SingleElement
    extends TypeMigrationDialog {
        private final PsiTypeCodeFragment myTypeCodeFragment;
        private final EditorComboBox myToTypeEditor;

        public SingleElement(@NotNull Project project, PsiElement @NotNull [] roots) {
            String[] stringArray;
            if (project == null) {
                SingleElement.$$$reportNull$$$0(0);
            }
            if (roots == null) {
                SingleElement.$$$reportNull$$$0(1);
            }
            super(project, roots, null);
            LOG.assertTrue(roots.length > 0);
            PsiType rootType = this.getRootType();
            String text = rootType != null ? rootType.getCanonicalText(true) : "";
            int flags = 0;
            PsiElement root = roots[0];
            if (PsiUtil.isAvailable((JavaFeature)JavaFeature.VARARGS, (PsiElement)root)) {
                flags |= 2;
            }
            if (PsiUtil.isAvailable((JavaFeature)JavaFeature.MULTI_CATCH, (PsiElement)root)) {
                flags |= 4;
            }
            this.myTypeCodeFragment = JavaCodeFragmentFactory.getInstance((Project)project).createTypeCodeFragment(text, root, true, flags |= 1);
            final PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            final Document document = documentManager.getDocument((PsiFile)this.myTypeCodeFragment);
            assert (document != null);
            this.myToTypeEditor = new EditorComboBox(document, project, (FileType)JavaFileType.INSTANCE);
            String[] types = this.getValidTypes(project, root);
            if (types != null) {
                stringArray = types;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = document.getText();
            }
            this.myToTypeEditor.setHistory(stringArray);
            document.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    documentManager.commitDocument(document);
                    this.validateButtons();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/typeMigration/ui/TypeMigrationDialog$SingleElement$1", "documentChanged"));
                }
            });
            this.init();
            this.validateButtons();
        }

        protected void canRun() throws ConfigurationException {
            super.canRun();
            if (this.isIllegalVarargMigration()) {
                throw new ConfigurationException(JavaBundle.message((String)"type.migration.dialog.message.vararg.type.not.applicable", (Object[])new Object[0]));
            }
            if (this.isIllegalDisjunctionTypeMigration()) {
                throw new ConfigurationException(JavaBundle.message((String)"type.migration.dialog.message.disjunction.type.not.applicable", (Object[])new Object[0]));
            }
            if (this.isIllegalTypeMigration(this.getMigrationType())) {
                throw new ConfigurationException(JavaBundle.message((String)"type.migration.dialog.message.invalid.type", (Object[])new Object[]{StringUtil.escapeXmlEntities((String)this.myTypeCodeFragment.getText())}));
            }
            if (this.isIllegalVoidMigration()) {
                throw new ConfigurationException(JavaBundle.message((String)"type.migration.dialog.message.void.not.applicable", (Object[])new Object[0]));
            }
            if (this.getMigrationType().equals(this.getRootType())) {
                throw new ConfigurationException(null);
            }
        }

        @Override
        public JComponent getPreferredFocusedComponent() {
            return this.myToTypeEditor;
        }

        @Override
        protected void appendMigrationTypeEditor(JPanel panel, GridBagConstraints gc) {
            PsiType type = this.getRootType();
            String typeText = type != null ? type.getPresentableText() : "<unknown>";
            panel.add((Component)new JLabel(SingleElement.getTypeMigrationLabelText(this.myRoots[0], typeText)), gc);
            panel.add((Component)this.myToTypeEditor, gc);
        }

        private String @Nullable [] getValidTypes(Project project, PsiElement root) {
            PsiModifierList modifierList;
            if ((root instanceof PsiField || root instanceof PsiMethod) && VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)(modifierList = ((PsiModifierListOwner)root).getModifierList())), (String)"private") < 0) {
                return null;
            }
            ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)root, (SearchScope)GlobalSearchScope.fileScope((PsiFile)root.getContainingFile())).asIterable()) {
                PsiElement element = reference.getElement();
                PsiExpression expr = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class, (boolean)false);
                if (expr == null) continue;
                expressions.add(expr);
            }
            try {
                PsiExpression[] occurrences = expressions.toArray(PsiExpression.EMPTY_ARRAY);
                PsiType type = this.myTypeCodeFragment.getType();
                Object[] psiTypes = new TypeSelectorManagerImpl(project, type, occurrences).getTypesForAll();
                if (root instanceof PsiMethod) {
                    psiTypes = (PsiType[])ArrayUtil.append((Object[])psiTypes, (Object)PsiTypes.voidType());
                }
                if (type instanceof PsiDisjunctionType) {
                    psiTypes = (PsiType[])ArrayUtil.prepend((Object)type, (Object[])psiTypes);
                }
                if (psiTypes.length > 0) {
                    String[] history = new String[psiTypes.length];
                    for (int i = 0; i < psiTypes.length; ++i) {
                        Object psiType = psiTypes[i];
                        history[i] = psiType.getCanonicalText(true);
                    }
                    return history;
                }
            }
            catch (PsiTypeCodeFragment.NoTypeException | PsiTypeCodeFragment.TypeSyntaxException e) {
                LOG.info(e);
                return null;
            }
            return null;
        }

        @Override
        protected void doAction() {
            PsiType rootType = this.getRootType();
            PsiType migrationType = this.getMigrationType();
            if (migrationType == null || CommonJavaRefactoringUtil.deepTypeEqual((PsiType)rootType, (PsiType)migrationType)) {
                this.close(0);
                return;
            }
            super.doAction();
        }

        @Override
        @NotNull
        protected Function<? super PsiElement, ? extends PsiType> getMigrationTypeFunction() {
            Function function = Functions.constant((Object)this.getMigrationType());
            if (function == null) {
                SingleElement.$$$reportNull$$$0(2);
            }
            return function;
        }

        @Nullable
        public PsiType getMigrationType() {
            try {
                return this.myTypeCodeFragment.getType();
            }
            catch (PsiTypeCodeFragment.NoTypeException | PsiTypeCodeFragment.TypeSyntaxException e) {
                LOG.debug(e);
                return null;
            }
        }

        @Nullable
        private PsiType getRootType() {
            return TypeMigrationLabeler.getElementType(this.myRoots[0]);
        }

        @NlsContexts.Label
        private static String getTypeMigrationLabelText(PsiElement element, String type) {
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                String methodText = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
                return JavaRefactoringBundle.message((String)"type.migration.return.type.of.method.label", (Object[])new Object[]{type, methodText});
            }
            if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                String variableText = PsiFormatUtil.formatVariable((PsiVariable)field, (int)1, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                return JavaRefactoringBundle.message((String)"type.migration.type.of.field.label", (Object[])new Object[]{type, variableText});
            }
            if (element instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)element;
                String variableText = PsiFormatUtil.formatVariable((PsiVariable)variable, (int)1, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                return JavaRefactoringBundle.message((String)"type.migration.type.of.variable.label", (Object[])new Object[]{type, variableText});
            }
            if (element instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)element;
                PsiElement scope = parameter.getDeclarationScope();
                boolean realParameter = scope instanceof PsiMethod || scope instanceof PsiLambdaExpression;
                String variableText = PsiFormatUtil.formatVariable((PsiVariable)parameter, (int)1, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                return JavaRefactoringBundle.message((String)(realParameter ? "type.migration.type.of.parameter.label" : "type.migration.type.of.variable.label"), (Object[])new Object[]{type, variableText});
            }
            if (element instanceof PsiReferenceParameterList) {
                return JavaRefactoringBundle.message((String)"type.migration.class.type.argument.label", (Object[])new Object[]{type});
            }
            if (element instanceof PsiRecordComponent) {
                PsiRecordComponent component = (PsiRecordComponent)element;
                String variableText = PsiFormatUtil.formatVariable((PsiVariable)component, (int)1, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                return JavaRefactoringBundle.message((String)"type.migration.type.of.record.component.label", (Object[])new Object[]{type, variableText});
            }
            throw new AssertionError((Object)("unknown element: " + String.valueOf(element)));
        }

        private boolean isIllegalVarargMigration() {
            if (!(this.getMigrationType() instanceof PsiEllipsisType)) {
                return false;
            }
            for (PsiElement root : this.myRoots) {
                if (!(root instanceof PsiParameter)) {
                    return true;
                }
                PsiParameter parameter = (PsiParameter)root;
                PsiElement scope = parameter.getDeclarationScope();
                if (!(scope instanceof PsiMethod)) {
                    return true;
                }
                PsiMethod method = (PsiMethod)scope;
                PsiParameterList parameterList = method.getParameterList();
                PsiParameter lastParameter = parameterList.getParameter(parameterList.getParametersCount() - 1);
                if (parameter.equals((Object)lastParameter)) continue;
                return true;
            }
            return false;
        }

        private boolean isIllegalDisjunctionTypeMigration() {
            if (!(this.getMigrationType() instanceof PsiDisjunctionType)) {
                return false;
            }
            for (PsiElement root : this.myRoots) {
                if (!(root instanceof PsiParameter)) {
                    return true;
                }
                PsiParameter parameter = (PsiParameter)root;
                PsiElement scope = parameter.getDeclarationScope();
                if (scope instanceof PsiCatchSection) continue;
                return true;
            }
            return false;
        }

        private boolean isIllegalVoidMigration() {
            if (!PsiTypes.voidType().equals((Object)this.getMigrationType())) {
                return false;
            }
            for (PsiElement root : this.myRoots) {
                if (root instanceof PsiMethod) continue;
                return true;
            }
            return false;
        }

        private boolean isIllegalTypeMigration(PsiType type) {
            if (type == null) {
                return true;
            }
            if (!type.isValid()) {
                return true;
            }
            if (type instanceof PsiClassType) {
                PsiType[] types;
                PsiClassType psiClassType = (PsiClassType)type;
                if (psiClassType.resolve() == null) {
                    return true;
                }
                for (PsiType paramType : types = psiClassType.getParameters()) {
                    if (paramType instanceof PsiPrimitiveType || paramType instanceof PsiWildcardType && ((PsiWildcardType)paramType).getBound() instanceof PsiPrimitiveType) {
                        return true;
                    }
                    if (!this.isIllegalTypeMigration(paramType)) continue;
                    return true;
                }
            }
            if (type instanceof PsiArrayType) {
                PsiType componentType = type.getDeepComponentType();
                if (PsiTypes.voidType().equals((Object)componentType)) {
                    return true;
                }
                return this.isIllegalTypeMigration(componentType);
            }
            if (type instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myRoots[0].getProject());
                PsiClassType throwable = factory.createTypeByFQClassName("java.lang.Throwable", this.myRoots[0].getResolveScope());
                List disjunctions = disjunctionType.getDisjunctions();
                for (PsiType disjunction : disjunctions) {
                    if (this.isIllegalTypeMigration(disjunction)) {
                        return true;
                    }
                    if (TypeConversionUtil.isAssignable((PsiType)throwable, (PsiType)type)) continue;
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/typeMigration/ui/TypeMigrationDialog$SingleElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/typeMigration/ui/TypeMigrationDialog$SingleElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMigrationTypeFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class MultipleElements
    extends TypeMigrationDialog {
        private final Function<? super PsiElement, ? extends PsiType> myMigrationTypeFunction;

        public MultipleElements(@NotNull Project project, PsiElement @NotNull [] roots, @NotNull Function<? super PsiElement, ? extends PsiType> migrationTypeFunction, @NotNull TypeMigrationRules rules) {
            if (project == null) {
                MultipleElements.$$$reportNull$$$0(0);
            }
            if (migrationTypeFunction == null) {
                MultipleElements.$$$reportNull$$$0(1);
            }
            if (rules == null) {
                MultipleElements.$$$reportNull$$$0(2);
            }
            if (roots == null) {
                MultipleElements.$$$reportNull$$$0(3);
            }
            super(project, roots, rules);
            this.myMigrationTypeFunction = migrationTypeFunction;
            this.init();
        }

        @Override
        @NotNull
        protected Function<? super PsiElement, ? extends PsiType> getMigrationTypeFunction() {
            Function<? super PsiElement, ? extends PsiType> function = this.myMigrationTypeFunction;
            if (function == null) {
                MultipleElements.$$$reportNull$$$0(4);
            }
            return function;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migrationTypeFunction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rules";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/typeMigration/ui/TypeMigrationDialog$MultipleElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/typeMigration/ui/TypeMigrationDialog$MultipleElements";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMigrationTypeFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

