/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.occurrences;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.occurrences.OccurrenceFilter;
import com.intellij.util.JavaPsiConstructorUtil;
import org.jetbrains.annotations.NotNull;

public class NotInConstructorCallFilter
implements OccurrenceFilter {
    public static final NotInConstructorCallFilter INSTANCE = new NotInConstructorCallFilter();

    @Override
    public boolean isOK(@NotNull PsiExpression occurrence) {
        PsiMethod method;
        if (occurrence == null) {
            NotInConstructorCallFilter.$$$reportNull$$$0(0);
        }
        if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)occurrence, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class})) == null || !method.isConstructor()) {
            return true;
        }
        PsiMethodCallExpression constructorCall = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
        return constructorCall == null || occurrence.getTextOffset() >= constructorCall.getTextOffset() + constructorCall.getTextLength();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrence", "com/intellij/refactoring/util/occurrences/NotInConstructorCallFilter", "isOK"));
    }
}

