/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CastCanBeReplacedWithVariableInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitTypeCastExpression(@NotNull PsiTypeCastExpression typeCastExpression) {
                PsiMethod method;
                if (typeCastExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)typeCastExpression, PsiMethod.class)) == null) {
                    return;
                }
                PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)typeCastExpression.getOperand());
                if (!(operand instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression operandReference = (PsiReferenceExpression)operand;
                PsiElement resolved = operandReference.resolve();
                if (!(resolved instanceof PsiParameter) && !(resolved instanceof PsiLocalVariable)) {
                    return;
                }
                PsiVariable replacement = CastCanBeReplacedWithVariableInspection.findReplacement(method, (PsiVariable)resolved, typeCastExpression);
                if (replacement == null) {
                    return;
                }
                String variableName = replacement.getName();
                String castExpressionText = typeCastExpression.getText();
                ReplaceCastWithVariableFix fix = new ReplaceCastWithVariableFix(castExpressionText, replacement);
                holder.registerProblem((PsiElement)typeCastExpression, InspectionGadgetsBundle.message((String)"inspection.cast.can.be.replaced.with.variable.message", (Object[])new Object[]{variableName, castExpressionText}), new LocalQuickFix[]{fix});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCastExpression", "com/intellij/codeInspection/CastCanBeReplacedWithVariableInspection$1", "visitTypeCastExpression"));
            }
        };
    }

    @Nullable
    private static PsiVariable findReplacement(@NotNull PsiMethod method, @NotNull PsiVariable castedVar, @NotNull PsiTypeCastExpression expression) {
        PsiVariable narrowVariable;
        PsiExpression narrowExpression;
        PsiResolveHelper resolveHelper;
        TextRange expressionTextRange;
        PsiCodeBlock methodBody;
        block18: {
            block17: {
                PsiReferenceExpression narrowReferenceExpression;
                PsiElement psiElement;
                PsiReferenceExpression wideReferenceExpression;
                PsiElement declaration;
                PsiPrimaryPattern pattern;
                Object patternVariable;
                if (method == null) {
                    CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(1);
                }
                if (castedVar == null) {
                    CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(2);
                }
                if (expression == null) {
                    CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(3);
                }
                if (InstanceOfUtils.isUncheckedCast((PsiTypeCastExpression)expression)) {
                    return null;
                }
                PsiTypeElement expressionCastType = expression.getCastType();
                if (expressionCastType == null) {
                    return null;
                }
                methodBody = method.getBody();
                if (methodBody == null) {
                    return null;
                }
                expressionTextRange = expression.getTextRange();
                if (expressionTextRange == null) {
                    return null;
                }
                PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getOperand());
                if (operand == null) {
                    return null;
                }
                PsiType castType = expressionCastType.getType();
                List found = SyntaxTraverser.psiTraverser((PsiElement)method).filter(PsiTypeCastExpression.class).filter(cast -> EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(cast.getOperand(), operand)).filter(cast -> {
                    PsiTypeElement typeElement = cast.getCastType();
                    return typeElement != null && InstanceOfUtils.typeCompatible((PsiType)typeElement.getType(), (PsiType)castType, (PsiExpression)operand);
                }).toList();
                resolveHelper = PsiResolveHelper.getInstance((Project)method.getProject());
                for (PsiTypeCastExpression occurrence : found) {
                    PsiLocalVariable variable;
                    if (!CastCanBeReplacedWithVariableInspection.isAtRightLocation(expression, expressionTextRange, (PsiExpression)occurrence) || (variable = CastCanBeReplacedWithVariableInspection.getVariable(occurrence)) == null || resolveHelper.resolveReferencedVariable(variable.getName(), (PsiElement)expression) != variable || CastCanBeReplacedWithVariableInspection.isChangedBetween(castedVar, (PsiElement)methodBody, (PsiElement)occurrence, (PsiElement)expression) || CastCanBeReplacedWithVariableInspection.isChangedBetween((PsiVariable)variable, (PsiElement)methodBody, (PsiElement)occurrence, (PsiElement)expression)) continue;
                    return variable;
                }
                PsiInstanceOfExpression instanceOf = InstanceOfUtils.findPatternCandidate((PsiTypeCastExpression)expression);
                if (instanceOf != null && (patternVariable = JavaPsiPatternUtil.getPatternVariable((PsiCaseLabelElement)(pattern = instanceOf.getPattern()))) != null && !CastCanBeReplacedWithVariableInspection.isChangedBetween(castedVar, (PsiElement)methodBody, (PsiElement)instanceOf, (PsiElement)expression) && !CastCanBeReplacedWithVariableInspection.isChangedBetween((PsiVariable)patternVariable, (PsiElement)methodBody, (PsiElement)instanceOf, (PsiElement)expression)) {
                    return patternVariable;
                }
                List narrowVariables = SyntaxTraverser.psiTraverser((PsiElement)method).filter(PsiAssignmentExpression.class).filter(assignment -> EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(assignment.getLExpression(), operand)).filter(assignment -> {
                    PsiExpression narrowVariable = assignment.getRExpression();
                    return narrowVariable != null && narrowVariable.getType() != null && InstanceOfUtils.typeCompatible((PsiType)narrowVariable.getType(), (PsiType)castType, (PsiExpression)operand);
                }).toList();
                for (PsiAssignmentExpression narrowVariable2 : narrowVariables) {
                    if (!CastCanBeReplacedWithVariableInspection.isAtRightLocation(expression, expressionTextRange, (PsiExpression)narrowVariable2) || (declaration = CastCanBeReplacedWithVariableInspection.getVariable(narrowVariable2)) == null || resolveHelper.resolveReferencedVariable(declaration.getName(), (PsiElement)expression) != declaration || CastCanBeReplacedWithVariableInspection.isChangedBetween(castedVar, (PsiElement)methodBody, (PsiElement)narrowVariable2, (PsiElement)expression) || CastCanBeReplacedWithVariableInspection.isChangedBetween((PsiVariable)declaration, (PsiElement)methodBody, (PsiElement)narrowVariable2, (PsiElement)expression)) continue;
                    return declaration;
                }
                if (!(operand instanceof PsiReferenceExpression) || !((declaration = (wideReferenceExpression = (PsiReferenceExpression)operand).resolve()) instanceof PsiLocalVariable)) {
                    return null;
                }
                PsiLocalVariable wideVariable = (PsiLocalVariable)declaration;
                narrowExpression = wideVariable.getInitializer();
                if (!(narrowExpression instanceof PsiReferenceExpression) || !((psiElement = (narrowReferenceExpression = (PsiReferenceExpression)narrowExpression).resolve()) instanceof PsiVariable)) break block17;
                narrowVariable = (PsiVariable)psiElement;
                if (narrowExpression.getType() != null && InstanceOfUtils.typeCompatible((PsiType)narrowExpression.getType(), (PsiType)castType, (PsiExpression)operand)) break block18;
            }
            return null;
        }
        if (!CastCanBeReplacedWithVariableInspection.isAtRightLocation(expression, expressionTextRange, narrowExpression)) {
            return null;
        }
        if (narrowVariable.getName() == null || resolveHelper.resolveReferencedVariable(narrowVariable.getName(), (PsiElement)expression) != narrowVariable || CastCanBeReplacedWithVariableInspection.isChangedBetween(castedVar, (PsiElement)methodBody, (PsiElement)narrowExpression, (PsiElement)expression) || CastCanBeReplacedWithVariableInspection.isChangedBetween(narrowVariable, (PsiElement)methodBody, (PsiElement)narrowExpression, (PsiElement)expression)) {
            return null;
        }
        return narrowVariable;
    }

    private static boolean isAtRightLocation(@NotNull PsiTypeCastExpression expression, @NotNull TextRange expressionTextRange, @NotNull PsiExpression occurrence) {
        if (expression == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(4);
        }
        if (expressionTextRange == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(5);
        }
        if (occurrence == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(6);
        }
        ProgressIndicatorProvider.checkCanceled();
        TextRange occurrenceTextRange = occurrence.getTextRange();
        return occurrence != expression && occurrenceTextRange.getEndOffset() < expressionTextRange.getStartOffset();
    }

    public static boolean isChangedBetween(@NotNull PsiVariable variable, @NotNull PsiElement scope, @NotNull PsiElement start, @NotNull PsiElement end) {
        ControlFlow controlFlow;
        if (variable == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(8);
        }
        if (start == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(9);
        }
        if (end == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(10);
        }
        if (variable.hasModifierProperty("final") || ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)scope)) {
            return false;
        }
        PsiElement broadEnd = CastCanBeReplacedWithVariableInspection.getBroadEnd(scope, start, end);
        try {
            controlFlow = ControlFlowFactory.getInstance((Project)variable.getProject()).getControlFlow(scope, (ControlFlowPolicy)new LocalsControlFlowPolicy(scope), true);
        }
        catch (AnalysisCanceledException ignored) {
            controlFlow = ControlFlow.EMPTY;
        }
        int startOffset = controlFlow.getEndOffset(start) + 1;
        int endOffset = controlFlow.getEndOffset(broadEnd);
        return ControlFlowUtil.getWrittenVariables((ControlFlow)controlFlow, (int)startOffset, (int)endOffset, (boolean)true).contains(variable);
    }

    @NotNull
    private static PsiElement getBroadEnd(@NotNull PsiElement scope, @NotNull PsiElement start, @NotNull PsiElement end) {
        PsiElement currentElement;
        if (scope == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(11);
        }
        if (start == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(12);
        }
        if (end == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(13);
        }
        ArrayList<PsiElement> parentsOfStart = new ArrayList<PsiElement>();
        for (currentElement = start.getParent(); currentElement != null && currentElement != scope; currentElement = currentElement.getParent()) {
            parentsOfStart.add(currentElement);
        }
        PsiElement broadEnd = end;
        for (currentElement = end.getParent(); currentElement != null && currentElement != scope && !parentsOfStart.contains(currentElement); currentElement = currentElement.getParent()) {
            if (!(currentElement instanceof PsiLoopStatement)) continue;
            broadEnd = currentElement;
        }
        PsiElement psiElement = broadEnd;
        if (psiElement == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    @Nullable
    private static PsiLocalVariable getVariable(@NotNull PsiTypeCastExpression occurrence) {
        PsiReferenceExpression referenceExpression;
        PsiAssignmentExpression assignmentExpression;
        PsiExpression psiExpression;
        PsiElement parent;
        if (occurrence == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(15);
        }
        if ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)occurrence.getParent())) instanceof PsiLocalVariable) {
            PsiLocalVariable localVariable = (PsiLocalVariable)parent;
            return localVariable;
        }
        if (parent instanceof PsiAssignmentExpression && (psiExpression = (assignmentExpression = (PsiAssignmentExpression)parent).getLExpression()) instanceof PsiReferenceExpression && (psiExpression = (referenceExpression = (PsiReferenceExpression)psiExpression).resolve()) instanceof PsiLocalVariable) {
            PsiLocalVariable localVariable = (PsiLocalVariable)psiExpression;
            return localVariable;
        }
        return null;
    }

    @Nullable
    private static PsiLocalVariable getVariable(@NotNull PsiAssignmentExpression occurrence) {
        PsiReferenceExpression referenceExpression;
        PsiExpression psiExpression;
        if (occurrence == null) {
            CastCanBeReplacedWithVariableInspection.$$$reportNull$$$0(16);
        }
        if ((psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)occurrence.getRExpression())) instanceof PsiReferenceExpression && (psiExpression = (referenceExpression = (PsiReferenceExpression)psiExpression).resolve()) instanceof PsiLocalVariable) {
            PsiLocalVariable localVariable = (PsiLocalVariable)psiExpression;
            return localVariable;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castedVar";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionTextRange";
                break;
            }
            case 6: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrence";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/CastCanBeReplacedWithVariableInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/CastCanBeReplacedWithVariableInspection";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBroadEnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findReplacement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAtRightLocation";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isChangedBetween";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBroadEnd";
                break;
            }
            case 14: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14 -> new IllegalStateException(string);
        };
    }

    private static class ReplaceCastWithVariableFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final String myText;
        @NotNull
        private final String myVariableName;

        private ReplaceCastWithVariableFix(@NotNull String text, @NotNull PsiVariable variable) {
            if (text == null) {
                ReplaceCastWithVariableFix.$$$reportNull$$$0(0);
            }
            if (variable == null) {
                ReplaceCastWithVariableFix.$$$reportNull$$$0(1);
            }
            this.myText = text;
            this.myVariableName = Objects.requireNonNull(variable.getName());
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{this.myText, this.myVariableName});
            if (string == null) {
                ReplaceCastWithVariableFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message((String)"inspection.cast.can.be.replaced.with.variable.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceCastWithVariableFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceCastWithVariableFix.$$$reportNull$$$0(4);
            }
            if (element == null) {
                ReplaceCastWithVariableFix.$$$reportNull$$$0(5);
            }
            if (updater == null) {
                ReplaceCastWithVariableFix.$$$reportNull$$$0(6);
            }
            if (element instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)element;
                PsiTypeCastExpression toReplace = typeCastExpression.getParent() instanceof PsiParenthesizedExpression ? typeCastExpression.getParent() : typeCastExpression;
                new CommentTracker().replaceAndRestoreComments((PsiElement)toReplace, this.myVariableName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/CastCanBeReplacedWithVariableInspection$ReplaceCastWithVariableFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/CastCanBeReplacedWithVariableInspection$ReplaceCastWithVariableFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

