/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CastCanBeReplacedWithVariableInspection;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.light.LightRecordField;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeconstructionCanBeUsedInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.PATTERN_GUARDS_AND_RECORD_PATTERNS);
        if (set == null) {
            DeconstructionCanBeUsedInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DeconstructionCanBeUsedInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
                PsiPrimaryPattern pattern;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((pattern = expression.getPattern()) instanceof PsiDeconstructionPattern) {
                    return;
                }
                PsiPatternVariable variable = JavaPsiPatternUtil.getPatternVariable((PsiCaseLabelElement)pattern);
                if (variable == null) {
                    return;
                }
                List<List<PsiReferenceExpression>> collect = DeconstructionCanBeUsedInspection.collect(expression, variable, false);
                if (collect.isEmpty()) {
                    return;
                }
                holder.registerProblem((PsiElement)variable.getTypeElement(), InspectionGadgetsBundle.message((String)"inspection.deconstruction.can.be.used.message", (Object[])new Object[0]), new LocalQuickFix[]{new PatternVariableCanBeUsedFix()});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/DeconstructionCanBeUsedInspection$1", "visitInstanceOfExpression"));
            }
        };
    }

    private static List<List<PsiReferenceExpression>> collect(@NotNull PsiInstanceOfExpression instanceOf, @NotNull PsiPatternVariable variable, boolean shouldFindAll) {
        PsiType type;
        if (instanceOf == null) {
            DeconstructionCanBeUsedInspection.$$$reportNull$$$0(2);
        }
        if (variable == null) {
            DeconstructionCanBeUsedInspection.$$$reportNull$$$0(3);
        }
        if (!((type = variable.getType()) instanceof PsiClassType)) {
            return Collections.emptyList();
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass resolved = classType.resolve();
        if (resolved == null || !resolved.isRecord()) {
            return Collections.emptyList();
        }
        Object[] components = resolved.getRecordComponents();
        if (components.length == 0) {
            return Collections.emptyList();
        }
        HashSet<PsiRecordComponent> used = new HashSet<PsiRecordComponent>();
        List references = VariableAccessUtils.getVariableReferences((PsiVariable)variable);
        ArrayList result = new ArrayList();
        for (int i = 0; i < components.length; ++i) {
            result.add(new ArrayList());
        }
        for (PsiReferenceExpression reference : references) {
            if (CastCanBeReplacedWithVariableInspection.isChangedBetween((PsiVariable)variable, variable.getDeclarationScope(), (PsiElement)instanceOf, (PsiElement)reference)) continue;
            PsiRecordComponent component = DeconstructionCanBeUsedInspection.getComponent(reference);
            if (component == null) {
                return Collections.emptyList();
            }
            if (!used.add(component) && !shouldFindAll) continue;
            PsiElementFactory factory = PsiElementFactory.getInstance((Project)reference.getProject());
            PsiExpression call = factory.createExpressionFromText(reference.getText() + "." + component.getName() + "()", (PsiElement)reference);
            if (SideEffectChecker.mayHaveSideEffects((PsiExpression)call)) {
                return Collections.emptyList();
            }
            int index = ArrayUtil.indexOf((Object[])components, (Object)component);
            ((List)result.get(index)).add((PsiReferenceExpression)PsiUtil.skipParenthesizedExprUp((PsiElement)reference.getParent()));
        }
        return used.size() == components.length ? result : Collections.emptyList();
    }

    @Nullable
    private static PsiRecordComponent getComponent(@NotNull PsiReferenceExpression reference) {
        PsiMethodCallExpression call;
        if (reference == null) {
            DeconstructionCanBeUsedInspection.$$$reportNull$$$0(4);
        }
        if ((call = ExpressionUtils.getCallForQualifier((PsiExpression)reference)) != null) {
            PsiField psiField;
            PsiClass aClass;
            PsiMethod method = call.resolveMethod();
            if (method instanceof LightRecordMethod) {
                LightRecordMethod recordMethod = (LightRecordMethod)method;
                return recordMethod.getRecordComponent();
            }
            if (method != null && (aClass = method.getContainingClass()) != null && (psiField = aClass.findFieldByName(method.getName(), false)) instanceof LightRecordField) {
                LightRecordField recordField = (LightRecordField)psiField;
                return recordField.getRecordComponent();
            }
        } else {
            PsiReferenceExpression ref;
            PsiElement psiElement = PsiUtil.skipParenthesizedExprUp((PsiElement)reference.getParent());
            if (psiElement instanceof PsiReferenceExpression && (psiElement = (ref = (PsiReferenceExpression)psiElement).resolve()) instanceof LightRecordField) {
                LightRecordField recordField = (LightRecordField)psiElement;
                return recordField.getRecordComponent();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/DeconstructionCanBeUsedInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/DeconstructionCanBeUsedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static class PatternVariableCanBeUsedFix
    extends PsiUpdateModCommandQuickFix {
        private PatternVariableCanBeUsedFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message((String)"inspection.deconstruction.can.be.used.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiPatternVariable patternVariable;
            if (project == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(3);
            }
            if ((patternVariable = (PsiPatternVariable)ObjectUtils.tryCast((Object)element.getParent(), PsiPatternVariable.class)) == null) {
                return;
            }
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)ObjectUtils.tryCast((Object)patternVariable.getParent().getParent(), PsiInstanceOfExpression.class);
            if (instanceOf == null) {
                return;
            }
            List<List<PsiReferenceExpression>> collect = DeconstructionCanBeUsedInspection.collect(instanceOf, patternVariable, true);
            StringJoiner deconstructionList = new StringJoiner(", ", "(", ")");
            ArrayList<String> usedNames = new ArrayList<String>();
            for (List<PsiReferenceExpression> expressions : collect) {
                PsiReferenceExpression firstRef = expressions.getFirst();
                PsiType type = firstRef.getType();
                String deconstructionName = PatternVariableCanBeUsedFix.getDeconstructionName(expressions, usedNames, patternVariable);
                String stringType = type != null ? (type instanceof PsiCapturedWildcardType || type instanceof PsiWildcardType ? "Object" : type.getCanonicalText()) : "var";
                deconstructionList.add(stringType + " " + deconstructionName);
                for (PsiReferenceExpression expression : expressions) {
                    PsiReferenceExpression psiReferenceExpression;
                    PsiLocalVariable variable = PatternVariableCanBeUsedFix.getVariableFromInitializer(expression);
                    if (variable != null) {
                        List references = VariableAccessUtils.getVariableReferences((PsiVariable)variable);
                        for (PsiReferenceExpression ref : references) {
                            ExpressionUtils.bindReferenceTo((PsiReferenceExpression)ref, (String)deconstructionName);
                        }
                        new CommentTracker().deleteAndRestoreComments((PsiElement)variable);
                        continue;
                    }
                    CommentTracker commentTracker = new CommentTracker();
                    PsiElement psiElement = expression.getParent();
                    if (psiElement instanceof PsiMethodCallExpression) {
                        PsiMethodCallExpression call = (PsiMethodCallExpression)psiElement;
                        psiReferenceExpression = call;
                    } else {
                        psiReferenceExpression = expression;
                    }
                    commentTracker.replace((PsiElement)psiReferenceExpression, deconstructionName);
                }
            }
            PsiInstanceOfExpression replace = (PsiInstanceOfExpression)new CommentTracker().replace((PsiElement)instanceOf, instanceOf.getOperand().getText() + " instanceof " + element.getText() + String.valueOf(deconstructionList) + patternVariable.getName());
            PsiPrimaryPattern pattern = replace.getPattern();
            PsiPatternVariable variable = JavaPsiPatternUtil.getPatternVariable((PsiCaseLabelElement)pattern);
            assert (variable != null);
            if (!VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)variable.getDeclarationScope())) {
                new CommentTracker().replace((PsiElement)replace, replace.getOperand().getText() + " instanceof " + element.getText() + String.valueOf(deconstructionList));
            }
        }

        @NotNull
        private static String getDeconstructionName(@NotNull List<PsiReferenceExpression> expressions, @NotNull List<String> usedNames, @NotNull PsiPatternVariable patternVariable) {
            if (expressions == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(4);
            }
            if (usedNames == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(5);
            }
            if (patternVariable == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(6);
            }
            PsiReferenceExpression firstRef = expressions.getFirst();
            PsiLocalVariable firstVariable = null;
            for (PsiReferenceExpression expression : expressions) {
                PsiLocalVariable variable = PatternVariableCanBeUsedFix.getVariableFromInitializer(expression);
                if (variable == null) continue;
                firstVariable = variable;
                break;
            }
            String deconstructionName = StringUtil.substringAfter((String)firstRef.getText(), (String)".");
            if (firstVariable != null && firstVariable.getNameIdentifier() != null) {
                deconstructionName = firstVariable.getNameIdentifier().getText();
                usedNames.add(deconstructionName);
            } else {
                VariableNameGenerator generator = new VariableNameGenerator((PsiElement)patternVariable, VariableKind.PARAMETER).skipNames(usedNames).byName(new String[]{deconstructionName});
                deconstructionName = generator.generate(true);
                usedNames.add(deconstructionName);
            }
            String string = deconstructionName;
            if (string == null) {
                PatternVariableCanBeUsedFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Nullable
        private static PsiLocalVariable getVariableFromInitializer(PsiReferenceExpression ref) {
            PsiElement psiElement;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)ref.getParent());
            if (parent instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)parent;
                return variable;
            }
            if (parent instanceof PsiMethodCallExpression && (psiElement = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent())) instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)psiElement;
                return variable;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/DeconstructionCanBeUsedInspection$PatternVariableCanBeUsedFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressions";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usedNames";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patternVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/DeconstructionCanBeUsedInspection$PatternVariableCanBeUsedFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeconstructionName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getDeconstructionName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

