/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowSubRange;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class IdempotentLoopBodyInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            IdempotentLoopBodyInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitWhileStatement(@NotNull PsiWhileStatement loop) {
                ControlFlow controlFlow;
                PsiExpression condition;
                if (loop == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((condition = loop.getCondition()) == null || SideEffectChecker.mayHaveSideEffects((PsiExpression)condition)) {
                    return;
                }
                PsiStatement body = loop.getBody();
                if (body == null) {
                    return;
                }
                if (SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)body)) {
                    return;
                }
                try {
                    controlFlow = ControlFlowFactory.getInstance((Project)loop.getProject()).getControlFlow((PsiElement)body, (ControlFlowPolicy)LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                }
                catch (AnalysisCanceledException ignored) {
                    return;
                }
                1.checkControlFlow((PsiLoopStatement)loop, controlFlow, holder);
            }

            public void visitForStatement(@NotNull PsiForStatement loop) {
                ControlFlow controlFlow;
                PsiExpression condition;
                if (loop == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((condition = loop.getCondition()) != null && SideEffectChecker.mayHaveSideEffects((PsiExpression)condition)) {
                    return;
                }
                PsiStatement body = loop.getBody();
                if (body == null) {
                    return;
                }
                PsiStatement update = loop.getUpdate();
                if (SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)body) || update != null && SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)update)) {
                    return;
                }
                try {
                    controlFlow = ControlFlowFactory.getInstance((Project)loop.getProject()).getControlFlow((PsiElement)loop, (ControlFlowPolicy)LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                }
                catch (AnalysisCanceledException ignored) {
                    return;
                }
                int start = controlFlow.getStartOffset((PsiElement)body);
                int end = controlFlow.getEndOffset((PsiElement)(update == null ? body : update));
                if (start == -1 || end == -1) {
                    return;
                }
                controlFlow = new ControlFlowSubRange(controlFlow, start, end);
                1.checkControlFlow((PsiLoopStatement)loop, controlFlow, holder);
            }

            private static void checkControlFlow(PsiLoopStatement loop, ControlFlow bodyFlow, @NotNull ProblemsHolder holder2) {
                Collection variables;
                if (holder2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((variables = ControlFlowUtil.getWrittenVariables((ControlFlow)bodyFlow, (int)0, (int)bodyFlow.getSize(), (boolean)true)).isEmpty()) {
                    return;
                }
                List reads = ControlFlowUtil.getReadBeforeWrite((ControlFlow)bodyFlow);
                if (StreamEx.of((Collection)reads).map(PsiReference::resolve).select(PsiVariable.class).noneMatch(v -> v.hasModifierProperty("volatile") || variables.contains(v))) {
                    holder2.registerProblem(loop.getFirstChild(), JavaBundle.message((String)"inspection.idempotent.loop.body", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "loop";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "holder";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/IdempotentLoopBodyInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWhileStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitForStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkControlFlow";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/IdempotentLoopBodyInspection", "buildVisitor"));
    }
}

