/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OverflowingLoopIndexInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OverflowingLoopIndexInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitForStatement(@NotNull PsiForStatement statement) {
                PsiExpressionStatement updateStatement;
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((updateStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)statement.getUpdate(), PsiExpressionStatement.class)) == null) {
                    return;
                }
                PsiExpression updateExpression = updateStatement.getExpression();
                PsiLocalVariable indexVariable = OverflowingLoopIndexInspection.findIndexVariable(updateExpression);
                if (indexVariable == null) {
                    return;
                }
                PsiType type = indexVariable.getType();
                if (!type.equals(PsiTypes.intType()) && !type.equals(PsiTypes.longType())) {
                    return;
                }
                ConditionType conditionType = OverflowingLoopIndexInspection.getConditionType(statement.getCondition(), (PsiVariable)indexVariable);
                if (conditionType == ConditionType.Unknown) {
                    return;
                }
                if (!OverflowingLoopIndexInspection.notChangesMonotony(conditionType, updateExpression)) {
                    return;
                }
                if (OverflowingLoopIndexInspection.indexUpdatedInBody(statement, indexVariable, conditionType)) {
                    return;
                }
                holder.registerProblem(statement.getFirstChild(), JavaBundle.message((String)"inspection.overflowing.loop.index.inspection.description", (Object[])new Object[0]), new LocalQuickFix[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/OverflowingLoopIndexInspection$1", "visitForStatement"));
            }
        };
    }

    @Nullable
    private static PsiLocalVariable findIndexVariable(PsiExpression updateExpression) {
        if (updateExpression instanceof PsiUnaryExpression) {
            PsiUnaryExpression unaryExpression = (PsiUnaryExpression)updateExpression;
            return ExpressionUtils.resolveLocalVariable((PsiExpression)unaryExpression.getOperand());
        }
        if (updateExpression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)updateExpression;
            return ExpressionUtils.resolveLocalVariable((PsiExpression)assignmentExpression.getLExpression());
        }
        return null;
    }

    private static ConditionType getConditionType(@Nullable PsiExpression condition, @NotNull PsiVariable variable) {
        PsiExpression lOperand;
        PsiBinaryExpression binaryExpression;
        if (variable == null) {
            OverflowingLoopIndexInspection.$$$reportNull$$$0(1);
        }
        if ((binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)condition, PsiBinaryExpression.class)) == null) {
            return ConditionType.Unknown;
        }
        IElementType tokenType = binaryExpression.getOperationTokenType();
        ConditionType type = ConditionType.Unknown;
        if (tokenType == JavaTokenType.GT || tokenType == JavaTokenType.GE) {
            type = ConditionType.VarGreater;
        } else if (tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE) {
            type = ConditionType.VarLower;
        }
        if (type != ConditionType.Unknown && !ExpressionUtils.isReferenceTo((PsiExpression)(lOperand = binaryExpression.getLOperand()), (PsiVariable)variable)) {
            type = ExpressionUtils.isReferenceTo((PsiExpression)binaryExpression.getROperand(), (PsiVariable)variable) ? type.inverted() : ConditionType.Unknown;
        }
        return type;
    }

    private static boolean indexUpdatedInBody(PsiForStatement statement, PsiLocalVariable indexVariable, ConditionType conditionType) {
        PsiStatement body = statement.getBody();
        if (body == null) {
            return true;
        }
        return !((StreamEx)StreamEx.ofTree((Object)body, element -> StreamEx.of((Object[])element.getChildren())).select(PsiReferenceExpression.class).filter(expression -> expression.isReferenceTo((PsiElement)indexVariable))).allMatch(expression -> {
            PsiAssignmentExpression assignmentExpression;
            PsiUnaryExpression psiUnaryExpression;
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiUnaryExpression && ExpressionUtils.isReferenceTo((PsiExpression)(psiUnaryExpression = (PsiUnaryExpression)parent).getOperand(), (PsiVariable)indexVariable) || parent instanceof PsiAssignmentExpression && ExpressionUtils.isReferenceTo((PsiExpression)(assignmentExpression = (PsiAssignmentExpression)parent).getLExpression(), (PsiVariable)indexVariable)) {
                return OverflowingLoopIndexInspection.notChangesMonotony(conditionType, (PsiExpression)ObjectUtils.tryCast((Object)parent, PsiExpression.class));
            }
            return true;
        });
    }

    private static boolean notChangesMonotony(ConditionType conditionType, @Nullable PsiExpression expression) {
        PsiUnaryExpression updateUnary = (PsiUnaryExpression)ObjectUtils.tryCast((Object)expression, PsiUnaryExpression.class);
        if (updateUnary != null) {
            IElementType tokenType = updateUnary.getOperationTokenType();
            if (conditionType == ConditionType.VarGreater) {
                return tokenType == JavaTokenType.PLUSPLUS;
            }
            return tokenType == JavaTokenType.MINUSMINUS;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)expression, PsiAssignmentExpression.class);
        if (assignment != null) {
            Object rightPart = ExpressionUtils.computeConstantExpression((PsiExpression)assignment.getRExpression());
            Number number = (Number)ObjectUtils.tryCast((Object)rightPart, Number.class);
            if (number == null) {
                return false;
            }
            boolean negative = number.longValue() < 0L;
            IElementType op = assignment.getOperationTokenType();
            if (conditionType == ConditionType.VarGreater) {
                return op == JavaTokenType.PLUSEQ && !negative || op == JavaTokenType.MINUSEQ && negative;
            }
            return op == JavaTokenType.MINUSEQ && !negative || op == JavaTokenType.PLUSEQ && negative;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/OverflowingLoopIndexInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getConditionType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum ConditionType {
        Unknown,
        VarGreater,
        VarLower;


        ConditionType inverted() {
            return switch (this.ordinal()) {
                case 1 -> VarLower;
                case 2 -> VarGreater;
                default -> Unknown;
            };
        }
    }
}

