/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ReadWriteStringCanBeUsedInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher FILES_WRITE = CallMatcher.staticCall((String)"java.nio.file.Files", (String[])new String[]{"write"}).parameterTypes(new String[]{"java.nio.file.Path", "byte[]", "java.nio.file.OpenOption..."});
    private static final CallMatcher FILES_READ_ALL_BYTES = CallMatcher.staticCall((String)"java.nio.file.Files", (String[])new String[]{"readAllBytes"}).parameterTypes(new String[]{"java.nio.file.Path"});
    private static final CallMatcher STRING_GET_BYTES = CallMatcher.exactInstanceCall((String)"java.lang.String", (String[])new String[]{"getBytes"}).parameterTypes(new String[]{"java.nio.charset.Charset"});
    private static final CallMatcher CHARSET_FOR_NAME = CallMatcher.staticCall((String)"java.nio.charset.Charset", (String[])new String[]{"forName"}).parameterTypes(new String[]{"java.lang.String"});

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        LanguageLevel level;
        if (holder == null) {
            ReadWriteStringCanBeUsedInspection.$$$reportNull$$$0(0);
        }
        if ((level = PsiUtil.getLanguageLevel((PsiElement)holder.getFile())).isLessThan(LanguageLevel.JDK_11)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                ReadWriteStringCanBeUsedInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                PsiJavaCodeReferenceElement classReference;
                PsiExpression[] args;
                PsiNewExpression newExpression;
                PsiExpressionList expressionList;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (FILES_WRITE.test(call)) {
                    PsiMethodCallExpression bytesExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ExpressionUtils.resolveExpression((PsiExpression)call.getArgumentList().getExpressions()[1]), PsiMethodCallExpression.class);
                    if (STRING_GET_BYTES.test(bytesExpression) && bytesExpression.getMethodExpression().getQualifierExpression() != null) {
                        ProblemHighlightType highlight;
                        String message = JavaBundle.message((String)"inspection.message.can.be.replaced.with.files.writestring", (Object[])new Object[0]);
                        if (level.isAtLeast(LanguageLevel.JDK_12) || ReadWriteStringCanBeUsedInspection.isNonUtf8Charset(bytesExpression.getArgumentList().getExpressions()[0])) {
                            highlight = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                        } else {
                            highlight = ProblemHighlightType.INFORMATION;
                            if (!isOnTheFly) {
                                return;
                            }
                        }
                        PsiReferenceExpression methodExpression = call.getMethodExpression();
                        PsiElement referenceNameElement = methodExpression.getReferenceNameElement();
                        if (referenceNameElement != null) {
                            holder.registerProblem(referenceNameElement, message, highlight, new LocalQuickFix[]{new ReplaceWithWriteStringFix(highlight == ProblemHighlightType.INFORMATION)});
                        }
                    }
                } else if (FILES_READ_ALL_BYTES.test(call) && (expressionList = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiExpressionList.class)) != null && (newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)expressionList.getParent(), PsiNewExpression.class)) != null && newExpression.getAnonymousClass() == null && ConstructionUtils.isReferenceTo((PsiJavaCodeReferenceElement)newExpression.getClassReference(), (String[])new String[]{"java.lang.String"}) && (args = expressionList.getExpressions()).length == 2 && PsiTreeUtil.isAncestor((PsiElement)args[0], (PsiElement)call, (boolean)false) && TypeUtils.typeEquals((String)"java.nio.charset.Charset", (PsiType)args[1].getType()) && (classReference = newExpression.getClassOrAnonymousClassReference()) != null) {
                    holder.registerProblem((PsiElement)classReference, JavaBundle.message((String)"inspection.message.can.be.replaced.with.files.readstring", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithReadStringFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/ReadWriteStringCanBeUsedInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    static boolean isUtf8Charset(PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)expression;
            if (!"UTF_8".equals(ref.getReferenceName())) {
                return false;
            }
            PsiField target = (PsiField)ObjectUtils.tryCast((Object)ref.resolve(), PsiField.class);
            return target != null && target.getContainingClass() != null && "java.nio.charset.StandardCharsets".equals(target.getContainingClass().getQualifiedName());
        }
        if (expression instanceof PsiMethodCallExpression && CHARSET_FOR_NAME.test((PsiMethodCallExpression)expression)) {
            PsiExpression arg = ((PsiMethodCallExpression)expression).getArgumentList().getExpressions()[0];
            Object value = ExpressionUtils.computeConstantExpression((PsiExpression)arg);
            return value instanceof String && ((String)value).equalsIgnoreCase("utf-8");
        }
        return false;
    }

    static boolean isNonUtf8Charset(PsiExpression expression) {
        for (int i = 0; i < 3; ++i) {
            PsiField target;
            block7: {
                block6: {
                    if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiReferenceExpression) || (target = (PsiField)ObjectUtils.tryCast((Object)((PsiReferenceExpression)expression).resolve(), PsiField.class)) == null) break block6;
                    if ("UTF_8".equals(target.getName())) {
                        return false;
                    }
                    if (target.getContainingClass() != null && "java.nio.charset.StandardCharsets".equals(target.getContainingClass().getQualifiedName())) {
                        return true;
                    }
                    if (target.hasModifierProperty("final")) break block7;
                }
                if (!(expression instanceof PsiMethodCallExpression) || !CHARSET_FOR_NAME.test((PsiMethodCallExpression)expression)) break;
                PsiExpression arg = ((PsiMethodCallExpression)expression).getArgumentList().getExpressions()[0];
                Object value = ExpressionUtils.computeConstantExpression((PsiExpression)arg);
                return value instanceof String && !((String)value).equalsIgnoreCase("utf-8");
            }
            expression = target.getInitializer();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ReadWriteStringCanBeUsedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ReadWriteStringCanBeUsedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class ReplaceWithWriteStringFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myMayNotWork;

        private ReplaceWithWriteStringFix(boolean mayNotWork) {
            this.myMayNotWork = mayNotWork;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = this.myMayNotWork ? JavaBundle.message((String)"quickfix.text.0.may.not.work.before.jdk.11.0.2", (Object[])new Object[]{this.getFamilyName()}) : this.getFamilyName();
            if (string == null) {
                ReplaceWithWriteStringFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Files.writeString()"});
            if (string == null) {
                ReplaceWithWriteStringFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression writeCall;
            if (project == null) {
                ReplaceWithWriteStringFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceWithWriteStringFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceWithWriteStringFix.$$$reportNull$$$0(4);
            }
            if (!FILES_WRITE.test(writeCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element.getParent().getParent(), PsiMethodCallExpression.class))) {
                return;
            }
            PsiExpressionList argumentList = writeCall.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length < 2) {
                return;
            }
            PsiExpression bytesArg = args[1];
            PsiMethodCallExpression bytesExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ExpressionUtils.resolveExpression((PsiExpression)bytesArg), PsiMethodCallExpression.class);
            if (!STRING_GET_BYTES.test(bytesExpression)) {
                return;
            }
            PsiExpression stringExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)bytesExpression.getMethodExpression().getQualifierExpression());
            if (stringExpression == null) {
                return;
            }
            PsiExpression charsetExpression = bytesExpression.getArgumentList().getExpressions()[0];
            CommentTracker ct = new CommentTracker();
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)writeCall, (String)"writeString");
            if (!ReadWriteStringCanBeUsedInspection.isUtf8Charset(charsetExpression)) {
                argumentList.addAfter(ct.markUnchanged((PsiElement)charsetExpression), (PsiElement)bytesArg);
            }
            PsiLocalVariable variable = ExpressionUtils.resolveLocalVariable((PsiExpression)bytesArg);
            ct.replaceAndRestoreComments((PsiElement)bytesArg, (PsiElement)stringExpression);
            if (variable != null) {
                ct = new CommentTracker();
                ct.markUnchanged((PsiElement)stringExpression);
                ct.deleteAndRestoreComments((PsiElement)variable);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ReadWriteStringCanBeUsedInspection$ReplaceWithWriteStringFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ReadWriteStringCanBeUsedInspection$ReplaceWithWriteStringFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ReplaceWithReadStringFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithReadStringFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Files.readString()"});
            if (string == null) {
                ReplaceWithReadStringFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiNewExpression newExpression;
            if (project == null) {
                ReplaceWithReadStringFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithReadStringFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithReadStringFix.$$$reportNull$$$0(3);
            }
            if ((newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiNewExpression.class)) == null) {
                return;
            }
            PsiExpressionList newArgList = newExpression.getArgumentList();
            if (newArgList == null) {
                return;
            }
            PsiExpression[] newArgs = newArgList.getExpressions();
            if (newArgs.length != 2) {
                return;
            }
            PsiMethodCallExpression readCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)newArgs[0]), PsiMethodCallExpression.class);
            if (!FILES_READ_ALL_BYTES.test(readCall)) {
                return;
            }
            PsiExpression charsetExpression = newArgs[1];
            CommentTracker ct = new CommentTracker();
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)readCall, (String)"readString");
            if (!ReadWriteStringCanBeUsedInspection.isUtf8Charset(charsetExpression)) {
                readCall.getArgumentList().add(ct.markUnchanged((PsiElement)charsetExpression));
            }
            ct.replaceAndRestoreComments((PsiElement)newExpression, (PsiElement)readCall);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ReadWriteStringCanBeUsedInspection$ReplaceWithReadStringFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ReadWriteStringCanBeUsedInspection$ReplaceWithReadStringFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

