/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.classCanBeRecord;

import com.intellij.codeInspection.AddToInspectionOptionListFix;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.classCanBeRecord.ConvertToRecordFix;
import com.intellij.codeInspection.classCanBeRecord.ConvertToRecordProcessor;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.TestOnly;

@NotNullByDefault
public final class ClassCanBeRecordInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    private static final List<String> IGNORED_ANNOTATIONS = List.of("io.micronaut.*", "jakarta.*", "javax.*", "org.springframework.*");
    public ConversionStrategy myConversionStrategy = ConversionStrategy.DO_NOT_SUGGEST;
    public boolean suggestAccessorsRenaming = true;
    public final List<@NlsSafe String> myIgnoredAnnotations = new ArrayList<String>();

    public ClassCanBeRecordInspection() {
        this.myIgnoredAnnotations.addAll(IGNORED_ANNOTATIONS);
    }

    @TestOnly
    public ClassCanBeRecordInspection(ConversionStrategy conversionStrategy, boolean suggestAccessorsRenaming) {
        this.myConversionStrategy = conversionStrategy;
        this.suggestAccessorsRenaming = suggestAccessorsRenaming;
    }

    public Set<JavaFeature> requiredFeatures() {
        return Set.of(JavaFeature.RECORDS);
    }

    @InspectionMessage
    protected String buildErrorString(Object ... infos) {
        return JavaBundle.message((String)"class.can.be.record.display.name", (Object[])new Object[0]);
    }

    public BaseInspectionVisitor buildVisitor() {
        return new ClassCanBeRecordVisitor(this.myConversionStrategy, this.suggestAccessorsRenaming, this.myIgnoredAnnotations);
    }

    protected LocalQuickFix[] buildFixes(Object ... infos) {
        SmartList fixes = new SmartList();
        boolean suggestQuickFix = (Boolean)infos[0];
        if (suggestQuickFix) {
            PsiAnnotation[] annotations;
            fixes.add(new ConvertToRecordFix(this.suggestAccessorsRenaming, this.myIgnoredAnnotations));
            PsiClass psiClass = (PsiClass)ObjectUtils.tryCast((Object)infos[1], PsiClass.class);
            if (psiClass != null && (annotations = psiClass.getAnnotations()).length > 0 && annotations.length < 4) {
                for (PsiAnnotation annotation : annotations) {
                    String fqn = annotation.getQualifiedName();
                    if (fqn == null) continue;
                    fixes.add(new AddToInspectionOptionListFix((InspectionProfileEntry)this, JavaBundle.message((String)"class.can.be.record.suppress.conversion.if.annotated.fix.name", (Object[])new Object[]{fqn}), fqn, tool -> tool.myIgnoredAnnotations));
                }
            }
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public OptPane getOptionsPane() {
        return OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"suggestAccessorsRenaming", (String)JavaBundle.message((String)"class.can.be.record.suggest.renaming.accessors", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"noHighlightingFixAvailable", (String)JavaBundle.message((String)"class.can.be.record.record.highlight.when.semantics.change", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(JavaBundle.message((String)"class.can.be.record.record.highlight.when.semantics.change.description", (Object[])new Object[0])), OptPane.stringList((String)"myIgnoredAnnotations", (String)JavaBundle.message((String)"class.can.be.record.suppress.conversion.if.annotated", (Object[])new Object[0])).description(HtmlChunk.raw((String)JavaCompilerBundle.message((String)"class.can.be.record.suppress.conversion.if.annotated.description", (Object[])new Object[0])))});
    }

    public OptionController getOptionController() {
        return super.getOptionController().onValue("noHighlightingFixAvailable", () -> this.myConversionStrategy == ConversionStrategy.DO_NOT_SUGGEST, newValue -> {
            this.myConversionStrategy = newValue != false ? ConversionStrategy.DO_NOT_SUGGEST : ConversionStrategy.SHOW_AFFECTED_MEMBERS;
        });
    }

    public static enum ConversionStrategy {
        DO_NOT_SUGGEST,
        SHOW_AFFECTED_MEMBERS,
        SILENTLY;

    }

    private static class ClassCanBeRecordVisitor
    extends BaseInspectionVisitor {
        private final ConversionStrategy myConversionStrategy;
        private final boolean mySuggestAccessorsRenaming;
        private final List<String> myIgnoredAnnotations;

        private ClassCanBeRecordVisitor(ConversionStrategy conversionStrategy, boolean suggestAccessorsRenaming, List<String> ignoredAnnotations) {
            this.myConversionStrategy = conversionStrategy;
            this.mySuggestAccessorsRenaming = suggestAccessorsRenaming;
            this.myIgnoredAnnotations = ignoredAnnotations;
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            PsiIdentifier classIdentifier = aClass.getNameIdentifier();
            if (classIdentifier == null) {
                return;
            }
            ConvertToRecordFix.RecordCandidate recordCandidate = ConvertToRecordFix.tryCreateRecordCandidate(aClass, this.mySuggestAccessorsRenaming, this.myIgnoredAnnotations);
            if (recordCandidate == null) {
                return;
            }
            boolean suggestQuickFix = true;
            boolean noHighlightingButKeepFixAvailable = this.myConversionStrategy == ConversionStrategy.DO_NOT_SUGGEST || this.myConversionStrategy == ConversionStrategy.SILENTLY;
            boolean isConflictFree = ConvertToRecordProcessor.findConflicts(recordCandidate).isEmpty();
            ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (!isConflictFree) {
                if (noHighlightingButKeepFixAvailable) {
                    highlightType = ProblemHighlightType.INFORMATION;
                }
                if (!this.isOnTheFly()) {
                    suggestQuickFix = false;
                }
            }
            this.registerError((PsiElement)classIdentifier, highlightType, new Object[]{suggestQuickFix, aClass});
        }
    }
}

