/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.codeInspection.java19api.DescriptorsGenerator;
import com.intellij.codeInspection.java19api.UniqueModuleNames;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.java.workspace.entities.JavaModuleSettingsEntity;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.pom.java.JavaFeature;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Java9GenerateModuleDescriptorsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(Java9GenerateModuleDescriptorsAction.class);
    private static final String CLASS_FILE_PATTERN = "glob:*.class";

    Java9GenerateModuleDescriptorsAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null && !DumbService.isDumb((Project)project) && Java9GenerateModuleDescriptorsAction.isModularJdkAvailable());
    }

    private static boolean isModularJdkAvailable() {
        return ContainerUtil.exists((Object[])ProjectJdkTable.getInstance().getAllJdks(), sdk -> JavaSdkUtil.isJdkAtLeast((Sdk)sdk, (JavaSdkVersion)JavaSdkVersion.JDK_1_9));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        CompileScope scope;
        Project project;
        if (e == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        if (!compilerManager.isUpToDate(scope = compilerManager.createProjectCompileScope(project))) {
            int result = Messages.showYesNoCancelDialog((Project)project, (String)JavaRefactoringBundle.message((String)"generate.module.descriptors.rebuild.message", (Object[])new Object[0]), (String)Java9GenerateModuleDescriptorsAction.getTitle(), null);
            switch (result) {
                case 0: {
                    compilerManager.compile(scope, (aborted, errors, warnings, compileContext) -> {
                        if (!aborted && errors == 0) {
                            Java9GenerateModuleDescriptorsAction.generate(project);
                        }
                    });
                    return;
                }
                case 2: {
                    return;
                }
            }
        }
        Java9GenerateModuleDescriptorsAction.generate(project);
    }

    private static void generate(@NotNull Project project) {
        if (project == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(3);
        }
        DumbService.getInstance((Project)project).smartInvokeLater(() -> Java9GenerateModuleDescriptorsAction.generateWhenSmart(project));
    }

    private static void generateWhenSmart(final @NotNull Project project) {
        if (project == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!DumbService.isDumb((Project)project), (Object)"Module name index should be ready");
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, Java9GenerateModuleDescriptorsAction.getTitle(), true){

            public void run(@NotNull ProgressIndicator indicator) {
                List<DescriptorsGenerator.ModuleFiles> moduleFiles;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ContainerUtil.exists(moduleFiles = Java9GenerateModuleDescriptorsAction.collectClassFiles(project), module -> !module.files().isEmpty())) {
                    new DescriptorsGenerator(project, new UniqueModuleNames(project), LOG).generate(moduleFiles, indicator);
                } else {
                    NotificationGroupManager.getInstance().getNotificationGroup("Failed to generate module descriptors").createNotification(this.getTitle(), JavaRefactoringBundle.message((String)"generate.module.descriptors.build.required.message", (Object[])new Object[0]), NotificationType.ERROR).setImportant(true).notify(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction$1", "run"));
            }
        });
    }

    @NotNull
    private static List<DescriptorsGenerator.ModuleFiles> collectClassFiles(@NotNull Project project) {
        if (project == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(5);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setIndeterminate(true);
        indicator.setText(JavaRefactoringBundle.message((String)"generate.module.descriptors.scanning.message", (Object[])new Object[0]));
        HashMap<String, JavaModuleSettingsEntity> moduleSettingsByName = new HashMap<String, JavaModuleSettingsEntity>();
        for (JavaModuleSettingsEntity moduleSettings : WorkspaceModel.getInstance((Project)project).getCurrentSnapshot().entities(JavaModuleSettingsEntity.class)) {
            moduleSettingsByName.put(moduleSettings.getModule().getName(), moduleSettings);
        }
        ArrayList<DescriptorsGenerator.ModuleFiles> moduleFiles = new ArrayList<DescriptorsGenerator.ModuleFiles>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!Java9GenerateModuleDescriptorsAction.mayContainModuleInfo(module)) continue;
            try {
                String url;
                VirtualFileUrl compilerOutput;
                Path production = null;
                JavaModuleSettingsEntity moduleSettings = (JavaModuleSettingsEntity)moduleSettingsByName.get(module.getName());
                if (moduleSettings != null && (compilerOutput = moduleSettings.getCompilerOutput()) != null) {
                    String url2 = VirtualFileManager.extractPath((String)compilerOutput.getUrl());
                    Path path = Paths.get(url2, new String[0]);
                    Path path2 = production = Files.exists(path, new LinkOption[0]) ? path : null;
                }
                if (production == null && (url = CompilerPaths.getModuleOutputPath((Module)module, (boolean)false)) != null) {
                    Path path = Paths.get(url, new String[0]);
                    production = Files.exists(path, new LinkOption[0]) ? path : null;
                }
                moduleFiles.add(new DescriptorsGenerator.ModuleFiles(module, Java9GenerateModuleDescriptorsAction.collectClassFiles(production)));
            }
            catch (IOException e) {
                NotificationGroupManager.getInstance().getNotificationGroup("Failed to generate module descriptors").createNotification(Java9GenerateModuleDescriptorsAction.getTitle(), JavaRefactoringBundle.message((String)"generate.module.descriptors.io.exceptions.message", (Object[])new Object[]{module.getName()}), NotificationType.ERROR).setImportant(true).notify(project);
                List<DescriptorsGenerator.ModuleFiles> list = Collections.emptyList();
                if (list == null) {
                    Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(6);
                }
                return list;
            }
        }
        if (moduleFiles.isEmpty()) {
            NotificationGroupManager.getInstance().getNotificationGroup("Failed to generate module descriptors").createNotification(Java9GenerateModuleDescriptorsAction.getTitle(), JavaRefactoringBundle.message((String)"generate.module.descriptors.no.suitable.modules.message", (Object[])new Object[0]), NotificationType.WARNING).setImportant(true).notify(project);
        }
        ArrayList<DescriptorsGenerator.ModuleFiles> arrayList = moduleFiles;
        if (arrayList == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static boolean mayContainModuleInfo(@NotNull Module module) {
        if (module == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(8);
        }
        return (Boolean)ReadAction.compute(() -> JavaFeature.MODULES.isSufficient(LanguageLevelUtil.getEffectiveLanguageLevel((Module)module)));
    }

    @NotNull
    private static List<Path> collectClassFiles(@Nullable Path file) throws IOException {
        if (file == null || !Files.exists(file, new LinkOption[0])) {
            List<Path> list = Collections.emptyList();
            if (list == null) {
                Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(9);
            }
            return list;
        }
        Stream<Path> stream = Files.walk(file, new FileVisitOption[0]);
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(CLASS_FILE_PATTERN);
        List<Path> list = stream.filter(path -> matcher.matches(path.getFileName())).toList();
        List<Path> list2 = list;
        if (list2 == null) {
            Java9GenerateModuleDescriptorsAction.$$$reportNull$$$0(10);
        }
        return list2;
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @NlsContexts.DialogTitle
    private static String getTitle() {
        return JavaRefactoringBundle.message((String)"generate.module.descriptors.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java19api/Java9GenerateModuleDescriptorsAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateWhenSmart";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectClassFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mayContainModuleInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7, 9, 10 -> new IllegalStateException(string);
        };
    }
}

