/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.util.PsiUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class NameConverterUtil {
    private static final Pattern NON_NAME = Pattern.compile("[^A-Za-z0-9]");
    private static final Pattern DOT_SEQUENCE = Pattern.compile("\\.{2,}");

    private NameConverterUtil() {
    }

    @NotNull
    public static String convertModuleName(@NotNull String name) {
        if (name == null) {
            NameConverterUtil.$$$reportNull$$$0(0);
        }
        name = NON_NAME.matcher(name).replaceAll(".");
        name = DOT_SEQUENCE.matcher(name).replaceAll(".");
        name = StringUtil.trimLeading((String)StringUtil.trimTrailing((String)name, (char)'.'), (char)'.');
        String[] parts = name.split("\\.");
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String part : parts) {
            if (part.isEmpty()) continue;
            if (Character.isJavaIdentifierStart(part.charAt(0))) {
                if (!first) {
                    builder.append('.');
                }
                builder.append(part);
                if (PsiUtil.isKeyword((String)part, (LanguageLevel)LanguageLevel.JDK_1_9)) {
                    builder.append('x');
                }
            } else {
                if (first) {
                    builder.append("module");
                }
                builder.append(part);
            }
            first = false;
        }
        String string = builder.toString();
        if (string == null) {
            NameConverterUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java19api/NameConverterUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java19api/NameConverterUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertModuleName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

