/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sameReturnValue;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public final class SameReturnValueInspection
extends GlobalJavaBatchInspectionTool {
    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity == null) {
            SameReturnValueInspection.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            SameReturnValueInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SameReturnValueInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            SameReturnValueInspection.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            SameReturnValueInspection.$$$reportNull$$$0(4);
        }
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.isConstructor()) {
                return null;
            }
            if (refMethod.hasSuperMethods()) {
                return null;
            }
            String returnValue = refMethod.getReturnValueIfSame();
            if (returnValue != null) {
                PsiElement psiAnchor;
                UMethod method = refMethod.getUastElement();
                PsiType returnType = method.getReturnType();
                if (returnType == null || returnType.equalsToText("java.lang.Void")) {
                    return null;
                }
                String message = refMethod.getDerivedReferences().isEmpty() ? JavaAnalysisBundle.message((String)"inspection.same.return.value.problem.descriptor", (Object[])new Object[]{returnValue}) : (refMethod.hasBody() ? JavaAnalysisBundle.message((String)"inspection.same.return.value.problem.descriptor1", (Object[])new Object[]{returnValue}) : JavaAnalysisBundle.message((String)"inspection.same.return.value.problem.descriptor2", (Object[])new Object[]{returnValue}));
                UElement anchor = method.getUastAnchor();
                if (anchor != null && (psiAnchor = anchor.getSourcePsi()) != null) {
                    return new ProblemDescriptor[]{manager.createProblemDescriptor(psiAnchor, message, false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
                }
            }
        }
        return null;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        if (manager == null) {
            SameReturnValueInspection.$$$reportNull$$$0(5);
        }
        if (globalContext == null) {
            SameReturnValueInspection.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            SameReturnValueInspection.$$$reportNull$$$0(7);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(this){

            public void visitMethod(@NotNull RefMethod refMethod) {
                if (refMethod == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processor.getDescriptions((RefEntity)refMethod) == null) {
                    return;
                }
                if ("private".equals(refMethod.getAccessModifier())) {
                    return;
                }
                globalContext.enqueueDerivedMethodsProcessor(refMethod, derivedMethod -> {
                    processor.ignoreElement((RefEntity)refMethod);
                    return false;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/sameReturnValue/SameReturnValueInspection$1", "visitMethod"));
            }
        });
        return false;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
        if (string == null) {
            SameReturnValueInspection.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "SameReturnValue";
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new LocalSameReturnValueInspection(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/sameReturnValue/SameReturnValueInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/sameReturnValue/SameReturnValueInspection";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private static final class LocalSameReturnValueInspection
    extends AbstractBaseUastLocalInspectionTool {
        private final SameReturnValueInspection myGlobal;

        private LocalSameReturnValueInspection(SameReturnValueInspection global) {
            this.myGlobal = global;
        }

        public boolean runForWholeFile() {
            return true;
        }

        @NotNull
        public String getGroupDisplayName() {
            String string = this.myGlobal.getGroupDisplayName();
            if (string == null) {
                LocalSameReturnValueInspection.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getShortName() {
            String string = this.myGlobal.getShortName();
            if (string == null) {
                LocalSameReturnValueInspection.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
            if (holder == null) {
                LocalSameReturnValueInspection.$$$reportNull$$$0(2);
            }
            Class[] hint = new Class[]{UMethod.class};
            PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this){

                public boolean visitMethod(final @NotNull UMethod method) {
                    UElement anchor;
                    if (method == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((anchor = method.getUastAnchor()) == null) {
                        return true;
                    }
                    PsiElement psiAnchor = anchor.getSourcePsi();
                    if (psiAnchor == null) {
                        return true;
                    }
                    PsiMethod javaMethod = method.getJavaPsi();
                    PsiType returnType = javaMethod.getReturnType();
                    if (returnType == null || returnType.equalsToText("java.lang.Void")) {
                        return true;
                    }
                    if (javaMethod.findSuperMethods().length != 0 || PsiUtil.canBeOverridden((PsiMethod)javaMethod)) {
                        return true;
                    }
                    SmartList returnExpressions = new SmartList();
                    UExpression body = method.getUastBody();
                    if (body == null) {
                        return true;
                    }
                    body.accept((UastVisitor)new AbstractUastVisitor(this, (List)returnExpressions){
                        final /* synthetic */ List val$returnExpressions;
                        {
                            this.val$returnExpressions = list;
                        }

                        public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                            UExpression returnExpression;
                            if (node == null) {
                                LocalSameReturnValueInspection.1.$$$reportNull$$$0(0);
                            }
                            if (node.getJumpTarget() == method && (returnExpression = node.getReturnExpression()) != null) {
                                StreamEx.of((Stream)UastUtils.nonStructuralChildren((UExpression)returnExpression)).into((Collection)this.val$returnExpressions);
                            }
                            return super.visitReturnExpression(node);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/sameReturnValue/SameReturnValueInspection$LocalSameReturnValueInspection$1$1", "visitReturnExpression"));
                        }
                    });
                    if (returnExpressions.size() < 2) {
                        return true;
                    }
                    String returnValue = RefMethodImpl.createReturnValueTemplate((UExpression)((UExpression)returnExpressions.getFirst()));
                    if (returnValue != null && ContainerUtil.all((Collection)returnExpressions, returnExpression -> returnValue.equals(RefMethodImpl.createReturnValueTemplate((UExpression)returnExpression)))) {
                        String message = JavaAnalysisBundle.message((String)"inspection.same.return.value.problem.descriptor", (Object[])new Object[]{returnValue});
                        holder.registerProblem(psiAnchor, message, new LocalQuickFix[0]);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/sameReturnValue/SameReturnValueInspection$LocalSameReturnValueInspection$1", "visitMethod"));
                }
            }, (Class[])hint);
            if (psiElementVisitor == null) {
                LocalSameReturnValueInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/sameReturnValue/SameReturnValueInspection$LocalSameReturnValueInspection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupDisplayName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/sameReturnValue/SameReturnValueInspection$LocalSameReturnValueInspection";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "buildVisitor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

