/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.frontend.ui;

import com.intellij.ide.ui.NavBarLocation;
import com.intellij.ide.ui.UISettings;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public final class NavBarBorder
implements Border {
    private static final Color BORDER_COLOR = JBColor.namedColor((String)"NavBar.borderColor", (Color)new JBColor((Color)Gray.xCD, (Color)Gray.x51));
    private static final JBValue BW = new JBValue.UIInteger("NavBar.borderWidth", 1);

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        UISettings uiSettings = UISettings.getInstance();
        if (ExperimentalUI.isNewUI() && uiSettings.getShowNavigationBar() && uiSettings.getNavBarLocation() == NavBarLocation.TOP || !ExperimentalUI.isNewUI() && uiSettings.getShowMainToolbar()) {
            g.setColor(BORDER_COLOR);
            g.fillRect(x, y, width, BW.get());
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        UISettings settings = UISettings.getInstance();
        if (ExperimentalUI.isNewUI() && settings.getShowNavigationBar()) {
            if (settings.getNavBarLocation() == NavBarLocation.TOP) {
                return JBUI.CurrentTheme.NavBar.itemInsets();
            }
            return JBUI.CurrentTheme.StatusBar.Breadcrumbs.navBarInsets();
        }
        if (!settings.getShowMainToolbar()) {
            return JBUI.insets((int)1, (int)0, (int)1, (int)4);
        }
        return JBUI.insets((int)1, (int)0, (int)0, (int)4);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

