/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.codeInsight.metaLanguage;

import com.intellij.kotlin.jupyter.core.editor.codeInsight.metaLanguage.ReplEnumsKt;
import com.intellij.kotlin.jupyter.core.language.meta.psi.JKTMetaStatement;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlinx.jupyter.common.ReplEnum;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/codeInsight/metaLanguage/JKTMetaAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "intellij.kotlin.jupyter.core"})
public final class JKTMetaAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        JKTMetaStatement jKTMetaStatement = element instanceof JKTMetaStatement ? (JKTMetaStatement)element : null;
        if (jKTMetaStatement == null) {
            return;
        }
        JKTMetaStatement statement = jKTMetaStatement;
        ReplEnum<?> replEnum = ReplEnumsKt.getReplEnum(statement);
        if (replEnum == null) {
            return;
        }
        ReplEnum<?> replEnum2 = replEnum;
        String string = statement.getStatementId().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        ReplEnum.CodeInsightValue<?> codeInsightValue = replEnum2.valueOfOrNull(string);
        if (codeInsightValue == null) {
            return;
        }
        ReplEnum.CodeInsightValue<?> insightValue = codeInsightValue;
        String description = KotlinNotebookBundle.messageWithDefaultValue("jkt.meta.description." + insightValue.getName(), insightValue.getDescription(), new Object[0]);
        holder.newAnnotation(HighlightSeverity.INFORMATION, description).tooltip(description).range(new TextRange(PsiUtilsKt.getStartOffset((PsiElement)statement), PsiUtilsKt.getStartOffset((PsiElement)statement.getNewlineOrEof()))).create();
    }
}

