/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.find;

import com.intellij.kotlin.jupyter.core.editor.find.FindUsagesHandlerKt;
import com.intellij.kotlin.jupyter.core.editor.find.NotebookUsagesContributorFactory;
import com.intellij.kotlin.jupyter.core.editor.find.ProvidedLibrariesReferencesProducer;
import com.intellij.kotlin.jupyter.core.editor.find.PsiAwareKt;
import com.intellij.kotlin.jupyter.core.editor.find.PsiRefHelpersKt;
import com.intellij.kotlin.jupyter.core.editor.find.ReferenceSearchStrategy;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SingleTargetRequestResultProcessor;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J-\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0004\u00a2\u0006\u0002\u0010\u000eJ-\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0004\u00a2\u0006\u0002\u0010\u000eJ-\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0004\u00a2\u0006\u0002\u0010\u000e\u0082\u0001\u0001\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/find/NotebookUsagesContributor;", "", "<init>", "()V", "findUsageForElement", "", "Lcom/intellij/psi/PsiElement;", "scope", "Lcom/intellij/openapi/vfs/VirtualFile;", "targetElement", "searchInSourcesScope", "", "isFromDSLibs", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/psi/PsiElement;Z)[Lcom/intellij/psi/PsiElement;", "searchWithCompiledCellScope", "searchProvidedLibrariesUsagesInNotebook", "Lcom/intellij/kotlin/jupyter/core/editor/find/NotebookUsagesContributorFactory;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nusagesContributors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 usagesContributors.kt\ncom/intellij/kotlin/jupyter/core/editor/find/NotebookUsagesContributor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n37#2,2:142\n37#2,2:145\n37#2,2:161\n37#2,2:167\n67#3:144\n1642#4,10:147\n1915#4:157\n1916#4:159\n1652#4:160\n1586#4:163\n1661#4,3:164\n1#5:158\n*S KotlinDebug\n*F\n+ 1 usagesContributors.kt\ncom/intellij/kotlin/jupyter/core/editor/find/NotebookUsagesContributor\n*L\n51#1:142,2\n66#1:145,2\n90#1:161,2\n92#1:167,2\n62#1:144\n87#1:147,10\n87#1:157\n87#1:159\n87#1:160\n92#1:163\n92#1:164,3\n87#1:158\n*E\n"})
public abstract sealed class NotebookUsagesContributor
permits NotebookUsagesContributorFactory {
    private NotebookUsagesContributor() {
    }

    private final Set<PsiElement> findUsageForElement(VirtualFile scope, PsiElement targetElement) {
        Project project = targetElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return PsiAwareKt.searchForElementDeclarationOrUsages(project, FindUsagesHandlerKt.adjustElement(targetElement), scope, ReferenceSearchStrategy.REFERENCES);
    }

    @Nullable
    protected final PsiElement[] searchInSourcesScope(@NotNull VirtualFile scope, @NotNull PsiElement targetElement, boolean isFromDSLibs) {
        PsiElement[] psiElementArray;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        if (!IsKotlinNotebookKt.isInsideKotlinNotebookFile(targetElement)) {
            return null;
        }
        Set<PsiElement> set = this.findUsageForElement(scope, targetElement);
        if (set != null) {
            Collection $this$toTypedArray$iv = set;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            psiElementArray = thisCollection$iv.toArray(new PsiElement[0]);
        } else {
            psiElementArray = null;
        }
        return psiElementArray;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final PsiElement[] searchWithCompiledCellScope(@NotNull VirtualFile scope, @NotNull PsiElement targetElement, boolean isFromDSLibs) {
        PsiElement[] psiElementArray;
        Object it;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        PsiElement adjustedElement = null;
        adjustedElement = targetElement;
        Project project = targetElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiFile psiFile = UtilKt.findPsiFile(scope, project);
        JupyterFile jupyterFile = psiFile instanceof JupyterFile ? (JupyterFile)psiFile : null;
        if (jupyterFile == null) {
            return null;
        }
        JupyterFile asPsiFile = jupyterFile;
        PsiElement psiElement = FindUsagesHandlerKt.tryResolveCompiledDeclarationInNotebook(targetElement, asPsiFile);
        if (psiElement != null) {
            it = psiElement;
            boolean bl = false;
            adjustedElement = it;
        }
        Set<PsiElement> set = this.findUsageForElement(scope, adjustedElement);
        if (set != null) {
            void $this$parentOfType$iv;
            it = set;
            boolean bl = false;
            PsiElement psiElement2 = adjustedElement;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType = false;
            KtDeclaration ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtDeclaration.class, (boolean)false);
            PsiElement enclosingDeclaration = ktDeclaration != null ? (PsiElement)ktDeclaration : adjustedElement;
            Object object = enclosingDeclaration.getContainingFile();
            boolean bl2 = object != null && (object = object.getName()) != null ? !StringsKt.endsWith$default((String)object, (String)"class", (boolean)false, (int)2, null) : false;
            if (bl2) {
                it.add(enclosingDeclaration);
            }
            Collection $this$toTypedArray$iv = (Collection)it;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            psiElementArray = thisCollection$iv.toArray(new PsiElement[0]);
        } else {
            psiElementArray = null;
        }
        return psiElementArray;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final PsiElement[] searchProvidedLibrariesUsagesInNotebook(@NotNull VirtualFile scope, @NotNull PsiElement targetElement, boolean isFromDSLibs) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        Project project = targetElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile psiFile = UtilKt.findPsiFile(scope, project2);
        JupyterFile jupyterFile = psiFile instanceof JupyterFile ? (JupyterFile)psiFile : null;
        if (jupyterFile == null) {
            return null;
        }
        JupyterFile asPsiFile = jupyterFile;
        SingleTargetRequestResultProcessor singleTargetRequestResultProcessor = new SingleTargetRequestResultProcessor(targetElement);
        ProvidedLibrariesReferencesProducer refsProcessor = new ProvidedLibrariesReferencesProducer();
        TextOccurenceProcessor processor = (arg_0, arg_1) -> NotebookUsagesContributor.searchProvidedLibrariesUsagesInNotebook$lambda$0(singleTargetRequestResultProcessor, refsProcessor, arg_0, arg_1);
        PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiSearchHelper, (String)"getInstance(...)");
        PsiSearchHelper helper = psiSearchHelper;
        String goalText = FindUsagesHandlerKt.adjustElement(targetElement).getText();
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)project2);
        PsiElement elemUnderCaret = UtilKt.retrieveElementUnderCaret((PsiFile)asPsiFile);
        if (isFromDSLibs || PsiRefHelpersKt.isItGeneratedNameInsideLambdaCall(targetElement, elemUnderCaret)) {
            PsiElement psiElement = elemUnderCaret;
            list = CollectionsKt.listOfNotNull((Object)(psiElement != null ? psiElement.getContainingFile() : null));
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = UtilKt.getNotebookCells((PsiFile)asPsiFile);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsiElement it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                JupyterPsiCell it = (JupyterPsiCell)element$iv$iv;
                boolean bl2 = false;
                List list2 = injectedManager.getInjectedPsiFiles((PsiElement)it);
                if ((list2 != null && (list2 = (Pair)CollectionsKt.firstOrNull((List)list2)) != null ? (PsiElement)((Pair)list2).first : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List files2 = list;
        if (files2.isEmpty()) {
            return null;
        }
        Collection $this$toTypedArray$iv = files2;
        boolean $i$f$toTypedArray = false;
        Iterable thisCollection$iv = $this$toTypedArray$iv;
        LocalSearchScope currentLocalSearchScope = new LocalSearchScope(thisCollection$iv.toArray(new PsiElement[0]));
        helper.processElementsWithWord(processor, (SearchScope)currentLocalSearchScope, goalText, (short)255, true, false);
        Iterable $this$map$iv = refsProcessor.getFoundRefs();
        boolean $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (PsiReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getElement());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiElement[0]);
    }

    private static final boolean searchProvidedLibrariesUsagesInNotebook$lambda$0(SingleTargetRequestResultProcessor $singleTargetRequestResultProcessor, ProvidedLibrariesReferencesProducer $refsProcessor, PsiElement element, int offsetInElement) {
        PsiElement psiElement = element;
        Intrinsics.checkNotNull((Object)psiElement);
        return $singleTargetRequestResultProcessor.processTextOccurrence(psiElement, offsetInElement, (Processor)$refsProcessor);
    }

    public /* synthetic */ NotebookUsagesContributor(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

