/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.projectWizard;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileTypeIcon;
import com.intellij.kotlin.jupyter.core.language.JupyterKotlinFileType;
import com.intellij.kotlin.jupyter.core.projectWizard.KotlinNotebookWelcomeTabFactoryKt;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.nio.file.Path;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010!\u001a\u00020\"2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010#\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0015H\u0016J\b\u0010%\u001a\u00020\"H\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R%\u0010\n\u001a\f0\u0005\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\r\u0010\u0007R\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\t\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lcom/intellij/kotlin/jupyter/core/projectWizard/KotlinNotebookRootType;", "Lcom/intellij/ide/scratch/RootType;", "<init>", "()V", "notebookNameSuffix", "", "getNotebookNameSuffix", "()Ljava/lang/String;", "notebookNameSuffix$delegate", "Lkotlin/Lazy;", "rootPathString", "Lorg/jetbrains/annotations/SystemIndependent;", "Lorg/jetbrains/annotations/NotNull;", "getRootPathString", "rootPathString$delegate", "rootPath", "Ljava/nio/file/Path;", "getRootPath", "()Ljava/nio/file/Path;", "rootPath$delegate", "rootVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRootVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "rootVirtualFile$delegate", "patchIcon", "Ljavax/swing/Icon;", "baseIcon", "file", "flags", "", "project", "Lcom/intellij/openapi/project/Project;", "containsFile", "", "isIgnored", "element", "isHidden", "intellij.kotlin.jupyter.core"})
public final class KotlinNotebookRootType
extends RootType {
    @NotNull
    private final Lazy notebookNameSuffix$delegate = LazyKt.lazy(KotlinNotebookRootType::notebookNameSuffix_delegate$lambda$0);
    @NotNull
    private final Lazy rootPathString$delegate = LazyKt.lazy(() -> KotlinNotebookRootType.rootPathString_delegate$lambda$0(this));
    @NotNull
    private final Lazy rootPath$delegate = LazyKt.lazy(() -> KotlinNotebookRootType.rootPath_delegate$lambda$0(this));
    @NotNull
    private final Lazy rootVirtualFile$delegate = LazyKt.lazy(() -> KotlinNotebookRootType.rootVirtualFile_delegate$lambda$0(this));

    public KotlinNotebookRootType() {
        super("kotlinNotebook", KotlinNotebookBundle.message("kotlin.notebook.root.type.display.name", new Object[0]));
    }

    private final String getNotebookNameSuffix() {
        Lazy lazy = this.notebookNameSuffix$delegate;
        return (String)lazy.getValue();
    }

    private final String getRootPathString() {
        Lazy lazy = this.rootPathString$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final Path getRootPath() {
        Lazy lazy = this.rootPath$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Path)object;
    }

    @NotNull
    public final VirtualFile getRootVirtualFile() {
        Lazy lazy = this.rootVirtualFile$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (VirtualFile)object;
    }

    @NotNull
    public Icon patchIcon(@NotNull Icon baseIcon, @NotNull VirtualFile file, int flags, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)baseIcon, (String)"baseIcon");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isDirectory()) {
            return baseIcon;
        }
        Project project2 = project;
        if (Intrinsics.areEqual((Object)(project2 != null ? project2.getName() : null), (Object)"KotlinNotebook")) {
            return baseIcon;
        }
        return (Icon)new ScratchFileTypeIcon(baseIcon);
    }

    public boolean containsFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        if (this.isHidden()) {
            return false;
        }
        Path filePath = Path.of(file.getPath(), new String[0]);
        return filePath.startsWith(this.getRootPath());
    }

    public boolean isIgnored(@NotNull Project project, @NotNull VirtualFile element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!VirtualFileUtil.isFile((VirtualFile)element)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)project.getName(), (Object)"KotlinNotebook")) {
            return true;
        }
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return !StringsKt.endsWith$default((String)string, (String)this.getNotebookNameSuffix(), (boolean)false, (int)2, null);
    }

    public boolean isHidden() {
        return !KotlinNotebookWelcomeTabFactoryKt.getKotlinNotebookWelcomeFeaturesEnabled();
    }

    private static final String notebookNameSuffix_delegate$lambda$0() {
        String string = JupyterKotlinFileType.INSTANCE.getDefaultExtension().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return "." + string;
    }

    private static final String rootPathString_delegate$lambda$0(KotlinNotebookRootType this$0) {
        return ScratchFileService.getInstance().getRootPath((RootType)this$0);
    }

    private static final Path rootPath_delegate$lambda$0(KotlinNotebookRootType this$0) {
        return Path.of(this$0.getRootPathString(), new String[0]);
    }

    private static final VirtualFile rootVirtualFile_delegate$lambda$0(KotlinNotebookRootType this$0) {
        String path2 = this$0.getRootPathString();
        return VfsUtil.createDirectories((String)path2);
    }
}

