/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.debug;

import java.io.File;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"collectThreadDump", "", "dumpThreadsToFile", "", "file", "Ljava/io/File;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nThreadDumpUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadDumpUtil.kt\norg/jetbrains/kotlinx/jupyter/debug/ThreadDumpUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1068#2:54\n*S KotlinDebug\n*F\n+ 1 ThreadDumpUtil.kt\norg/jetbrains/kotlinx/jupyter/debug/ThreadDumpUtilKt\n*L\n19#1:54\n*E\n"})
public final class ThreadDumpUtilKt {
    @NotNull
    public static final String collectThreadDump() {
        StringBuilder stringBuilder;
        StringBuilder $this$collectThreadDump_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
        $this$collectThreadDump_u24lambda_u240.append("Thread dump: ");
        $this$collectThreadDump_u24lambda_u240.append(ZonedDateTime.now());
        $this$collectThreadDump_u24lambda_u240.append('\n');
        Iterable $this$sortedBy$iv = all.entrySet();
        boolean $i$f$sortedBy = false;
        for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((Thread)it.getKey()).getName());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((Thread)it.getKey()).getName())));
            }
        })) {
            Thread thread = (Thread)entry.getKey();
            StackTraceElement[] stack = (StackTraceElement[])entry.getValue();
            $this$collectThreadDump_u24lambda_u240.append("\"" + thread.getName() + "\" Id=" + thread.getId() + " " + (thread.isDaemon() ? "daemon " : "") + "prio=" + thread.getPriority() + " state=" + thread.getState());
            $this$collectThreadDump_u24lambda_u240.append('\n');
            Intrinsics.checkNotNull((Object)stack);
            for (StackTraceElement traceElement : stack) {
                StringBuilder stringBuilder2;
                $this$collectThreadDump_u24lambda_u240.append("    at ");
                $this$collectThreadDump_u24lambda_u240.append(traceElement.getClassName());
                $this$collectThreadDump_u24lambda_u240.append('.');
                $this$collectThreadDump_u24lambda_u240.append(traceElement.getMethodName());
                if (traceElement.isNativeMethod()) {
                    stringBuilder2 = $this$collectThreadDump_u24lambda_u240.append("(Native Method)");
                } else {
                    String string = traceElement.getFileName();
                    if (string == null) {
                        string = "Unknown Source";
                    }
                    String file = string;
                    String line = traceElement.getLineNumber() >= 0 ? ":" + traceElement.getLineNumber() : "";
                    $this$collectThreadDump_u24lambda_u240.append('(');
                    $this$collectThreadDump_u24lambda_u240.append(file);
                    $this$collectThreadDump_u24lambda_u240.append(line);
                    stringBuilder2 = $this$collectThreadDump_u24lambda_u240.append(')');
                }
                $this$collectThreadDump_u24lambda_u240.append('\n');
            }
            $this$collectThreadDump_u24lambda_u240.append('\n');
        }
        return stringBuilder.toString();
    }

    public static final void dumpThreadsToFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        file.getParentFile().mkdirs();
        FilesKt.writeText$default((File)file, (String)ThreadDumpUtilKt.collectThreadDump(), null, (int)2, null);
    }
}

