/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J8\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000fH\u0007J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J(\u0010\u001a\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u001c\u001a\u00020\u001d2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/codeInsight/lookup/LookupUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "insertLookupInDocumentWindowIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffset", "prefix", "lookupString", "", "insertLookupInInjectedDocument", "document", "Lcom/intellij/injected/editor/DocumentWindow;", "getCaseCorrectedLookupString", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "getInjectedDocument", "offset", "insertLookupInDocument", "Lcom/intellij/openapi/editor/Document;", "performGuardedChange", "", "action", "Ljava/lang/Runnable;", "intellij.platform.analysis.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLookupUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookupUtil.kt\ncom/intellij/codeInsight/lookup/LookupUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,128:1\n1#2:129\n13#3:130\n*S KotlinDebug\n*F\n+ 1 LookupUtil.kt\ncom/intellij/codeInsight/lookup/LookupUtil\n*L\n20#1:130\n*E\n"})
public final class LookupUtil {
    @NotNull
    public static final LookupUtil INSTANCE = new LookupUtil();
    @NotNull
    private static final Logger LOG;

    private LookupUtil() {
    }

    @JvmStatic
    public static final int insertLookupInDocumentWindowIfNeeded(@NotNull Project project, @NotNull Editor editor, int caretOffset, int prefix, @NotNull String lookupString) {
        int n;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)lookupString, (String)"lookupString");
        DocumentWindow injectedDocument = INSTANCE.getInjectedDocument(project, editor, caretOffset);
        if (injectedDocument != null) {
            n = INSTANCE.insertLookupInInjectedDocument(project, injectedDocument, caretOffset, prefix, editor, lookupString);
        } else {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            n = INSTANCE.insertLookupInDocument(caretOffset, document, prefix, lookupString);
        }
        return n;
    }

    private final int insertLookupInInjectedDocument(Project project, DocumentWindow document, int caretOffset, int prefix, Editor editor, String lookupString) {
        int n;
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)document);
        int offset = document.hostToInjected(caretOffset);
        int lookupStart = Math.min(offset, Math.max(offset - prefix, 0));
        int diff = -1;
        if (file != null) {
            List list = InjectedLanguageManager.getInstance((Project)project).intersectWithAllEditableFragments(file, TextRange.create((int)lookupStart, (int)offset));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"intersectWithAllEditableFragments(...)");
            List ranges = list;
            if (!((Collection)ranges).isEmpty()) {
                diff = ((TextRange)ranges.get(0)).getStartOffset() - lookupStart;
                if (ranges.size() == 1 && diff == 0) {
                    diff = -1;
                }
            }
        }
        if (diff == -1) {
            Document document2 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            n = this.insertLookupInDocument(caretOffset, document2, prefix, lookupString);
        } else {
            String string;
            if (diff == 0) {
                string = lookupString;
            } else {
                String string2 = lookupString.substring(diff);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            String lookupSubstring = string;
            int injectedOffset = this.insertLookupInDocument(offset, (Document)document, prefix - diff, lookupSubstring);
            n = document.injectedToHost(injectedOffset);
        }
        return n;
    }

    @JvmStatic
    @NotNull
    public static final String getCaseCorrectedLookupString(@NotNull LookupElement item, @NotNull PrefixMatcher prefixMatcher, @NotNull String prefix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String string2 = item.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLookupString(...)");
        String lookupString = string2;
        if (item.isCaseSensitive()) {
            return lookupString;
        }
        int length = prefix.length();
        if (length == 0 || !prefixMatcher.prefixMatches(prefix)) {
            return lookupString;
        }
        boolean isAllLower = true;
        boolean isAllUpper = true;
        boolean sameCase = true;
        int i = 0;
        while (i < length && (isAllLower || isAllUpper || sameCase)) {
            char c = prefix.charAt(i);
            boolean isLower = Character.isLowerCase(c);
            boolean isUpper = Character.isUpperCase(c);
            if (!isLower && !isUpper) {
                ++i;
                continue;
            }
            isAllLower = isAllLower && isLower;
            isAllUpper = isAllUpper && isUpper;
            sameCase = sameCase && i < lookupString.length() && isLower == Character.isLowerCase(lookupString.charAt(i));
            ++i;
        }
        if (sameCase) {
            return lookupString;
        }
        if (isAllLower) {
            String string3 = StringUtil.toLowerCase((String)lookupString);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            return string3;
        }
        if (isAllUpper) {
            String string4 = StringUtil.toUpperCase((String)lookupString);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
        } else {
            string = lookupString;
        }
        return string;
    }

    private final DocumentWindow getInjectedDocument(Project project, Editor editor, int offset) {
        PsiFile hostFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (hostFile != null) {
            List list = InjectedLanguageManager.getInstance((Project)project).getCachedInjectedDocumentsInRange(hostFile, TextRange.create((int)offset, (int)offset));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCachedInjectedDocumentsInRange(...)");
            List injected = list;
            for (DocumentWindow documentWindow : injected) {
                if (!documentWindow.isValid() || !documentWindow.containsRange(offset, offset)) continue;
                return documentWindow;
            }
        }
        return null;
    }

    private final int insertLookupInDocument(int caretOffset, Document document, int prefix, String lookupString) {
        int lookupStart = Math.min(caretOffset, Math.max(caretOffset - prefix, 0));
        int len = document.getTextLength();
        LOG.assertTrue(0 <= lookupStart ? lookupStart <= len : false, (Object)("ls: " + lookupStart + " caret: " + caretOffset + " prefix:" + prefix + " doc: " + len));
        LOG.assertTrue(0 <= caretOffset ? caretOffset <= len : false, (Object)("co: " + caretOffset + " doc: " + len));
        document.replaceString(lookupStart, caretOffset, (CharSequence)lookupString);
        return lookupStart + lookupString.length();
    }

    @JvmStatic
    public static final void performGuardedChange(@Nullable Editor editor, @NotNull Runnable action) {
        LookupEx lookup;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Editor editor2 = editor;
        if (editor2 != null) {
            Editor p0 = editor2;
            boolean bl = false;
            v1 = LookupManager.getActiveLookup((Editor)p0);
        } else {
            v1 = lookup = null;
        }
        if (lookup == null) {
            action.run();
        } else {
            lookup.performGuardedChange(action);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LookupUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

