/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.appendonlylog;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.platform.util.io.storages.StorageFactory;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLogOverMMappedFile;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorageFactory;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.VersionUpdatedException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class AppendOnlyLogFactory
implements StorageFactory<AppendOnlyLogOverMMappedFile> {
    private static final Logger LOG = Logger.getInstance(AppendOnlyLogFactory.class);
    public static final int DEFAULT_PAGE_SIZE = 0x400000;
    private final int pageSize;
    private final int expectedDataVersion;
    private final boolean ensureDataVersion;
    private final boolean failInsteadOfRecovery;
    private final boolean eagerlyCheckFileCompatibility;
    private final boolean cleanFileIfIncompatible;

    private AppendOnlyLogFactory(int pageSize, boolean ensureDataVersion, int expectedDataVersion, boolean failInsteadOfRecovery, boolean eagerlyCheckFileCompatibility, boolean cleanFileIfIncompatible) {
        this.pageSize = pageSize;
        this.expectedDataVersion = expectedDataVersion;
        this.ensureDataVersion = ensureDataVersion;
        this.eagerlyCheckFileCompatibility = eagerlyCheckFileCompatibility;
        this.failInsteadOfRecovery = failInsteadOfRecovery;
        this.cleanFileIfIncompatible = cleanFileIfIncompatible;
    }

    public static AppendOnlyLogFactory withDefaults() {
        return new AppendOnlyLogFactory(0x400000, false, 0, false, true, false);
    }

    public AppendOnlyLogFactory pageSize(int pageSize) {
        return new AppendOnlyLogFactory(pageSize, this.ensureDataVersion, this.expectedDataVersion, this.failInsteadOfRecovery, this.eagerlyCheckFileCompatibility, this.cleanFileIfIncompatible);
    }

    public AppendOnlyLogFactory failIfDataFormatVersionNotMatch(int expectedDataVersion) {
        return new AppendOnlyLogFactory(this.pageSize, true, expectedDataVersion, this.failInsteadOfRecovery, this.eagerlyCheckFileCompatibility, this.cleanFileIfIncompatible);
    }

    public AppendOnlyLogFactory ignoreDataFormatVersion() {
        return new AppendOnlyLogFactory(this.pageSize, false, 0, this.failInsteadOfRecovery, this.eagerlyCheckFileCompatibility, this.cleanFileIfIncompatible);
    }

    public AppendOnlyLogFactory dontRecoverFailInstead() {
        return new AppendOnlyLogFactory(this.pageSize, this.ensureDataVersion, this.expectedDataVersion, true, this.eagerlyCheckFileCompatibility, this.cleanFileIfIncompatible);
    }

    public AppendOnlyLogFactory checkIfFileCompatibleEagerly(boolean eagerlyCheckCompatibility) {
        return new AppendOnlyLogFactory(this.pageSize, this.ensureDataVersion, this.expectedDataVersion, this.failInsteadOfRecovery, eagerlyCheckCompatibility, this.cleanFileIfIncompatible);
    }

    public AppendOnlyLogFactory cleanIfFileIncompatible() {
        return new AppendOnlyLogFactory(this.pageSize, this.ensureDataVersion, this.expectedDataVersion, this.failInsteadOfRecovery, true, true);
    }

    public AppendOnlyLogFactory failIfFileIncompatible() {
        return new AppendOnlyLogFactory(this.pageSize, this.ensureDataVersion, this.expectedDataVersion, this.failInsteadOfRecovery, true, false);
    }

    @Override
    @NotNull
    public AppendOnlyLogOverMMappedFile open(@NotNull Path storagePath) throws IOException {
        if (storagePath == null) {
            AppendOnlyLogFactory.$$$reportNull$$$0(0);
        }
        if (this.eagerlyCheckFileCompatibility) {
            long size;
            long l = size = Files.exists(storagePath, new LinkOption[0]) ? Files.size(storagePath) : 0L;
            if (size > 0L) {
                ByteBuffer buffer = ByteBuffer.allocate(64).order(ByteOrder.nativeOrder()).clear();
                try (FileChannel channel = FileChannel.open(storagePath, StandardOpenOption.READ);){
                    int actuallyRead = channel.read(buffer);
                    if (actuallyRead != 64) {
                        throw new CorruptedException("[" + String.valueOf(storagePath) + "]: file is not empty, but < HEADER_SIZE(=64)");
                    }
                    AppendOnlyLogOverMMappedFile.checkFileParamsCompatible(storagePath, buffer, this.pageSize);
                }
                catch (IOException ex) {
                    if (this.cleanFileIfIncompatible) {
                        LOG.warn("[" + String.valueOf(storagePath) + "] is incompatible with current format -> delete it, and pretend never seen it incompatible (incompatibility: " + ex.getMessage() + ")");
                        NioFiles.deleteRecursively((Path)storagePath);
                    }
                    throw ex;
                }
            }
        }
        MMappedFileStorageFactory mappedFileStorageFactory = MMappedFileStorageFactory.withDefaults().pageSize(this.pageSize);
        AppendOnlyLogOverMMappedFile appendOnlyLogOverMMappedFile = (AppendOnlyLogOverMMappedFile)mappedFileStorageFactory.wrapStorageSafely(storagePath, storage -> {
            AppendOnlyLogOverMMappedFile appendOnlyLog = new AppendOnlyLogOverMMappedFile((MMappedFileStorage)storage);
            if (this.failInsteadOfRecovery && appendOnlyLog.wasRecoveryNeeded()) {
                throw new CorruptedException("[" + String.valueOf(storagePath.toAbsolutePath()) + "] wasn't properly closed, and recovery is prohibited -> fail");
            }
            if (this.ensureDataVersion) {
                int dataFormatVersion = appendOnlyLog.getDataVersion();
                if (dataFormatVersion == 0 && appendOnlyLog.isEmpty()) {
                    appendOnlyLog.setDataVersion(this.expectedDataVersion);
                } else if (dataFormatVersion != this.expectedDataVersion) {
                    throw new VersionUpdatedException(storagePath, (Object)this.expectedDataVersion, (Object)dataFormatVersion);
                }
            }
            return appendOnlyLog;
        });
        if (appendOnlyLogOverMMappedFile == null) {
            AppendOnlyLogFactory.$$$reportNull$$$0(1);
        }
        return appendOnlyLogOverMMappedFile;
    }

    public String toString() {
        return "AppendOnlyLogFactory{pageSize=" + this.pageSize + (String)(this.ensureDataVersion ? ", ensure data version: " + this.expectedDataVersion : "") + ", failInsteadOfRecovery=" + this.failInsteadOfRecovery + ", eagerlyCheckFileCompatibility=" + this.eagerlyCheckFileCompatibility + ", cleanFileIfIncompatible=" + this.cleanFileIfIncompatible + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/util/io/storages/appendonlylog/AppendOnlyLogFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/util/io/storages/appendonlylog/AppendOnlyLogFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "open";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

