/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.ide.highlighter.custom.CustomFileTypeLexer;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.lang.Language;
import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.lang.cacheBuilder.DefaultWordsScanner;
import com.intellij.lang.cacheBuilder.SimpleWordsScanner;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdIndexers;
import com.intellij.psi.impl.cache.impl.id.ScanningIdIndexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.CharArrayUtil;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdTableBuilding {
    private IdTableBuilding() {
    }

    @Nullable
    public static IdIndexer getFileTypeIndexer(final @NotNull FileType fileType) {
        IdIndexer extIndexer;
        if (fileType == null) {
            IdTableBuilding.$$$reportNull$$$0(0);
        }
        if ((extIndexer = IdTableBuilding.getIndexer(fileType)) != null) {
            return extIndexer;
        }
        WordsScanner customWordsScanner = CacheBuilderRegistry.getInstance().getCacheBuilder(fileType);
        if (customWordsScanner != null) {
            return IdTableBuilding.createDefaultIndexer(customWordsScanner);
        }
        if (fileType instanceof LanguageFileType) {
            Language lang = ((LanguageFileType)fileType).getLanguage();
            WordsScanner scanner = LanguageFindUsages.getWordsScanner((Language)lang);
            if (scanner == null) {
                scanner = new SimpleWordsScanner();
            }
            return IdTableBuilding.createDefaultIndexer(scanner);
        }
        if (fileType instanceof CustomSyntaxTableFileType) {
            return new ScanningIdIndexer(){

                @Override
                protected WordsScanner createScanner() {
                    return IdTableBuilding.createCustomFileTypeScanner(((CustomSyntaxTableFileType)fileType).getSyntaxTable());
                }
            };
        }
        return null;
    }

    private static IdIndexer getIndexer(@NotNull FileType fileType) {
        if (fileType == null) {
            IdTableBuilding.$$$reportNull$$$0(1);
        }
        if (fileType == PlainTextFileType.INSTANCE && FileBasedIndex.IGNORE_PLAIN_TEXT_FILES) {
            return null;
        }
        return (IdIndexer)IdIndexers.INSTANCE.forFileType(fileType);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static IdIndexer createDefaultIndexer(final @NotNull WordsScanner scanner) {
        if (scanner == null) {
            IdTableBuilding.$$$reportNull$$$0(2);
        }
        return new ScanningIdIndexer(){

            @Override
            protected WordsScanner createScanner() {
                return scanner;
            }
        };
    }

    @Contract(value="_ -> new")
    @NotNull
    public static WordsScanner createCustomFileTypeScanner(@NotNull SyntaxTable syntaxTable) {
        if (syntaxTable == null) {
            IdTableBuilding.$$$reportNull$$$0(3);
        }
        return new DefaultWordsScanner((Lexer)new CustomFileTypeLexer(syntaxTable, true), TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.IDENTIFIER}), TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT}), TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.STRING, CustomHighlighterTokenType.SINGLE_QUOTED_STRING}));
    }

    public static void scanWords(ScanWordProcessor processor, CharSequence chars, int startOffset, int endOffset) {
        IdTableBuilding.scanWords(processor, chars, CharArrayUtil.fromSequenceWithoutCopying((CharSequence)chars), startOffset, endOffset, false);
    }

    public static void scanWords(ScanWordProcessor processor, CharSequence chars, char @Nullable [] charArray, int startOffset, int endOffset, boolean mayHaveEscapes) {
        IdTableBuilding.scanWords(processor, chars, charArray, startOffset, endOffset, mayHaveEscapes, IdTableBuilding::isWordCodePoint);
    }

    public static boolean isWordCodePoint(int codePoint) {
        return codePoint >= 97 && codePoint <= 122 || codePoint >= 65 && codePoint <= 90 || codePoint >= 48 && codePoint <= 57 || Character.isJavaIdentifierStart(codePoint) && codePoint != 36;
    }

    public static void scanWords(ScanWordProcessor processor, CharSequence chars, char @Nullable [] charArray, int startOffset, int endOffset, boolean mayHaveEscapes, IntPredicate isWordCodePoint) {
        int index = startOffset;
        boolean hasArray = charArray != null;
        block0: while (true) {
            int startIndex = index;
            while (index < endOffset) {
                int codePoint = hasArray ? Character.codePointAt(charArray, index, endOffset) : Character.codePointAt(chars, index);
                index += Character.charCount(codePoint);
                if (!isWordCodePoint.test(codePoint)) {
                    if (!mayHaveEscapes || codePoint == 92) {
                        // empty if block
                    }
                    startIndex = ++index;
                    continue;
                }
                int endIndex = index;
                while (index < endOffset) {
                    int codePoint2 = hasArray ? Character.codePointAt(charArray, index, endOffset) : Character.codePointAt(chars, index);
                    index += Character.charCount(codePoint2);
                    if (!isWordCodePoint.test(codePoint2)) break;
                    endIndex = index;
                }
                if (endIndex - startIndex > 100) continue block0;
                processor.run(chars, charArray, startIndex, endIndex);
                continue block0;
            }
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scanner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxTable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdTableBuilding";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileTypeIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createDefaultIndexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomFileTypeScanner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ScanWordProcessor {
        public void run(CharSequence var1, char @Nullable [] var2, int var3, int var4);
    }
}

