/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.model.search.SearchParameters;
import com.intellij.model.search.Searcher;
import com.intellij.model.search.impl.ParametersRequest;
import com.intellij.model.search.impl.QueryRequest;
import com.intellij.model.search.impl.Requests;
import com.intellij.model.search.impl.RequestsKt;
import com.intellij.model.search.impl.SearchersQuery;
import com.intellij.model.search.impl.XQuery;
import com.intellij.model.search.impl.XResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.impl.search.HelperKt;
import com.intellij.psi.impl.search.Layer;
import com.intellij.psi.impl.search.LayerResult;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.ReceiveChannel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u0005\u0012\u0004\u0012\u0002H\u00060\u00020\u0004\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005H\u0000\u001a,\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u000e\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a2\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0015\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00060\u001bH\u0007\u001a6\u0010\u0014\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u001b2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00060\u001eH\u0007\u001a<\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060 \"\u0004\b\u0000\u0010\u00062\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0014\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u001b0#H\u0002\u001aL\u0010$\u001a\u00020\n\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010\u00062\u0006\u0010!\u001a\u00020\u00112\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H\u00060'2\u001a\u0010(\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u001b\u0012\u0004\u0012\u00020\n0)H\u0002\u001a.\u0010*\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u001b0#\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005H\u0002\u001a.\u0010+\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u001b0#\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005H\u0002\u001aD\u0010,\u001a\u00020\u001c\"\u0004\b\u0000\u0010\u00062\u0006\u0010!\u001a\u00020\u00112\u0016\u0010-\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00060.0#2\u0014\u0010\u001d\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u0002H\u00060/0\u001eH\u0002\u001ad\u00100\u001a\u00020\u001c\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010\u00062\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u0002H%0\u001b2.\u00101\u001a*\u0012&\u0012$\u0012\u0004\u0012\u0002H%\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060#0)j\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H\u0006`20#2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00060\u001eH\u0002\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0010\u001a\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00063"}, d2={"searchersExtension", "Lcom/intellij/openapi/util/ClassExtension;", "Lcom/intellij/model/search/Searcher;", "searchers", "", "Lcom/intellij/model/search/SearchParameters;", "R", "", "parameters", "registerSearcherForTesting", "", "key", "Ljava/lang/Class;", "searcher", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "indicatorOrEmpty", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getIndicatorOrEmpty", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "runSearch", "Lkotlinx/coroutines/channels/ReceiveChannel;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "query", "Lcom/intellij/util/Query;", "", "processor", "Lcom/intellij/util/Processor;", "buildLayer", "Lcom/intellij/psi/impl/search/Layer;", "progress", "queries", "", "handleParamRequest", "B", "request", "Lcom/intellij/model/search/impl/ParametersRequest;", "queue", "Lkotlin/Function1;", "collectSearchRequests", "doCollectSearchRequests", "processQueryRequests", "requests", "Lcom/intellij/model/search/impl/QueryRequest;", "Lcom/intellij/model/search/impl/XResult;", "runQueryRequest", "transformations", "Lcom/intellij/model/search/impl/Transformation;", "intellij.platform.indexing.impl"})
@SourceDebugExtension(value={"SMAP\nhelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 helper.kt\ncom/intellij/psi/impl/search/HelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,321:1\n1525#2:322\n1557#2,3:323\n1560#2,3:333\n383#3,7:326\n*S KotlinDebug\n*F\n+ 1 helper.kt\ncom/intellij/psi/impl/search/HelperKt\n*L\n286#1:322\n286#1:323,3\n286#1:333,3\n286#1:326,7\n*E\n"})
public final class HelperKt {
    @NotNull
    private static final ClassExtension<Searcher<?, ?>> searchersExtension = new ClassExtension("com.intellij.searcher");

    @NotNull
    public static final <R> List<Searcher<SearchParameters<R>, R>> searchers(@NotNull SearchParameters<R> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        List list = searchersExtension.forKey(parameters.getClass());
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<com.intellij.model.search.Searcher<com.intellij.model.search.SearchParameters<R of com.intellij.psi.impl.search.HelperKt.searchers>, R of com.intellij.psi.impl.search.HelperKt.searchers>>");
        return list;
    }

    @ApiStatus.Internal
    @TestOnly
    public static final void registerSearcherForTesting(@NotNull Class<?> key, @NotNull Searcher<?, ?> searcher, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException();
        }
        searchersExtension.addExplicitExtension(key, searcher, parentDisposable);
    }

    @NotNull
    public static final ProgressIndicator getIndicatorOrEmpty() {
        ProgressIndicator progressIndicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressIndicatorProvider.getGlobalProgressIndicator());
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"notNullize(...)");
        return progressIndicator;
    }

    @ApiStatus.Internal
    @NotNull
    public static final <R> ReceiveChannel<R> runSearch(@NotNull CoroutineScope cs, @NotNull Project project, @NotNull Query<R> query) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return ProduceKt.produce$default((CoroutineScope)cs, null, (int)Integer.MAX_VALUE, (Function2)new Function2<ProducerScope<? super R>, Continuation<? super Unit>, Object>(project, query, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Query<R> $query;
            {
                this.$project = $project;
                this.$query = $query;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                ProducerScope producerScope = (ProducerScope)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$produce;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$produce);
                        this.label = 1;
                        Object object2 = CoroutinesKt.coroutineToIndicator(arg_0 -> runSearch.1.invokeSuspend$lambda$0(this.$project, this.$query, (ProducerScope)$this$produce, arg_0), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProducerScope<? super R> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final boolean invokeSuspend$lambda$0$0(ProducerScope $$this$produce, Object it) {
                if (!ChannelResult.isSuccess-impl((Object)$$this$produce.getChannel().trySend-JP2dKIU(it))) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                return true;
            }

            private static final Unit invokeSuspend$lambda$0(Project $project, Query $query, ProducerScope $$this$produce, ProgressIndicator it) {
                HelperKt.runSearch($project, $query, arg_0 -> runSearch.1.invokeSuspend$lambda$0$0($$this$produce, arg_0));
                return Unit.INSTANCE;
            }
        }, (int)1, null);
    }

    @ApiStatus.Internal
    public static final <R> boolean runSearch(@NotNull Project project, @NotNull Query<? extends R> query, @NotNull Processor<? super R> processor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        ProgressIndicator progress = HelperKt.getIndicatorOrEmpty();
        Collection currentQueries = CollectionsKt.listOf(query);
        while (!currentQueries.isEmpty()) {
            progress.checkCanceled();
            Layer<R> layer = HelperKt.buildLayer(progress, project, currentQueries);
            LayerResult<? super R> layerResult = layer.runLayer(processor);
            if (layerResult instanceof LayerResult.Ok) {
                currentQueries = ((LayerResult.Ok)layerResult).getSubqueries();
                continue;
            }
            if (layerResult instanceof LayerResult.Stop) {
                return false;
            }
            throw new NoWhenBranchMatchedException();
        }
        return true;
    }

    private static final <R> Layer<? extends R> buildLayer(ProgressIndicator progress, Project project, Collection<? extends Query<? extends R>> queries) {
        Queue queue = new ArrayDeque();
        queue.addAll(queries);
        SmartList queryRequests = new SmartList();
        SmartList wordRequests = new SmartList();
        while (!((Collection)queue).isEmpty()) {
            progress.checkCanceled();
            Object e = queue.remove();
            Intrinsics.checkNotNullExpressionValue(e, (String)"remove(...)");
            Query query = (Query)e;
            Requests primitives = RequestsKt.decompose(query);
            queryRequests.addAll(primitives.getQueryRequests());
            wordRequests.addAll(primitives.getWordRequests());
            for (ParametersRequest parametersRequest : primitives.getParametersRequests()) {
                progress.checkCanceled();
                HelperKt.handleParamRequest(progress, parametersRequest, arg_0 -> HelperKt.buildLayer$lambda$0(queue, arg_0));
            }
        }
        return new Layer(project, progress, (Collection)queryRequests, (Collection)wordRequests);
    }

    private static final <B, R> void handleParamRequest(ProgressIndicator progress, ParametersRequest<B, ? extends R> request, Function1<? super Query<? extends R>, Unit> queue) {
        Collection<Query<B>> searchRequests = HelperKt.collectSearchRequests(request.getParams());
        for (Query<B> query : searchRequests) {
            progress.checkCanceled();
            queue.invoke(new XQuery<B, R>(query, request.getTransformation()));
        }
    }

    private static final <R> Collection<Query<? extends R>> collectSearchRequests(SearchParameters<R> parameters) {
        Project project = parameters.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = DumbService.Companion.getInstance(project).runReadActionInSmartMode(() -> HelperKt.collectSearchRequests$lambda$0(parameters));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadActionInSmartMode(...)");
        return (Collection)object;
    }

    private static final <R> Collection<Query<? extends R>> doCollectSearchRequests(SearchParameters<R> parameters) {
        ArrayList<SearchersQuery<R>> queries = new ArrayList<SearchersQuery<R>>();
        queries.add(new SearchersQuery<R>(parameters));
        List<Searcher<SearchParameters<R>, R>> searchers = HelperKt.searchers(parameters);
        for (Searcher<SearchParameters<R>, R> searcher : searchers) {
            ProgressManager.checkCanceled();
            CollectionsKt.addAll((Collection)queries, (Iterable)searcher.collectSearchRequests(parameters));
        }
        return queries;
    }

    /*
     * WARNING - void declaration
     */
    private static final <R> boolean processQueryRequests(ProgressIndicator progress, Collection<? extends QueryRequest<?, ? extends R>> requests, Processor<? super XResult<? extends R>> processor) {
        void $this$groupByTo$iv$iv;
        if (requests.isEmpty()) {
            return true;
        }
        Iterable $this$groupBy$iv = requests;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            void $this$getOrPut$iv$iv$iv;
            QueryRequest it2 = (QueryRequest)element$iv$iv;
            boolean $i$a$-groupBy-HelperKt$processQueryRequests$map$32 = false;
            Query key$iv$iv = it2.getQuery();
            Map map = destination$iv$iv;
            Query key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            QueryRequest $i$a$-groupBy-HelperKt$processQueryRequests$map$32 = (QueryRequest)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add(it.getTransformation());
        }
        Map map = destination$iv$iv;
        for (Map.Entry entry : map.entrySet()) {
            Query query = (Query)entry.getKey();
            List transforms = (List)entry.getValue();
            progress.checkCanceled();
            Intrinsics.checkNotNull((Object)query, (String)"null cannot be cast to non-null type com.intellij.util.Query<kotlin.Any>");
            Intrinsics.checkNotNull((Object)transforms, (String)"null cannot be cast to non-null type kotlin.collections.Collection<kotlin.Function1<kotlin.Any, kotlin.collections.Collection<com.intellij.model.search.impl.XResult<R of com.intellij.psi.impl.search.HelperKt.processQueryRequests>>>>");
            if (HelperKt.runQueryRequest(query, transforms, processor)) continue;
            return false;
        }
        return true;
    }

    private static final <B, R> boolean runQueryRequest(Query<? extends B> query, Collection<? extends Function1<? super B, ? extends Collection<? extends R>>> transformations, Processor<? super R> processor) {
        return query.forEach(arg_0 -> HelperKt.runQueryRequest$lambda$1(arg_0 -> HelperKt.runQueryRequest$lambda$0(transformations, processor, arg_0), arg_0));
    }

    private static final Unit buildLayer$lambda$0(Queue $queue, Query it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $queue.offer(it);
        return Unit.INSTANCE;
    }

    private static final Collection collectSearchRequests$lambda$0(SearchParameters $parameters) {
        return $parameters.areValid() ? HelperKt.doCollectSearchRequests($parameters) : (Collection)CollectionsKt.emptyList();
    }

    private static final <B, R> boolean runQueryRequest$lambda$0(Collection<? extends Function1<? super B, ? extends Collection<? extends R>>> $transformations, Processor<? super R> $processor, B baseValue) {
        for (Function1<B, Collection<R>> function1 : $transformations) {
            for (Object resultValue : (Collection)function1.invoke(baseValue)) {
                if ($processor.process(resultValue)) continue;
                return false;
            }
        }
        return true;
    }

    private static final boolean runQueryRequest$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$processQueryRequests(ProgressIndicator progress, Collection requests, Processor processor) {
        return HelperKt.processQueryRequests(progress, requests, processor);
    }
}

