/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InjectedCaret
implements Caret {
    private final EditorWindow myEditorWindow;
    private final Caret myDelegate;

    @ApiStatus.Internal
    public InjectedCaret(@NotNull EditorWindow window, @NotNull Caret delegate) {
        if (window == null) {
            InjectedCaret.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            InjectedCaret.$$$reportNull$$$0(1);
        }
        this.myEditorWindow = window;
        this.myDelegate = delegate;
    }

    @NotNull
    public Editor getEditor() {
        EditorWindow editorWindow = this.myEditorWindow;
        if (editorWindow == null) {
            InjectedCaret.$$$reportNull$$$0(2);
        }
        return editorWindow;
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModel caretModel = this.myEditorWindow.getCaretModel();
        if (caretModel == null) {
            InjectedCaret.$$$reportNull$$$0(3);
        }
        return caretModel;
    }

    @NotNull
    public Caret getDelegate() {
        Caret caret = this.myDelegate;
        if (caret == null) {
            InjectedCaret.$$$reportNull$$$0(4);
        }
        return caret;
    }

    public boolean isValid() {
        return this.myDelegate.isValid();
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean scrollToCaret) {
        this.myDelegate.moveCaretRelatively(columnShift, lineShift, withSelection, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            InjectedCaret.$$$reportNull$$$0(5);
        }
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(pos);
        this.myDelegate.moveToLogicalPosition(hostPos);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            InjectedCaret.$$$reportNull$$$0(6);
        }
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(this.myEditorWindow.visualToLogicalPosition(pos));
        this.myDelegate.moveToLogicalPosition(hostPos);
    }

    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        int hostOffset = this.myEditorWindow.getDocument().injectedToHost(offset);
        this.myDelegate.moveToOffset(hostOffset, locateBeforeSoftWrap);
    }

    public boolean isUpToDate() {
        return this.myDelegate.isUpToDate();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        LogicalPosition hostPos = this.myDelegate.getLogicalPosition();
        LogicalPosition logicalPosition = this.myEditorWindow.hostToInjected(hostPos);
        if (logicalPosition == null) {
            InjectedCaret.$$$reportNull$$$0(7);
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        LogicalPosition logicalPosition = this.getLogicalPosition();
        VisualPosition visualPosition = this.myEditorWindow.logicalToVisualPosition(logicalPosition);
        if (visualPosition == null) {
            InjectedCaret.$$$reportNull$$$0(8);
        }
        return visualPosition;
    }

    public int getOffset() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getOffset());
    }

    public int getVisualLineStart() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getVisualLineStart());
    }

    public int getVisualLineEnd() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getVisualLineEnd());
    }

    public int getSelectionStart() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getSelectionStart());
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        VisualPosition visualPosition = this.myDelegate.getSelectionStartPosition();
        if (visualPosition == null) {
            InjectedCaret.$$$reportNull$$$0(9);
        }
        return visualPosition;
    }

    public int getSelectionEnd() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getSelectionEnd());
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        VisualPosition visualPosition = this.myDelegate.getSelectionEndPosition();
        if (visualPosition == null) {
            InjectedCaret.$$$reportNull$$$0(10);
        }
        return visualPosition;
    }

    @Nullable
    public String getSelectedText() {
        return this.myDelegate.getSelectedText();
    }

    public int getLeadSelectionOffset() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getLeadSelectionOffset());
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        VisualPosition visualPosition = this.myDelegate.getLeadSelectionPosition();
        if (visualPosition == null) {
            InjectedCaret.$$$reportNull$$$0(11);
        }
        return visualPosition;
    }

    public boolean hasSelection() {
        return this.myDelegate.hasSelection();
    }

    @NotNull
    public TextRange getSelectionRange() {
        TextRange range = this.myDelegate.getSelectionRange();
        TextRange textRange = TextRange.create((int)this.myEditorWindow.getDocument().hostToInjected(range.getStartOffset()), (int)this.myEditorWindow.getDocument().hostToInjected(range.getEndOffset()));
        if (textRange == null) {
            InjectedCaret.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    public void setSelection(int startOffset, int endOffset) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(hostRange.getStartOffset(), hostRange.getEndOffset());
    }

    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(hostRange.getStartOffset(), hostRange.getEndOffset(), updateSystemSelection);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(hostRange.getStartOffset(), endPosition, hostRange.getEndOffset());
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(startPosition, hostRange.getStartOffset(), endPosition, hostRange.getEndOffset());
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(startPosition, hostRange.getStartOffset(), endPosition, hostRange.getEndOffset(), updateSystemSelection);
    }

    public void removeSelection() {
        this.myDelegate.removeSelection();
    }

    public void selectLineAtCaret() {
        this.myDelegate.selectLineAtCaret();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.myDelegate.selectWordAtCaret(honorCamelWordsSettings);
    }

    @Nullable
    public Caret clone(boolean above) {
        Caret clone = this.myDelegate.clone(above);
        return clone == null ? null : new InjectedCaret(this.myEditorWindow, clone);
    }

    public void dispose() {
        this.myDelegate.dispose();
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            InjectedCaret.$$$reportNull$$$0(13);
        }
        if (value == null) {
            InjectedCaret.$$$reportNull$$$0(14);
        }
        Object object = this.myDelegate.putUserDataIfAbsent(key, value);
        if (object == null) {
            InjectedCaret.$$$reportNull$$$0(15);
        }
        return (T)object;
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            InjectedCaret.$$$reportNull$$$0(16);
        }
        return this.myDelegate.replace(key, oldValue, newValue);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            InjectedCaret.$$$reportNull$$$0(17);
        }
        return (T)this.myDelegate.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            InjectedCaret.$$$reportNull$$$0(18);
        }
        this.myDelegate.putUserData(key, value);
    }

    public boolean isAtRtlLocation() {
        return this.myDelegate.isAtRtlLocation();
    }

    public boolean isAtBidiRunBoundary() {
        return this.myDelegate.isAtBidiRunBoundary();
    }

    @NotNull
    public CaretVisualAttributes getVisualAttributes() {
        CaretVisualAttributes caretVisualAttributes = this.myDelegate.getVisualAttributes();
        if (caretVisualAttributes == null) {
            InjectedCaret.$$$reportNull$$$0(19);
        }
        return caretVisualAttributes;
    }

    public void setVisualAttributes(@NotNull CaretVisualAttributes attributes) {
        if (attributes == null) {
            InjectedCaret.$$$reportNull$$$0(20);
        }
        this.myDelegate.setVisualAttributes(attributes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7, 8, 9, 10, 11, 12, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectedCaret";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalPosition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionStartPosition";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionEndPosition";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelectionPosition";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionRange";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "moveToLogicalPosition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "moveToVisualPosition";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setVisualAttributes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7, 8, 9, 10, 11, 12, 15, 19 -> new IllegalStateException(string);
        };
    }
}

