/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ShredImpl
implements PsiLanguageInjectionHost.Shred {
    private final SmartPsiFileRange relevantRangeInHost;
    private final SmartPsiElementPointer<PsiLanguageInjectionHost> hostElementPointer;
    private final TextRange rangeInDecodedPSI;
    private final String prefix;
    private final String suffix;
    private final boolean usePsiRange;
    private final boolean isOneLine;

    ShredImpl(@NotNull SmartPsiFileRange relevantRangeInHost, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> hostElementPointer, @NotNull String prefix, @NotNull String suffix, @NotNull TextRange rangeInDecodedPSI, boolean usePsiRange, boolean isOneLine) {
        if (relevantRangeInHost == null) {
            ShredImpl.$$$reportNull$$$0(0);
        }
        if (hostElementPointer == null) {
            ShredImpl.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            ShredImpl.$$$reportNull$$$0(2);
        }
        if (suffix == null) {
            ShredImpl.$$$reportNull$$$0(3);
        }
        if (rangeInDecodedPSI == null) {
            ShredImpl.$$$reportNull$$$0(4);
        }
        this.hostElementPointer = hostElementPointer;
        this.relevantRangeInHost = relevantRangeInHost;
        this.prefix = prefix;
        this.suffix = suffix;
        this.rangeInDecodedPSI = rangeInDecodedPSI;
        this.usePsiRange = usePsiRange;
        this.isOneLine = isOneLine;
        this.assertValid();
    }

    private void assertValid() {
        Segment hostRange = this.relevantRangeInHost.getPsiRange();
        assert (hostRange != null) : "invalid host range: " + String.valueOf(this.relevantRangeInHost);
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)this.hostElementPointer.getElement();
        assert (host != null && host.isValid()) : "no host: " + String.valueOf(this.hostElementPointer);
    }

    @NotNull
    ShredImpl withPsiRange() {
        return new ShredImpl(this.relevantRangeInHost, this.hostElementPointer, this.prefix, this.suffix, this.rangeInDecodedPSI, true, this.isOneLine);
    }

    @NotNull
    ShredImpl withRange(@NotNull TextRange rangeInDecodedPSI, @NotNull TextRange rangeInHostElementPSI, @NotNull PsiLanguageInjectionHost newHost) {
        if (rangeInDecodedPSI == null) {
            ShredImpl.$$$reportNull$$$0(5);
        }
        if (rangeInHostElementPSI == null) {
            ShredImpl.$$$reportNull$$$0(6);
        }
        if (newHost == null) {
            ShredImpl.$$$reportNull$$$0(7);
        }
        SmartPsiFileRange rangeMarker = this.relevantRangeInHost;
        TextRange oldRangeInHostElementPSI = this.calcRangeInsideHostElement(false);
        SmartPointerManagerEx pointerManager = (SmartPointerManagerEx)SmartPointerManager.getInstance((Project)rangeMarker.getProject());
        SmartPsiElementPointer newHostPointer = pointerManager.createSmartPsiElementPointer((PsiElement)newHost, newHost.getContainingFile(), true);
        if (!rangeInHostElementPSI.equals((Object)TextRange.create((Segment)oldRangeInHostElementPSI))) {
            Segment hostElementRange = newHostPointer.getRange();
            rangeMarker = pointerManager.createSmartPsiFileRangePointer(rangeMarker.getContainingFile(), rangeInHostElementPSI.shiftRight(hostElementRange.getStartOffset()), true);
        }
        return new ShredImpl(rangeMarker, (SmartPsiElementPointer<PsiLanguageInjectionHost>)newHostPointer, this.prefix, this.suffix, rangeInDecodedPSI, this.usePsiRange, this.isOneLine);
    }

    @NotNull
    SmartPsiElementPointer<PsiLanguageInjectionHost> getSmartPointer() {
        SmartPsiElementPointer<PsiLanguageInjectionHost> smartPsiElementPointer = this.hostElementPointer;
        if (smartPsiElementPointer == null) {
            ShredImpl.$$$reportNull$$$0(8);
        }
        return smartPsiElementPointer;
    }

    @Nullable(value="returns null when the host document marker is invalid")
    public @Nullable(value="returns null when the host document marker is invalid") Segment getHostRangeMarker() {
        return this.usePsiRange ? this.relevantRangeInHost.getPsiRange() : this.relevantRangeInHost.getRange();
    }

    @NotNull
    public TextRange getRangeInsideHost() {
        return this.calcRangeInsideHostElement(true);
    }

    @NotNull
    private TextRange calcRangeInsideHostElement(boolean usePsiRange) {
        TextRange textRange;
        PsiLanguageInjectionHost host = this.getHost();
        Segment psiRange = usePsiRange ? this.relevantRangeInHost.getPsiRange() : this.relevantRangeInHost.getRange();
        TextRange textRange2 = textRange = psiRange == null ? null : TextRange.create((Segment)psiRange);
        if (host == null) {
            Segment fromSP;
            if (textRange != null) {
                TextRange textRange3 = textRange;
                if (textRange3 == null) {
                    ShredImpl.$$$reportNull$$$0(9);
                }
                return textRange3;
            }
            Segment segment = fromSP = usePsiRange ? this.hostElementPointer.getPsiRange() : this.hostElementPointer.getRange();
            if (fromSP != null) {
                TextRange textRange4 = TextRange.create((Segment)fromSP);
                if (textRange4 == null) {
                    ShredImpl.$$$reportNull$$$0(10);
                }
                return textRange4;
            }
            return new TextRange(0, 0);
        }
        TextRange hostTextRange = host.getTextRange();
        TextRange textRange5 = textRange = textRange == null ? null : textRange.intersection(hostTextRange);
        if (textRange == null) {
            return new ProperTextRange(0, hostTextRange.getLength());
        }
        TextRange textRange6 = textRange.shiftLeft(hostTextRange.getStartOffset());
        if (textRange6 == null) {
            ShredImpl.$$$reportNull$$$0(11);
        }
        return textRange6;
    }

    public String toString() {
        PsiLanguageInjectionHost host = this.getHost();
        Segment hostRange = this.getHostRangeMarker();
        return "Shred " + String.valueOf(host == null ? null : host.getTextRange()) + ": " + String.valueOf(host) + " In host range: " + (String)(hostRange != null ? "(" + hostRange.getStartOffset() + "," + hostRange.getEndOffset() + ");" : "invalid;") + " PSI range: " + String.valueOf(this.rangeInDecodedPSI);
    }

    public boolean isValid() {
        return this.getHostRangeMarker() != null && this.getHost() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)o;
        PsiLanguageInjectionHost host = this.getHost();
        Segment hostRangeMarker = this.getHostRangeMarker();
        Segment hostRangeMarker2 = shred.getHostRangeMarker();
        return host != null && host.equals((Object)shred.getHost()) && this.prefix.equals(shred.getPrefix()) && this.suffix.equals(shred.getSuffix()) && this.rangeInDecodedPSI.equals((Object)shred.getRange()) && hostRangeMarker != null && hostRangeMarker2 != null && TextRange.areSegmentsEqual((Segment)hostRangeMarker, (Segment)hostRangeMarker2);
    }

    public int hashCode() {
        return this.rangeInDecodedPSI.hashCode();
    }

    public void dispose() {
    }

    @Nullable
    public PsiLanguageInjectionHost getHost() {
        return (PsiLanguageInjectionHost)this.hostElementPointer.getElement();
    }

    @NotNull
    public TextRange getRange() {
        TextRange textRange = this.rangeInDecodedPSI;
        if (textRange == null) {
            ShredImpl.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    @NotNull
    public String getPrefix() {
        String string = this.prefix;
        if (string == null) {
            ShredImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getSuffix() {
        String string = this.suffix;
        if (string == null) {
            ShredImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    boolean isOneLine() {
        return this.isOneLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relevantRangeInHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostElementPointer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInDecodedPSI";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInHostElementPSI";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newHost";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/ShredImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/ShredImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmartPointer";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRangeInsideHostElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withRange";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

