/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.search.ActualContextFileInfo;
import com.intellij.psi.search.CodeInsightContextAwareSearchScopes;
import com.intellij.psi.search.CodeInsightContextFileInfo;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NoContextFileInfo;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubInconsistencyReporter;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public abstract class StubProcessingHelperBase {
    protected static final Logger LOG = Logger.getInstance(StubProcessingHelperBase.class);
    private static final AtomicInteger ourContextErrorCounter = new AtomicInteger(0);
    private static final int MAX_CONTEXT_ERROR_NUMBER = 10;

    public <Psi extends PsiElement> boolean processStubsInFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull StubIdList value, @NotNull Processor<? super Psi> processor, @Nullable GlobalSearchScope scope, @NotNull Class<Psi> requiredClass, @NotNull Computable<String> debugOperationName) {
        PsiElement psi;
        if (project == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(0);
        }
        if (file == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(1);
        }
        if (value == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(3);
        }
        if (requiredClass == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(4);
        }
        if (debugOperationName == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(5);
        }
        CodeInsightContext context = StubProcessingHelperBase.getCodeInsightContext(file, project, scope);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file, context);
        if (psiFile == null) {
            LOG.error("Stub index points to a file without PSI: " + StubProcessingHelperBase.getFileTypeInfo(file, project) + ", indexing stamp info = " + String.valueOf(StubTreeLoader.getInstance().getIndexingStampInfo(file)) + ", used scope = " + String.valueOf(scope));
            this.onInternalError(file);
            return true;
        }
        if (value.size() == 1 && value.get(0) == 0) {
            return !this.checkType(requiredClass, psiFile, (PsiElement)psiFile, debugOperationName, value, 0, StubInconsistencyReporter.StubTreeAndIndexDoNotMatchSource.ZeroStubIdList) || processor.process((Object)psiFile);
        }
        List<StubbedSpine> spines = StubProcessingHelperBase.getAllSpines(psiFile);
        if (spines.isEmpty()) {
            return this.handleNonPsiStubs(file, processor, requiredClass, psiFile);
        }
        int size = value.size();
        for (int i = 0; i < size && this.checkType(requiredClass, psiFile, psi = StubProcessingHelperBase.getStubPsi(spines, value.get(i)), debugOperationName, value, i, StubInconsistencyReporter.StubTreeAndIndexDoNotMatchSource.StubPsiCheck); ++i) {
            if (processor.process((Object)psi)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static CodeInsightContext getCodeInsightContext(@NotNull VirtualFile file, @NotNull Project project, @Nullable GlobalSearchScope scope) {
        if (file == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(6);
        }
        if (project == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(7);
        }
        if (!CodeInsightContexts.isSharedSourceSupportEnabled((Project)project)) {
            CodeInsightContext codeInsightContext = CodeInsightContexts.anyContext();
            if (codeInsightContext == null) {
                StubProcessingHelperBase.$$$reportNull$$$0(8);
            }
            return codeInsightContext;
        }
        if (scope == null) {
            CodeInsightContext codeInsightContext = CodeInsightContexts.anyContext();
            if (codeInsightContext == null) {
                StubProcessingHelperBase.$$$reportNull$$$0(9);
            }
            return codeInsightContext;
        }
        CodeInsightContextFileInfo fileInfo = CodeInsightContextAwareSearchScopes.getFileContextInfo((SearchScope)scope, (VirtualFile)file);
        if (fileInfo instanceof ActualContextFileInfo) {
            Collection contexts = ((ActualContextFileInfo)fileInfo).getContexts();
            if (contexts.size() > 1) {
                StubProcessingHelperBase.reportMultipleContextsAreNotSupported(file, scope, contexts);
            }
            CodeInsightContext codeInsightContext = (CodeInsightContext)contexts.iterator().next();
            if (codeInsightContext == null) {
                StubProcessingHelperBase.$$$reportNull$$$0(10);
            }
            return codeInsightContext;
        }
        if (fileInfo instanceof NoContextFileInfo) {
            CodeInsightContext codeInsightContext = CodeInsightContexts.anyContext();
            if (codeInsightContext == null) {
                StubProcessingHelperBase.$$$reportNull$$$0(11);
            }
            return codeInsightContext;
        }
        LOG.error("Provided scope does not contain file " + String.valueOf(file) + ", scope = " + String.valueOf(scope));
        CodeInsightContext codeInsightContext = CodeInsightContexts.anyContext();
        if (codeInsightContext == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(12);
        }
        return codeInsightContext;
    }

    private static void reportMultipleContextsAreNotSupported(@NotNull VirtualFile file, @NotNull GlobalSearchScope scope, @NotNull Collection<CodeInsightContext> contexts) {
        if (file == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(14);
        }
        if (contexts == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(15);
        }
        if (ourContextErrorCounter.get() < 10) {
            LOG.warn("Multiple contexts for file " + String.valueOf(file) + " in scope " + String.valueOf(scope) + ". Contexts: " + String.valueOf(contexts));
            ourContextErrorCounter.incrementAndGet();
        }
    }

    private static @Unmodifiable @NotNull List<StubbedSpine> getAllSpines(PsiFile psiFile) {
        if (!(psiFile instanceof PsiFileImpl) && psiFile instanceof PsiFileWithStubSupport) {
            List<StubbedSpine> list = Collections.singletonList(((PsiFileWithStubSupport)psiFile).getStubbedSpine());
            if (list == null) {
                StubProcessingHelperBase.$$$reportNull$$$0(16);
            }
            return list;
        }
        List roots = StubTreeBuilder.getStubbedRootDescriptors((FileViewProvider)psiFile.getViewProvider());
        List list = ContainerUtil.map((Collection)roots, pair -> {
            PsiFileImpl root = (PsiFileImpl)pair.second;
            return root.getStubbedSpine();
        });
        if (list == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(17);
        }
        return list;
    }

    private <Psi extends PsiElement> boolean checkType(@NotNull Class<Psi> requiredClass, PsiFile psiFile, @Nullable PsiElement psiElement, @NotNull Computable<String> debugOperationName, @NotNull StubIdList debugStubIdList, int stubIdListIdx, @NotNull StubInconsistencyReporter.StubTreeAndIndexDoNotMatchSource source) {
        if (requiredClass == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(18);
        }
        if (debugOperationName == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(19);
        }
        if (debugStubIdList == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(20);
        }
        if (source == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(21);
        }
        if (requiredClass.isInstance(psiElement)) {
            return true;
        }
        String extraMessage = "psiElement is not instance of requiredClass.\npsiElement=" + String.valueOf(psiElement) + (String)(psiElement != null ? ", psiElement.class=" + String.valueOf(psiElement.getClass()) : "") + ", requiredClass=" + String.valueOf(requiredClass) + ", operation=" + (String)debugOperationName.get() + ", stubIdList=" + String.valueOf(debugStubIdList) + "@" + stubIdListIdx + ".\nref: 20250127";
        StubTree stubTree = ((PsiFileWithStubSupport)psiFile).getStubTree();
        if (stubTree == null && psiFile instanceof PsiFileImpl) {
            stubTree = ((PsiFileImpl)psiFile).calcStubTree();
        }
        this.inconsistencyDetected((ObjectStubTree<?>)stubTree, (PsiFileWithStubSupport)psiFile, extraMessage, source);
        return false;
    }

    private static PsiElement getStubPsi(List<? extends StubbedSpine> spines, int index) {
        if (spines.size() == 1) {
            return spines.get(0).getStubPsi(index);
        }
        for (StubbedSpine stubbedSpine : spines) {
            int count = stubbedSpine.getStubCount();
            if (index < count) {
                return stubbedSpine.getStubPsi(index);
            }
            index -= count;
        }
        return null;
    }

    private <Psi extends PsiElement> boolean handleNonPsiStubs(@NotNull VirtualFile file, @NotNull Processor<? super Psi> processor, @NotNull Class<Psi> requiredClass, @NotNull PsiFile psiFile) {
        if (file == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(23);
        }
        if (requiredClass == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(24);
        }
        if (psiFile == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(25);
        }
        if (BinaryFileStubBuilders.INSTANCE.forFileType(psiFile.getFileType()) == null) {
            LOG.error("unable to get stub builder for file with " + StubProcessingHelperBase.getFileTypeInfo(file, psiFile.getProject()) + ", " + StubTreeLoader.getFileViewProviderMismatchDiagnostics((FileViewProvider)psiFile.getViewProvider()));
            this.onInternalError(file);
            return true;
        }
        if (psiFile instanceof PsiBinaryFile) {
            return true;
        }
        ObjectStubTree objectStubTree = StubTreeLoader.getInstance().readFromVFile(psiFile.getProject(), file);
        if (objectStubTree == null) {
            LOG.error("Stub index points to a file without indexed stubs: " + StubProcessingHelperBase.getFileTypeInfo(file, psiFile.getProject()));
            this.onInternalError(file);
            return true;
        }
        if (objectStubTree instanceof StubTree) {
            LOG.error("Stub index points to a file with PSI stubs (instead of non-PSI ones): " + StubProcessingHelperBase.getFileTypeInfo(file, psiFile.getProject()));
            this.onInternalError(file);
            return true;
        }
        if (!requiredClass.isInstance(psiFile)) {
            String extraMessage = "psiFile is not instance of requiredClass.\npsiFile=" + String.valueOf(psiFile) + ", psiFile.class=" + String.valueOf(psiFile.getClass()) + ", requiredClass=" + String.valueOf(requiredClass) + ".\nref: 20250127";
            this.inconsistencyDetected(objectStubTree, (PsiFileWithStubSupport)psiFile, extraMessage, StubInconsistencyReporter.StubTreeAndIndexDoNotMatchSource.WrongPsiFileClassInNonPsiStub);
            return true;
        }
        return processor.process((Object)psiFile);
    }

    private void inconsistencyDetected(@Nullable ObjectStubTree<?> stubTree, @NotNull PsiFileWithStubSupport psiFile, @NotNull String extraMessage, @NotNull StubInconsistencyReporter.StubTreeAndIndexDoNotMatchSource source) {
        if (psiFile == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(26);
        }
        if (extraMessage == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(27);
        }
        if (source == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(28);
        }
        try {
            StubTextInconsistencyException.checkStubTextConsistency((PsiFile)psiFile, (StubInconsistencyReporter.SourceOfCheck)StubInconsistencyReporter.SourceOfCheck.WrongTypePsiInStubHelper);
            String dumbState = DumbService.isDumb((Project)psiFile.getProject()) ? "\ndumbMode,dumbModeAccessType=" + String.valueOf(FileBasedIndex.getInstance().getCurrentDumbModeAccessType(null)) : "\nno dumbMode";
            LOG.error(extraMessage + dumbState + "\n" + String.valueOf(StubTreeLoader.getInstance().stubTreeAndIndexDoNotMatch(stubTree, psiFile, null, source)));
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable t) {
            this.onInternalError(psiFile.getVirtualFile());
            throw t;
        }
    }

    protected abstract void onInternalError(VirtualFile var1);

    @NotNull
    protected static String getFileTypeInfo(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(29);
        }
        if (project == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(30);
        }
        String string = "file = " + String.valueOf(file) + (file.isValid() ? "" : " (invalid)") + ", file type = " + String.valueOf(file.getFileType()) + ", indexed file type = " + String.valueOf(FileTypeIndex.getIndexedFileType((VirtualFile)file, (Project)project));
        if (string == null) {
            StubProcessingHelperBase.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 16, 17, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 13: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClass";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugOperationName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubProcessingHelperBase";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugStubIdList";
                break;
            }
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubProcessingHelperBase";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeInsightContext";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSpines";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processStubsInFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCodeInsightContext";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 31: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reportMultipleContextsAreNotSupported";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "handleNonPsiStubs";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "inconsistencyDetected";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 16, 17, 31 -> new IllegalStateException(string);
        };
    }
}

