/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.kotlin.debug.stacktrace;

import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.KtorStarterIcons;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.KotlinStackFrame;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0082\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u0096\u0080\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ktor/kotlin/debug/stacktrace/KtorXStackFrame;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlinStackFrame", "Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrame;", "pluginName", "", "handlerName", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/KotlinStackFrame;Ljava/lang/String;Ljava/lang/String;)V", "equals", "", "other", "", "hashCode", "", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "getEqualityObject", "getSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "customizePresentation", "component", "Lcom/intellij/ui/ColoredTextContainer;", "nlsSafePackageName", "intellij.ktor"})
public final class KtorXStackFrame
extends XStackFrame {
    @NotNull
    private final KtFile file;
    @NotNull
    private final KotlinStackFrame kotlinStackFrame;
    @NotNull
    private final String pluginName;
    @Nullable
    private final String handlerName;

    public KtorXStackFrame(@NotNull KtFile file, @NotNull KotlinStackFrame kotlinStackFrame, @NotNull String pluginName, @Nullable String handlerName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)kotlinStackFrame, (String)"kotlinStackFrame");
        Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
        this.file = file;
        this.kotlinStackFrame = kotlinStackFrame;
        this.pluginName = pluginName;
        this.handlerName = handlerName;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof KtorXStackFrame && Intrinsics.areEqual((Object)this.kotlinStackFrame, (Object)((KtorXStackFrame)((Object)other)).kotlinStackFrame);
    }

    public int hashCode() {
        return this.kotlinStackFrame.hashCode();
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.kotlinStackFrame.computeChildren(node);
    }

    @Nullable
    public Object getEqualityObject() {
        return this.kotlinStackFrame.getEqualityObject();
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.kotlinStackFrame.getSourcePosition();
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            component.setIcon(KtorStarterIcons.KtorGutter);
            XSourcePosition xSourcePosition = this.kotlinStackFrame.getSourcePosition();
            if (xSourcePosition != null) {
                XSourcePosition sourcePosition = xSourcePosition;
                boolean bl = false;
                String string = sourcePosition.getFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String fileName = string;
                int line = sourcePosition.getLine();
                component.append(fileName + ":" + line, SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
                String packageName = this.nlsSafePackageName(this.file);
                component.append(" (" + packageName + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            }
            Object[] objectArray = new Object[]{this.pluginName};
            component.append(KtorStarterBundle.INSTANCE.message("ktor.debugger.label.plugin", objectArray), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
            String string = this.handlerName;
            if (string == null) break block1;
            String phase = string;
            boolean bl = false;
            Object[] objectArray2 = new Object[]{phase};
            component.append(KtorStarterBundle.INSTANCE.message("ktor.debugger.label.phase", objectArray2), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
        }
    }

    @NlsSafe
    private final String nlsSafePackageName(KtFile file) {
        return file.getPackageFqName().asString();
    }
}

