/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.utils;

import com.intellij.ktor.KtorUtilsKt;
import com.intellij.ktor.utils.KotlinResolveKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaReceiverParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a\u001d\u0010\u000b\u001a\u00020\u0001*\u00020\u000eH\u0000R\u00020\fj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000f\u001a\u001d\u0010\u0010\u001a\u00020\u0001*\u00020\u000eH\u0000R\u00020\fj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000f\u001a+\u0010\u0011\u001a\u00020\u0001*\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u00020\fj\u0006\u0010\u0012\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"hasKtorApplicationCall", "", "ktNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "hasKtorApplicationCallDumb", "hasKtorApplicationCallSmart", "hasCallInFunction", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "callNames", "", "", "hasApplicationReceiver", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;)Z", "hasKtorBaseReceiver", "hasOneOfAcceptedReceiverTypes", "session", "typesFqNames", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;Ljava/util/Collection;)Z", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorAnalysisUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorAnalysisUtils.kt\ncom/intellij/ktor/utils/KtorAnalysisUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1807#2,3:104\n30#3,2:107\n36#4,9:109\n49#4,2:119\n46#4,2:121\n1#5:118\n*S KotlinDebug\n*F\n+ 1 KtorAnalysisUtils.kt\ncom/intellij/ktor/utils/KtorAnalysisUtilsKt\n*L\n55#1:104,3\n66#1:107,2\n66#1:109,9\n66#1:119,2\n66#1:121,2\n*E\n"})
public final class KtorAnalysisUtilsKt {
    public static final boolean hasKtorApplicationCall(@NotNull KtNamedFunction ktNamedFunction) {
        Intrinsics.checkNotNullParameter((Object)ktNamedFunction, (String)"ktNamedFunction");
        Project project = ktNamedFunction.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        return DumbService.Companion.isDumb(project2) ? KtorAnalysisUtilsKt.hasKtorApplicationCallDumb(ktNamedFunction) : KtorAnalysisUtilsKt.hasKtorApplicationCallSmart(ktNamedFunction);
    }

    private static final boolean hasKtorApplicationCallDumb(KtNamedFunction ktNamedFunction) {
        Class[] classArray = new Class[]{KtDotQualifiedExpression.class};
        Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)((PsiElement)ktNamedFunction), (boolean)false, (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfAnyType(...)");
        Collection calls = collection;
        List ktorMains = CollectionsKt.plus(KtorUtilsKt.getKTOR_APPLICATION_METHODS(), (Object)"embeddedServer");
        for (KtDotQualifiedExpression call : calls) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = ktorMains;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        String string = call.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        if (!StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private static final boolean hasKtorApplicationCallSmart(KtNamedFunction ktNamedFunction) {
        return KtorAnalysisUtilsKt.hasCallInFunction(ktNamedFunction, KtorUtilsKt.getKTOR_APPLICATION_METHODS()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final KtCallElement hasCallInFunction(KtNamedFunction ktNamedFunction, Collection<String> callNames) {
        KtCallElement ktCallElement;
        void this_$iv$iv;
        KtElement useSiteElement$iv = (KtElement)ktNamedFunction;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        KtElement useSiteElement$iv$iv = useSiteElement$iv;
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            KtCallElement ktCallElement2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                Object v2;
                block9: {
                    boolean bl = false;
                    KaSession $this$hasCallInFunction_u24lambda_u240 = analysisSession$iv$iv;
                    boolean bl2 = false;
                    Object object2 = new Class[]{KtCallElement.class};
                    Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)((PsiElement)ktNamedFunction), (boolean)false, (Class[])object2);
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfAnyType(...)");
                    Collection calls = collection;
                    object2 = calls;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        KtCallElement ktCallElement3 = (KtCallElement)t;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)ktCallElement3);
                        if (!KotlinResolveKt.isOneOfAcceptedFunction($this$hasCallInFunction_u24lambda_u240, ktCallElement3, callNames)) continue;
                        v2 = t;
                        break block9;
                    }
                    v2 = null;
                }
                ktCallElement2 = v2;
            }
            ktCallElement = ktCallElement2;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
        return ktCallElement;
    }

    public static final boolean hasApplicationReceiver(@NotNull KaSession kaSession, @NotNull KaFunctionSymbol $this$hasApplicationReceiver) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)$this$hasApplicationReceiver, (String)"<this>");
        return KtorAnalysisUtilsKt.hasOneOfAcceptedReceiverTypes(kaSession, $this$hasApplicationReceiver, KtorUtilsKt.getAPPLICATION_CLASSES());
    }

    public static final boolean hasKtorBaseReceiver(@NotNull KaSession kaSession, @NotNull KaFunctionSymbol $this$hasKtorBaseReceiver) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"$context-KaSession");
        Intrinsics.checkNotNullParameter((Object)$this$hasKtorBaseReceiver, (String)"<this>");
        return KtorAnalysisUtilsKt.hasOneOfAcceptedReceiverTypes(kaSession, $this$hasKtorBaseReceiver, KtorUtilsKt.getKTOR_BASE_RECEIVER_CLASSES());
    }

    private static final boolean hasOneOfAcceptedReceiverTypes(KaSession session, KaFunctionSymbol $this$hasOneOfAcceptedReceiverTypes, Collection<String> typesFqNames) {
        KaReceiverParameterSymbol kaReceiverParameterSymbol = $this$hasOneOfAcceptedReceiverTypes.getReceiverParameter();
        if (kaReceiverParameterSymbol == null || (kaReceiverParameterSymbol = kaReceiverParameterSymbol.getReturnType()) == null) {
            return false;
        }
        KaReceiverParameterSymbol receiverType = kaReceiverParameterSymbol;
        FqName fqName = KotlinResolveKt.fqNameForType(session, (KaType)receiverType);
        if (fqName == null) {
            return false;
        }
        FqName receiverTypeFqName = fqName;
        return typesFqNames.contains(receiverTypeFqName.asString());
    }
}

