/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.actions;

import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.jupyter.JupyterRemoteBundle;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/py/connections/actions/JupyterServerChooserActionUtils;", "", "<init>", "()V", "askUserConfirmation", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "config", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;", "intellij.jupyter.py"})
public final class JupyterServerChooserActionUtils {
    @NotNull
    public static final JupyterServerChooserActionUtils INSTANCE = new JupyterServerChooserActionUtils();

    private JupyterServerChooserActionUtils() {
    }

    public final boolean askUserConfirmation(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull JupyterServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        JupyterNotebookSession jupyterNotebookSession = JupyterExecutionManager.Companion.getInstance(project, virtualFile).getSession();
        if (jupyterNotebookSession == null) {
            return true;
        }
        JupyterNotebookSession session = jupyterNotebookSession;
        JupyterServerConfig jupyterServerConfig = session.getConnectionParameters().getConfig();
        if (jupyterServerConfig == null) {
            return true;
        }
        JupyterServerConfig existingConnectionConfig = jupyterServerConfig;
        if (Intrinsics.areEqual((Object)config, (Object)existingConnectionConfig)) {
            return true;
        }
        Object[] objectArray = new Object[]{existingConnectionConfig.getName()};
        boolean isOk = Messages.showOkCancelDialog((Project)project, (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.message", (Object[])objectArray), (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.title", (Object[])new Object[0]), (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon()) == 0;
        return isOk;
    }
}

