/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdater;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.JupyterEditorActionBase;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterDebugger;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.core.jupyter.notification.JupyterNotification;
import com.intellij.jupyter.py.debugger.common.JupyterPyDebugRunnerProvider;
import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.PythonLanguage;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellTypeProvider;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugAction;", "Lcom/intellij/jupyter/core/jupyter/actions/JupyterEditorActionBase;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createActionUpdater", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterActonUpdater;", "intellij.jupyter.py"})
public final class JupyterDebugAction
extends JupyterEditorActionBase {
    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (project2.isDisposed()) {
            return;
        }
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor((DataContext)dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        if (editor.getEditorKind() == EditorKind.DIFF) {
            return;
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)event);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        DataContext dataContext2 = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext2);
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        if (interval2.getType() != CellType.CODE) {
            return;
        }
        NotebookIntervalPointer notebookIntervalPointer = JupyterHelper.INSTANCE.getIntervalPointer(project2, notebookFile, interval2.getOrdinal());
        if (notebookIntervalPointer == null) {
            return;
        }
        NotebookIntervalPointer cellPointer = notebookIntervalPointer;
        if (JupyterDebugger.INSTANCE.showWarningIfUnderDebugger(project2, notebookFile)) {
            return;
        }
        JupyterCoroutineKt.launchBackground((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project2, notebookFile, cellPointer, null){
            Object L$0;
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ BackedNotebookVirtualFile $notebookFile;
            final /* synthetic */ NotebookIntervalPointer $cellPointer;
            {
                this.$project = $project;
                this.$notebookFile = $notebookFile;
                this.$cellPointer = $cellPointer;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = JupyterPyDebugRunnerProvider.Companion.createDebugSession(this.$project, this.$notebookFile, this.$cellPointer, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object3;
                        Object object2;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (CancellationException t) {
                            throw t;
                        }
                        catch (Exception e) {
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)e);
                            this.label = 2;
                            object3 = JupyterNotification.INSTANCE.showErrorDialog(this.$project, (Throwable)e, (Continuation)this);
                            if (object3 != object) return Unit.INSTANCE;
                            return object;
                        }
                    }
                    case 2: {
                        Exception e = (Exception)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    protected JupyterActonUpdater createActionUpdater() {
        return super.createActionUpdater().derive(JupyterDebugAction::createActionUpdater$lambda$0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createActionUpdater$lambda$0$0(JupyterEditorAction jupyterEditorAction, AnActionEvent event) {
        NotebookCellLines.Interval interval;
        Intrinsics.checkNotNullParameter((Object)jupyterEditorAction, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        NotebookCellLines.Interval interval2 = interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (!Intrinsics.areEqual((Object)(interval2 != null ? interval2.getLanguage() : null), (Object)PythonLanguage.INSTANCE)) return false;
        JupyterCellTypeProvider jupyterCellTypeProvider = JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellTypeProvider(interval);
        if (jupyterCellTypeProvider == null) return false;
        if (!jupyterCellTypeProvider.isDebugActionSupported()) return false;
        return true;
    }

    private static final boolean createActionUpdater$lambda$0$1(JupyterEditorAction jupyterEditorAction, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)jupyterEditorAction, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return true;
        }
        Project project2 = project;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)event);
        if (backedNotebookVirtualFile == null) {
            return true;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        return !JupyterDebugger.INSTANCE.isUnderDebugger(project2, notebookFile);
    }

    private static final Unit createActionUpdater$lambda$0(JupyterActonUpdater.Builder $this$derive) {
        Intrinsics.checkNotNullParameter((Object)$this$derive, (String)"$this$derive");
        $this$derive.addEnabledAndVisibleProvider(JupyterDebugAction::createActionUpdater$lambda$0$0);
        $this$derive.addEnabledProvider(JupyterDebugAction::createActionUpdater$lambda$0$1);
        return Unit.INSTANCE;
    }
}

