/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.helpers.providers;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.py.helpers.JupyterPyHelperProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/py/helpers/providers/ManagedPyHelperProvider;", "Lcom/intellij/jupyter/py/helpers/JupyterPyHelperProvider;", "<init>", "()V", "isApplicable", "", "file", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "serverRoot", "Ljava/nio/file/Path;", "getServerRoot", "()Ljava/nio/file/Path;", "getPaths", "", "intellij.jupyter.py"})
public final class ManagedPyHelperProvider
implements JupyterPyHelperProvider {
    @Override
    public boolean isApplicable(@NotNull BackedNotebookVirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JupyterServerConfig config = JupyterConnectionSettingsManager.Companion.getInstance().getConfigForVirtualFile(file, project);
        boolean isManaged = config instanceof JupyterManagedServerConfig;
        Sdk sdk = JupyterPyHelperProvider.Companion.getSdk(file, project);
        boolean isWsl = sdk != null && (sdk = PyStatisticToolsKt.getExecutionType((Sdk)sdk)) != null ? sdk.isWsl() : false;
        return isManaged && !isWsl;
    }

    @Override
    @NotNull
    public Path getServerRoot() {
        throw new IllegalStateException("Server root is not exists for managed server".toString());
    }

    @Override
    @NotNull
    public List<Path> getPaths(@NotNull BackedNotebookVirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JupyterPyHelperProvider.Companion.getLocalPaths();
    }
}

