/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables.inline;

import com.intellij.jupyter.core.editor.settings.JupyterShowInlineValuesSettingMode;
import com.intellij.jupyter.core.executor.JupyterExecutionState;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterRuntimeInlineValueRenderer;
import com.intellij.jupyter.py.variables.inline.JupyterFrameValues;
import com.intellij.jupyter.py.variables.inline.JupyterInlineValueCustomizer;
import com.intellij.jupyter.py.variables.inline.JupyterInlineValuePosition;
import com.intellij.jupyter.py.variables.inline.JupyterRuntimeInlineValuesHandler;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.ui.XDebuggerEntityConverter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.inline.InlineDebugRenderer;
import com.intellij.xdebugger.impl.inline.InlineDebugRendererBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001.B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020%H\u0016J \u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020\u000eH\u0002J\f\u0010-\u001a\u00020,*\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001a\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006/"}, d2={"Lcom/intellij/jupyter/py/variables/inline/JupyterInlineValueVisitor;", "Lcom/jetbrains/python/psi/PyRecursiveElementVisitor;", "jupyterEditor", "Lcom/intellij/openapi/editor/Editor;", "frameValues", "Lcom/intellij/jupyter/py/variables/inline/JupyterFrameValues;", "debugSession", "Lcom/intellij/xdebugger/XDebugSession;", "inlineValuesMode", "Lcom/intellij/jupyter/core/editor/settings/JupyterShowInlineValuesSettingMode;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/jupyter/py/variables/inline/JupyterFrameValues;Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/jupyter/core/editor/settings/JupyterShowInlineValuesSettingMode;)V", "visitedLines", "", "", "variablesWithLineNumber", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlineValueVisitor$LineVariable;", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "selectedLine", "getSelectedLine", "()I", "selectedLine$delegate", "Lkotlin/Lazy;", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "getCellLines", "()Lcom/intellij/notebooks/visualization/NotebookCellLines;", "cellLines$delegate", "visitPyAssignmentStatement", "", "node", "Lcom/jetbrains/python/psi/PyAssignmentStatement;", "visitPyReferenceExpression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "addInlineValueRenderForNode", "lineNumber", "nodeName", "", "Lcom/jetbrains/python/psi/PyElement;", "isFromUnexecutedCell", "", "isValidOffset", "LineVariable", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterInlineValueVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterInlineValueVisitor.kt\ncom/intellij/jupyter/py/variables/inline/JupyterInlineValueVisitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,115:1\n14060#2,2:116\n*S KotlinDebug\n*F\n+ 1 JupyterInlineValueVisitor.kt\ncom/intellij/jupyter/py/variables/inline/JupyterInlineValueVisitor\n*L\n45#1:116,2\n*E\n"})
public final class JupyterInlineValueVisitor
extends PyRecursiveElementVisitor {
    @NotNull
    private final Editor jupyterEditor;
    @NotNull
    private final JupyterFrameValues frameValues;
    @NotNull
    private final XDebugSession debugSession;
    @NotNull
    private final JupyterShowInlineValuesSettingMode inlineValuesMode;
    @NotNull
    private final Set<Integer> visitedLines;
    @NotNull
    private final Set<LineVariable> variablesWithLineNumber;
    @NotNull
    private final Lazy selectedLine$delegate;
    @NotNull
    private final Lazy cellLines$delegate;

    public JupyterInlineValueVisitor(@NotNull Editor jupyterEditor, @NotNull JupyterFrameValues frameValues, @NotNull XDebugSession debugSession, @NotNull JupyterShowInlineValuesSettingMode inlineValuesMode) {
        Intrinsics.checkNotNullParameter((Object)jupyterEditor, (String)"jupyterEditor");
        Intrinsics.checkNotNullParameter((Object)frameValues, (String)"frameValues");
        Intrinsics.checkNotNullParameter((Object)debugSession, (String)"debugSession");
        Intrinsics.checkNotNullParameter((Object)inlineValuesMode, (String)"inlineValuesMode");
        this.jupyterEditor = jupyterEditor;
        this.frameValues = frameValues;
        this.debugSession = debugSession;
        this.inlineValuesMode = inlineValuesMode;
        this.visitedLines = new LinkedHashSet();
        this.variablesWithLineNumber = new LinkedHashSet();
        this.selectedLine$delegate = LazyKt.lazy(() -> JupyterInlineValueVisitor.selectedLine_delegate$lambda$0(this));
        this.cellLines$delegate = LazyKt.lazy(() -> JupyterInlineValueVisitor.cellLines_delegate$lambda$0(this));
    }

    private final Document getDocument() {
        Document document = this.jupyterEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return document;
    }

    private final int getSelectedLine() {
        Lazy lazy = this.selectedLine$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final NotebookCellLines getCellLines() {
        Lazy lazy = this.cellLines$delegate;
        return (NotebookCellLines)lazy.getValue();
    }

    public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.jupyterEditor.isDisposed()) {
            return;
        }
        PyExpression[] pyExpressionArray = node.getTargets();
        Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getTargets(...)");
        Object[] $this$forEach$iv = pyExpressionArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name;
            int offset;
            PyExpression target = (PyExpression)element$iv;
            boolean bl = false;
            if (target.getName() == null || !this.isValidOffset(offset = target.getTextOffset())) continue;
            int line = this.getDocument().getLineNumber(offset);
            if (this.inlineValuesMode == JupyterShowInlineValuesSettingMode.CURRENT_LINE && line != this.getSelectedLine() || !this.visitedLines.add(line) || this.isFromUnexecutedCell(line)) continue;
            this.addInlineValueRenderForNode(line, name, (PyElement)node);
        }
        super.visitPyAssignmentStatement(node);
    }

    public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.jupyterEditor.isDisposed()) {
            return;
        }
        super.visitPyReferenceExpression(node);
        if (!Intrinsics.areEqual((Object)ScopeUtil.getScopeOwner((PsiElement)((PsiElement)node)), (Object)this.frameValues.getScopeOwner())) {
            return;
        }
        String string = node.getName();
        if (string == null) {
            return;
        }
        String name = string;
        int offset = node.getTextOffset();
        if (!this.isValidOffset(offset)) {
            return;
        }
        int line = this.getDocument().getLineNumber(offset);
        if (line != this.getSelectedLine()) {
            return;
        }
        if (this.isFromUnexecutedCell(line)) {
            return;
        }
        this.addInlineValueRenderForNode(line, name, (PyElement)node);
    }

    private final void addInlineValueRenderForNode(int lineNumber, String nodeName, PyElement node) {
        if (!this.variablesWithLineNumber.add(new LineVariable(lineNumber, nodeName))) {
            return;
        }
        PsiFile psiFile2 = node.getContainingFile();
        if (psiFile2 == null || (psiFile2 = psiFile2.getVirtualFile()) == null) {
            return;
        }
        PsiFile virtualFile = psiFile2;
        PyDebugValue pyDebugValue = this.frameValues.getValue(nodeName);
        if (pyDebugValue == null) {
            return;
        }
        PyDebugValue pyDebugValue2 = pyDebugValue;
        List list = pyDebugValue2.getValueNodes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueNodes(...)");
        Object object = CollectionsKt.firstOrNull((List)list);
        XValueNodeImpl xValueNodeImpl = object instanceof XValueNodeImpl ? (XValueNodeImpl)object : null;
        if (xValueNodeImpl == null) {
            return;
        }
        XValueNodeImpl valueNodeImpl = xValueNodeImpl;
        JupyterInlineValueCustomizer.INSTANCE.customize(pyDebugValue2);
        InlineDebugRendererBase renderer = switch (WhenMappings.$EnumSwitchMapping$0[this.inlineValuesMode.ordinal()]) {
            case 1 -> (InlineDebugRendererBase)new InlineDebugRenderer(valueNodeImpl, (VirtualFile)virtualFile, 0, XDebuggerEntityConverter.asProxy((XDebugSession)this.debugSession));
            case 2 -> (InlineDebugRendererBase)new JupyterRuntimeInlineValueRenderer(valueNodeImpl, (XSourcePosition)new JupyterInlineValuePosition((VirtualFile)virtualFile), this.debugSession);
            default -> throw new NoWhenBranchMatchedException();
        };
        this.jupyterEditor.getInlayModel().addAfterLineEndElement(node.getTextOffset() + 1, new InlayProperties().disableSoftWrapping(true), (EditorCustomElementRenderer)renderer);
    }

    private final boolean isFromUnexecutedCell(int lineNumber) {
        JupyterExecutionState jupyterExecutionState = JupyterExecutionState.Companion.getJupyterExecutionState(this.jupyterEditor);
        if (jupyterExecutionState == null) {
            return false;
        }
        JupyterExecutionState executionInfo = jupyterExecutionState;
        NotebookCellLines.Interval interval = this.getCellLines().getCellByLineNumber(lineNumber);
        if (interval == null) {
            return false;
        }
        NotebookCellLines.Interval intervalForLine = interval;
        ProgressStatus progressStatus = executionInfo.getProgressStatus(intervalForLine.getOrdinal());
        return JupyterRuntimeInlineValuesHandler.Companion.getNOT_EXECUTED_STATUSES$intellij_jupyter_py().contains(progressStatus);
    }

    private final boolean isValidOffset(int $this$isValidOffset) {
        return $this$isValidOffset >= 0 && $this$isValidOffset < this.getDocument().getTextLength();
    }

    private static final int selectedLine_delegate$lambda$0(JupyterInlineValueVisitor this$0) {
        CaretModel caretModel = this$0.jupyterEditor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        return this$0.getDocument().getLineNumber(caretModel2.getOffset());
    }

    private static final NotebookCellLines cellLines_delegate$lambda$0(JupyterInlineValueVisitor this$0) {
        return NotebookCellLines.Companion.get(this$0.jupyterEditor);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/py/variables/inline/JupyterInlineValueVisitor$LineVariable;", "", "lineNumber", "", "varName", "", "<init>", "(ILjava/lang/String;)V", "getLineNumber", "()I", "getVarName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.jupyter.py"})
    private static final class LineVariable {
        private final int lineNumber;
        @NotNull
        private final String varName;

        public LineVariable(int lineNumber, @NotNull String varName) {
            Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
            this.lineNumber = lineNumber;
            this.varName = varName;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        @NotNull
        public final String getVarName() {
            return this.varName;
        }

        public final int component1() {
            return this.lineNumber;
        }

        @NotNull
        public final String component2() {
            return this.varName;
        }

        @NotNull
        public final LineVariable copy(int lineNumber, @NotNull String varName) {
            Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
            return new LineVariable(lineNumber, varName);
        }

        public static /* synthetic */ LineVariable copy$default(LineVariable lineVariable, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = lineVariable.lineNumber;
            }
            if ((n2 & 2) != 0) {
                string = lineVariable.varName;
            }
            return lineVariable.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "LineVariable(lineNumber=" + this.lineNumber + ", varName=" + this.varName + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.lineNumber);
            result2 = result2 * 31 + this.varName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineVariable)) {
                return false;
            }
            LineVariable lineVariable = (LineVariable)other;
            if (this.lineNumber != lineVariable.lineNumber) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.varName, (Object)lineVariable.varName);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterShowInlineValuesSettingMode.values().length];
            try {
                nArray[JupyterShowInlineValuesSettingMode.ENTIRE_NOTEBOOK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterShowInlineValuesSettingMode.CURRENT_LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

