/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.free;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.JSFrameworkSpecificHandler;
import com.intellij.lang.javascript.frameworks.jsx.JSXComponent;
import com.intellij.lang.javascript.frameworks.jsx.JSXEmbeddedContentUtil;
import com.intellij.lang.javascript.frameworks.jsx.JSXImplementation;
import com.intellij.lang.javascript.frameworks.jsx.JSXProp;
import com.intellij.lang.javascript.frameworks.jsx.JSXProps;
import com.intellij.lang.javascript.frameworks.jsx.JSXXmlExtension;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.react.free.ReactFilterProvider;
import com.intellij.react.free.ReactFrameworkSpecificHandlerKt;
import com.intellij.react.free.ReactPropTypesUtil;
import com.intellij.util.ThreeState;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0002J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/react/free/ReactFrameworkSpecificHandler;", "Lcom/intellij/lang/javascript/frameworks/JSFrameworkSpecificHandler;", "<init>", "()V", "findExpectedType", "Lcom/intellij/lang/javascript/psi/JSType;", "element", "Lcom/intellij/psi/PsiElement;", "parent", "expectedTypeKind", "Lcom/intellij/lang/javascript/psi/JSExpectedTypeKind;", "addDeprecatedStyleSheetDotCreateTypes", "property", "Lcom/intellij/lang/javascript/psi/JSProperty;", "literal", "Lcom/intellij/lang/javascript/psi/JSObjectLiteralExpression;", "addIfResolved", "", "elementOld", "styles", "", "isStyleSheetCreate", "", "call", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "computeExpectedTypeForReactField", "node", "Lcom/intellij/lang/javascript/psi/JSField;", "computeExpectedTypeFromEmbeddedContent", "embeddedContent", "Lcom/intellij/lang/javascript/psi/JSEmbeddedContent;", "intellij.react.free"})
public final class ReactFrameworkSpecificHandler
implements JSFrameworkSpecificHandler {
    @Nullable
    public JSType findExpectedType(@NotNull PsiElement element, @Nullable PsiElement parent, @NotNull JSExpectedTypeKind expectedTypeKind) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)expectedTypeKind, (String)"expectedTypeKind");
        if (!DialectDetector.isJSX((PsiElement)element)) {
            return null;
        }
        if (parent instanceof JSField && ((JSField)parent).getTypeElement() == null && expectedTypeKind != JSExpectedTypeKind.TYPE_CHECKING) {
            return this.computeExpectedTypeForReactField((JSField)parent);
        }
        if (parent instanceof JSEmbeddedContent) {
            return this.computeExpectedTypeFromEmbeddedContent((JSEmbeddedContent)parent);
        }
        if (parent instanceof JSProperty && expectedTypeKind == JSExpectedTypeKind.EXPECTED) {
            PsiElement literalCandidate = ((JSProperty)parent).getParent();
            return literalCandidate instanceof JSObjectLiteralExpression ? this.addDeprecatedStyleSheetDotCreateTypes((JSProperty)parent, (JSObjectLiteralExpression)literalCandidate) : null;
        }
        return null;
    }

    private final JSType addDeprecatedStyleSheetDotCreateTypes(JSProperty property, JSObjectLiteralExpression literal) {
        Class[] classArray = new Class[]{JSExecutionScope.class};
        JSCallExpression callExpression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)literal), JSCallExpression.class, (boolean)true, (Class[])classArray);
        if (this.isStyleSheetCreate(callExpression)) {
            JSTypeSource jSTypeSource = JSTypeSourceFactory.createTypeSource((PsiElement)((PsiElement)property), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)jSTypeSource, (String)"createTypeSource(...)");
            JSTypeSource source = jSTypeSource;
            List styles = new ArrayList(ReactFrameworkSpecificHandlerKt.access$getSTYLES$p().length);
            for (String style : ReactFrameworkSpecificHandlerKt.access$getSTYLES$p()) {
                JSType elementNew;
                JSType elementOld;
                Intrinsics.checkNotNullExpressionValue((Object)JSNamedTypeFactory.createType((String)("__React." + style + "Style"), (JSTypeSource)source, (JSContext)JSContext.INSTANCE), (String)"createType(...)");
                this.addIfResolved(elementOld, styles);
                Intrinsics.checkNotNullExpressionValue((Object)JSNamedTypeFactory.createType((String)("React." + style + "Style"), (JSTypeSource)source, (JSContext)JSContext.INSTANCE), (String)"createType(...)");
                this.addIfResolved(elementNew, styles);
            }
            if (!((Collection)styles).isEmpty()) {
                return JSCompositeTypeFactory.createUnionType((JSTypeSource)source, (Collection)styles);
            }
        }
        return null;
    }

    private final void addIfResolved(JSType elementOld, List<JSType> styles) {
        if (elementOld instanceof JSResolvableType) {
            Collection collection = ((JSResolvableType)elementOld).getDeclarations();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDeclarations(...)");
            if (!collection.isEmpty()) {
                styles.add(elementOld);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isStyleSheetCreate(JSCallExpression call) {
        if (call == null) return false;
        if (!(call.getMethodExpression() instanceof JSReferenceExpression)) return false;
        String[] stringArray = new String[]{"StyleSheet", "create"};
        if (!JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)((JSReferenceExpression)call.getMethodExpression()), (String[])stringArray)) return false;
        return true;
    }

    private final JSType computeExpectedTypeForReactField(JSField node) {
        JSType propsType;
        JSClass jsClass;
        if (StringUtil.equals((CharSequence)node.getName(), (CharSequence)"defaultProps") && node.getJSContext() == JSContext.STATIC && (jsClass = JSUtils.getMemberContainingClass((PsiElement)((PsiElement)node))) != null && ReactFilterProvider.isAcceptableClassComponent(jsClass) == ThreeState.YES && (propsType = ReactPropTypesUtil.getClassComponentGenericType(jsClass, false)) != null) {
            return propsType;
        }
        return null;
    }

    private final JSType computeExpectedTypeFromEmbeddedContent(JSEmbeddedContent embeddedContent) {
        JSXComponent component;
        JSXProps props;
        JSXProp children;
        XmlElement owner = JSXEmbeddedContentUtil.findOwner((JSEmbeddedContent)embeddedContent);
        if (owner instanceof XmlAttribute) {
            XmlAttributeDescriptor xmlAttributeDescriptor = ((XmlAttribute)owner).getDescriptor();
            if (xmlAttributeDescriptor == null) {
                return null;
            }
            XmlAttributeDescriptor descriptor = xmlAttributeDescriptor;
            JSType type = JSXXmlExtension.getType((XmlAttributeDescriptor)descriptor);
            return !descriptor.isRequired() && TypeScriptConfigUtil.strictNullChecks((PsiElement)((PsiElement)embeddedContent)) ? JSTypeGuardUtil.wrapWithUndefined((JSType)type, null) : type;
        }
        if (owner instanceof JSXXmlLiteralExpressionImpl && JSXResolveUtil.isComponentName((String)((JSXXmlLiteralExpressionImpl)owner).getName()) && (children = (props = (component = JSXImplementation.Companion.getComponent((XmlTag)owner)).getProps()).get("children")) != null) {
            return children.getJsType();
        }
        return null;
    }
}

