/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.free;

import com.intellij.documentation.mdn.MdnApiNamespace;
import com.intellij.documentation.mdn.MdnDocumentationKt;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.jsx.JSXComponent;
import com.intellij.lang.javascript.frameworks.jsx.JSXImplementation;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.typescript.documentation.TypeScriptDocumentationProvider;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.html.dtd.HtmlSymbolDeclaration;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class ReactTagDocumentationProvider
implements DocumentationProvider {
    private final TypeScriptDocumentationProvider myProvider = new TypeScriptDocumentationProvider();

    public List<String> getUrlFor(PsiElement element, @Nullable PsiElement originalElement) {
        MdnSymbolDocumentation documentation = ReactTagDocumentationProvider.getSymbolDocumentation(element, originalElement);
        return documentation != null ? ContainerUtil.packNullables((Object[])new String[]{documentation.getUrl()}) : null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (!DialectDetector.isJSX((PsiElement)element)) {
            return null;
        }
        PsiElement psiElement = element.getParent();
        if (psiElement instanceof XmlTag) {
            XmlElementDescriptor tagDescriptor;
            XmlTag tag = (XmlTag)psiElement;
            if (object instanceof String && (tagDescriptor = (XmlElementDescriptor)ObjectUtils.doIfNotNull((Object)tag, XmlTag::getDescriptor)) != null) {
                return (PsiElement)ObjectUtils.doIfNotNull((Object)tagDescriptor.getAttributeDescriptor((String)object, tag), PsiMetaData::getDeclaration);
            }
        }
        return null;
    }

    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        MdnSymbolDocumentation documentation = ReactTagDocumentationProvider.getSymbolDocumentation(element = ReactTagDocumentationProvider.resolveReactComponent(element, originalElement), originalElement);
        if (documentation == null) {
            if (!(originalElement instanceof XmlToken)) {
                return null;
            }
            return this.myProvider.generateDoc(element, originalElement);
        }
        String originalDoc = this.myProvider.generateDoc(element, originalElement);
        if (originalDoc != null) {
            int definitionEnd = originalDoc.indexOf("</pre></div>");
            return originalDoc.substring(0, definitionEnd + "</pre></div>".length()) + documentation.getDocumentation(false);
        }
        return documentation.getDocumentation(true);
    }

    @Nullable
    private static PsiElement resolveReactComponent(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        JSXComponent component;
        Collection elements;
        PsiElement parent;
        if (element instanceof JSCallExpression && originalElement != null && (parent = originalElement.getParent()) instanceof XmlTag && JSXResolveUtil.isComponentName((String)((XmlTag)parent).getName()) && (elements = (component = JSXImplementation.getComponent((XmlTag)((XmlTag)parent))).getElements()).size() == 1) {
            return (PsiElement)ContainerUtil.getFirstItem((Collection)elements);
        }
        return element;
    }

    @Nullable
    private static MdnSymbolDocumentation getSymbolDocumentation(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof HtmlSymbolDeclaration) {
            return MdnDocumentationKt.getHtmlMdnDocumentation((PsiElement)element, (XmlTag)((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class, (boolean)false)));
        }
        if (!(element instanceof TypeScriptPropertySignature && element.getParent() instanceof TypeScriptObjectType && element.getParent().getParent() instanceof TypeScriptInterface && (element.getContainingFile().getVirtualFile().getPath().endsWith("@types/react/index.d.ts") || element.getContainingFile().getName().equals("react.d.ts")))) {
            return null;
        }
        String interfaceName = ((TypeScriptInterface)element.getParent().getParent()).getName();
        if (interfaceName == null) {
            return null;
        }
        if (interfaceName.endsWith("HTMLAttributes")) {
            String attributeName = Strings.toLowerCase((String)((TypeScriptPropertySignature)element).getMemberName());
            String elementName = interfaceName.substring(0, interfaceName.length() - "HTMLAttributes".length());
            MdnSymbolDocumentation documentation = MdnDocumentationKt.getHtmlMdnAttributeDocumentation((MdnApiNamespace)MdnApiNamespace.Html, (String)Strings.toLowerCase((String)elementName), (String)attributeName);
            if (documentation != null) {
                return documentation;
            }
            if (elementName.equals("img")) {
                elementName = "image";
            }
            if ((documentation = MdnDocumentationKt.getJsMdnDocumentation((MdnApiNamespace)MdnApiNamespace.WebApi, (String)("html" + elementName + "element." + attributeName))) != null) {
                return documentation;
            }
            documentation = MdnDocumentationKt.getJsMdnDocumentation((MdnApiNamespace)MdnApiNamespace.WebApi, (String)("element." + attributeName));
            return documentation;
        }
        if (interfaceName.endsWith("SVGAttributes")) {
            String attributeName = Strings.toLowerCase((String)((TypeScriptPropertySignature)element).getMemberName());
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
            String tagName = Strings.toLowerCase((String)((String)ObjectUtils.doIfNotNull((Object)tag, XmlTag::getName)));
            return MdnDocumentationKt.getHtmlMdnAttributeDocumentation((MdnApiNamespace)MdnApiNamespace.Svg, (String)tagName, (String)attributeName);
        }
        if (interfaceName.equals("IntrinsicElements")) {
            String tagName = Strings.toLowerCase((String)((TypeScriptPropertySignature)element).getMemberName());
            MdnSymbolDocumentation documentation = MdnDocumentationKt.getHtmlMdnTagDocumentation((MdnApiNamespace)MdnApiNamespace.Html, (String)tagName);
            if (documentation != null) {
                return documentation;
            }
            return MdnDocumentationKt.getHtmlMdnTagDocumentation((MdnApiNamespace)MdnApiNamespace.Svg, (String)tagName);
        }
        return null;
    }
}

