/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm.gui;

import com.intellij.liquibase.orm.gui.ChangeLogPreviewDialog;
import com.intellij.liquibase.orm.gui.ChangeLogTree;
import com.intellij.liquibase.orm.gui.InitLoadingPanel;
import com.intellij.liquibase.orm.gui.MergeAddColumnPanel;
import com.intellij.liquibase.orm.gui.MergeCreateSequencePanel;
import com.intellij.liquibase.orm.gui.MergeCreateTablePanel;
import com.intellij.liquibase.orm.gui.MergeDropColumnPanel;
import com.intellij.liquibase.orm.gui.MergeDropSequencePanel;
import com.intellij.liquibase.orm.gui.MergeDropTablePanel;
import com.intellij.openapi.Disposable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/liquibase/orm/gui/AbstractChangePanel;", "Lcom/intellij/liquibase/orm/gui/InitLoadingPanel;", "dialog", "Lcom/intellij/liquibase/orm/gui/ChangeLogPreviewDialog;", "changeNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "<init>", "(Lcom/intellij/liquibase/orm/gui/ChangeLogPreviewDialog;Ljavax/swing/tree/DefaultMutableTreeNode;)V", "getDialog", "()Lcom/intellij/liquibase/orm/gui/ChangeLogPreviewDialog;", "getChangeNode", "()Ljavax/swing/tree/DefaultMutableTreeNode;", "createAntagonistChangePanel", "Ljava/awt/Component;", "tagName", "", "intellij.liquibase.orm"})
@SourceDebugExtension(value={"SMAP\nAbstractChangePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractChangePanel.kt\ncom/intellij/liquibase/orm/gui/AbstractChangePanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,28:1\n1#2:29\n*E\n"})
public abstract class AbstractChangePanel
extends InitLoadingPanel {
    @NotNull
    private final ChangeLogPreviewDialog dialog;
    @NotNull
    private final DefaultMutableTreeNode changeNode;

    public AbstractChangePanel(@NotNull ChangeLogPreviewDialog dialog, @NotNull DefaultMutableTreeNode changeNode) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialog), (String)"dialog");
        Intrinsics.checkNotNullParameter((Object)changeNode, (String)"changeNode");
        LayoutManager layoutManager = new BorderLayout();
        Disposable disposable = dialog.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        super(layoutManager, disposable);
        this.dialog = dialog;
        this.changeNode = changeNode;
    }

    @NotNull
    public final ChangeLogPreviewDialog getDialog() {
        return this.dialog;
    }

    @NotNull
    public final DefaultMutableTreeNode getChangeNode() {
        return this.changeNode;
    }

    @Nullable
    protected final Component createAntagonistChangePanel(@NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        ChangeLogTree tree = this.dialog.getTree();
        if (!tree.isNodeContainsIntentions(this.changeNode, tagName)) {
            return null;
        }
        return switch (tagName) {
            case "dropColumn" -> {
                MergeDropColumnPanel var4_4;
                MergeDropColumnPanel it = var4_4 = new MergeDropColumnPanel(this.dialog, this.changeNode);
                boolean $i$a$-takeIf-AbstractChangePanel$createAntagonistChangePanel$1 = false;
                yield (Component)((Object)(it.hasPopupNodes() ? var4_4 : null));
            }
            case "addColumn" -> {
                MergeAddColumnPanel var4_5;
                MergeAddColumnPanel it = var4_5 = new MergeAddColumnPanel(this.dialog, this.changeNode);
                boolean $i$a$-takeIf-AbstractChangePanel$createAntagonistChangePanel$2 = false;
                yield (Component)((Object)(it.hasPopupNodes() ? var4_5 : null));
            }
            case "dropTable" -> (Component)((Object)new MergeDropTablePanel(this.dialog, this.changeNode));
            case "createTable" -> (Component)((Object)new MergeCreateTablePanel(this.dialog, this.changeNode));
            case "createSequence" -> (Component)((Object)new MergeCreateSequencePanel(this.dialog, this.changeNode));
            case "dropSequence" -> (Component)((Object)new MergeDropSequencePanel(this.dialog, this.changeNode));
            default -> null;
        };
    }
}

