/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.orm.util;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/liquibase/orm/util/SqlFileHelper;", "", "<init>", "()V", "getDbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "sqlFile", "Lcom/intellij/psi/PsiFile;", "intellij.liquibase.orm"})
public final class SqlFileHelper {
    @NotNull
    public static final SqlFileHelper INSTANCE = new SqlFileHelper();

    private SqlFileHelper() {
    }

    @Nullable
    public final DbType getDbType(@NotNull PsiFile sqlFile) {
        Intrinsics.checkNotNullParameter((Object)sqlFile, (String)"sqlFile");
        if (!(sqlFile instanceof SqlFile)) {
            return null;
        }
        return switch (((SqlFile)sqlFile).getSqlLanguage().getID()) {
            case "MariaDB" -> DbType.MARIA;
            case "H2" -> DbType.H2;
            case "MySQL" -> DbType.MYSQL;
            case "PostgreSQL" -> DbType.POSTGRES;
            case "TSQL" -> DbType.MSSQL;
            case "Oracle" -> DbType.ORACLE;
            case "DB2", "DB2_IS", "DB2_ZOS" -> DbType.DB2;
            case "HSQLDB" -> DbType.HSQL;
            default -> null;
        };
    }
}

