/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowContextMenuActionBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.frontend.action.TerminalEditorWidgetListener;
import com.intellij.terminal.frontend.editor.TerminalViewVirtualFile;
import com.intellij.terminal.frontend.toolwindow.TerminalToolWindowTab;
import com.intellij.terminal.frontend.toolwindow.TerminalToolWindowTabsManager;
import com.intellij.terminal.frontend.toolwindow.TerminalToolWindowTabsManagerKt;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.ui.TerminalContainer;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/terminal/frontend/action/MoveTerminalSessionToEditorAction;", "Lcom/intellij/openapi/wm/ToolWindowContextMenuActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "content", "Lcom/intellij/ui/content/Content;", "performForReworkedTerminalTab", "project", "Lcom/intellij/openapi/project/Project;", "terminalTab", "Lcom/intellij/terminal/frontend/toolwindow/TerminalToolWindowTab;", "performForClassicTerminal", "widget", "Lcom/intellij/terminal/ui/TerminalWidget;", "update", "findReworkedTerminalTab", "findClassicTerminal", "intellij.terminal.frontend"})
public final class MoveTerminalSessionToEditorAction
extends ToolWindowContextMenuActionBase
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow, @Nullable Content content) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Project project = e.getProject();
        if (project == null || content == null) {
            return;
        }
        TerminalToolWindowTab reworkedTerminalTab = this.findReworkedTerminalTab(project, content);
        TerminalWidget classicTerminal = this.findClassicTerminal(e, content);
        if (reworkedTerminalTab != null) {
            this.performForReworkedTerminalTab(project, reworkedTerminalTab);
        } else if (classicTerminal != null) {
            this.performForClassicTerminal(project, classicTerminal, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performForReworkedTerminalTab(Project project, TerminalToolWindowTab terminalTab) {
        TerminalToolWindowTabsManager manager = TerminalToolWindowTabsManager.Companion.getInstance(project);
        manager.detachTab(terminalTab);
        TerminalViewVirtualFile file = new TerminalViewVirtualFile(terminalTab.getView());
        file.putUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN, true);
        try {
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file, true);
        }
        finally {
            file.putUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performForClassicTerminal(Project project, TerminalWidget widget, Content content) {
        TerminalToolWindowManager manager = TerminalToolWindowManager.getInstance(project);
        TerminalSessionVirtualFileImpl file = new TerminalSessionVirtualFileImpl(widget.getTerminalTitle().buildTitle(), widget, (SettingsProvider)manager.getTerminalRunner().getSettingsProvider());
        file.putUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN, true);
        try {
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file, true);
            JBTerminalWidget jBTerminalWidget = JBTerminalWidget.asJediTermWidget((TerminalWidget)widget);
            if (jBTerminalWidget != null) {
                JBTerminalWidget it = jBTerminalWidget;
                boolean bl = false;
                it.setListener((JBTerminalWidgetListener)new TerminalEditorWidgetListener(project, file));
            }
            manager.detachWidgetAndRemoveContent(content);
        }
        finally {
            file.putUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN, null);
        }
    }

    public void update(@NotNull AnActionEvent e, @NotNull ToolWindow toolWindow, @Nullable Content content) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Project project = e.getProject();
        if (project == null || !TerminalToolWindowManager.isTerminalToolWindow(toolWindow) || content == null || Registry.Companion.is("toolwindow.open.tab.in.editor")) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        TerminalToolWindowTab reworkedTerminalTab = this.findReworkedTerminalTab(project, content);
        TerminalWidget classicTerminal = this.findClassicTerminal(e, content);
        e.getPresentation().setEnabledAndVisible(reworkedTerminalTab != null || classicTerminal != null);
    }

    private final TerminalToolWindowTab findReworkedTerminalTab(Project project, Content content) {
        return TerminalToolWindowTabsManagerKt.findTabByContent(TerminalToolWindowTabsManager.Companion.getInstance(project), content);
    }

    private final TerminalWidget findClassicTerminal(AnActionEvent e, Content content) {
        TerminalWidget newWidget = (TerminalWidget)e.getDataContext().getData(TerminalContainer.TERMINAL_WIDGET_DATA_KEY);
        if (newWidget != null) {
            return newWidget;
        }
        JBTerminalWidget terminalWidget = (JBTerminalWidget)e.getDataContext().getData(JBTerminalWidget.TERMINAL_DATA_KEY);
        return terminalWidget != null && UIUtil.isAncestor((Component)content.getComponent(), (Component)((Component)terminalWidget)) ? terminalWidget.asNewWidget() : TerminalToolWindowManager.findWidgetByContent(content);
    }
}

